/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzXoW;
import com.aspose.words.internal.zzZds;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzJz;
import com.aspose.words.zzLB;
import com.aspose.words.zzWXh;
import com.aspose.words.zzWss;
import com.aspose.words.zzYDW;
import com.aspose.words.zzZ4V;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzW6S;
    private Node zzZON;
    private Node zzZPT;
    private int zzX9;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzhG(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzW6S == null) {
            return null;
        }
        if (this.zzW6S.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzW6S;
    }

    final CompositeNode zzYrV() {
        if (zzLB.zzWP0(this.getParentNode())) {
            return this.getParentNode().zzYrV();
        }
        return this.getParentNode();
    }

    final CompositeNode zzZhg() {
        if (zzLB.zzWP0(this.getParentNode()) || zzLB.zzYrF(this.getParentNode())) {
            return this.getParentNode().zzZhg();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzW6S != null) {
            return this.zzW6S.getDocument();
        }
        return null;
    }

    final Document zzVUO() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzWRu() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzZNU();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzZPT;
    }

    final Node zzYBW() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzLB.zzYIH((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzYB() {
        Node node = zzLB.zzZ5g(this.getPreviousSibling(), false);
        if (node == null && zzLB.zzWP0(this.getParentNode())) {
            node = this.getParentNode().zzYB();
        }
        return node;
    }

    final Node zz6A() {
        Node node = zzLB.zzW36(this.getNextSibling(), false);
        if (node == null && zzLB.zzWP0(this.getParentNode())) {
            node = this.getParentNode().zz6A();
        }
        return node;
    }

    final CompositeNode zzXPo() {
        Node node = this;
        while ((node = node.zzYB()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzqt() {
        Node node = this;
        while ((node = node.zz6A()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzZON;
    }

    final Node zzZfd() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzLB.zzYIH((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzVXy() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzZSJ() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYQK() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzLB.zzXp8(node)) continue;
            return false;
        }
        return true;
    }

    final boolean zzPv() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (zzLB.zzXp8(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZGT() {
        return this.zzZON;
    }

    final void zzuY(Node node) {
        this.zzZON = node;
    }

    final Node zzYiB() {
        return this.zzZPT;
    }

    final void zzZCB(Node node) {
        this.zzZPT = node;
    }

    final Node zzVY5() {
        Node node = this;
        if (node.zzZON != null) {
            node = this;
            return node.zzZON;
        }
        return this.getParentNode();
    }

    final int zzXD6() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzLB.zzY8D(this);
        boolean bl2 = zzLB.zzZmZ(this);
        boolean bl3 = zzLB.zznq(this);
        boolean bl4 = zzLB.zzPT(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzXD6() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzXD6() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zz45(isCloneChildren, new zz45(this));
    }

    Node zz45(boolean bl, zzYDW zzYDW2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzW6S != null) {
            node.zzW6S = this.getDocument().zzUh();
        }
        node.zzZON = null;
        node.zzZPT = null;
        if (zzYDW2 != null) {
            zzYDW2.zzYFx(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzXHX(StringBuilder stringBuilder) {
        zzXCa.zzYFr(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzWXh zzXZV() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzWXh zzWXh2 = zzXCa.zz45((Object)compositeNode, zzWXh.class);
            if (zzWXh2 == null) continue;
            return zzWXh2;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzR4(Node node) {
        this.zzW6S = node != null ? node : this.getDocument().zzUh();
    }

    final void zzhG(DocumentBase documentBase) {
        this.zzW6S = documentBase != null ? documentBase.zzUh() : null;
    }

    final boolean zzZq7(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzYB3() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzZgx(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzXKB(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzXLb(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzuL(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzYpB(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzY2Z(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzWJ7(Node node, Node node2) {
        this.getParentNode().zzYFr(node, node2, this);
    }

    final Node zzZ4m(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzWEK(Node node, Node node2) {
        this.getParentNode().zz45(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzZ4V zzZ4V2 = zzLB.zzX2d(saveFormat);
        return zzZ4V2.zzZ5l(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZ4V zzZ4V2 = zzLB.zzYFr(saveOptions);
        return zzZ4V2.zzZ5l(this);
    }

    final Node zzYPl(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzLB.zzWwQ(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzWss zzW8c() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzWss.zzZJB(node);
        }
        return zzWss.zzXN(this.getParentNode());
    }

    final zzWss zzxr() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzWss.zzXN(node);
        }
        return zzWss.zzZJB(this.getParentNode());
    }

    final boolean zz4M(Node node) {
        return Node.zzXN(this, node);
    }

    final boolean zzQP() {
        return this.getAncestor(1) == null;
    }

    static Node zzpv(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzZds<Node> zzZds2 = Node.zzVB(node);
        zzZds<Node> zzZds3 = Node.zzVB(node2);
        return Node.zz45(zzZds2, zzZds3);
    }

    static boolean zzXN(Node node, Node node2) {
        zzZds<Node> zzZds2;
        if (node == null || node2 == null) {
            return false;
        }
        zzZds<Node> zzZds3 = Node.zzVB(node);
        Node node3 = Node.zz45(zzZds3, zzZds2 = Node.zzVB(node2));
        if (node3 == null) {
            return false;
        }
        zzZds<Node> zzZds4 = zzZds3;
        if (zzZds4.size() == 0 || (zzZds4 = zzZds2).size() == 0) {
            zzZds4 = zzZds2;
            boolean bl = zzZds4.size() > 0;
            return bl;
        }
        Object e = zzZds3.peek();
        Object e2 = zzZds2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzZds<Node> zzVB(Node node) {
        zzZds<Node> zzZds2 = new zzZds<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzZds2.push(node2);
        }
        return zzZds2;
    }

    private static Node zz45(zzZds<Node> zzZds2, zzZds<Node> zzZds3) {
        Node node = null;
        while (zzZds2.peek() == zzZds3.peek()) {
            node = (Node)zzZds2.pop();
            zzZds3.pop();
            zzZds<Node> zzZds4 = zzZds2;
            if (zzZds4.size() != 0 && (zzZds4 = zzZds3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzX9;
    }

    public void setCustomNodeId(int value) {
        this.zzX9 = value;
    }

    private String zzXnw() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzXCa.zz45(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzXoW.zzYNo(stringBuilder.toString());
    }

    public String toString() {
        return zzXoW.zzYNo(zzXoW.zzYFr("{0} {1}", new Object[]{Node.nodeTypeToString(this.getNodeType()), this.zzXnw()}));
    }

    final Node zzTb(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzXXe(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    private boolean zzXXe(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zz45
    implements zzYDW {
        private Node zzWhW;
        private HashMap<Integer, Integer> zzEG;

        zz45(Node node) {
            this.zzWhW = node;
        }

        @Override
        public final void zzYFx(Node node, Node node2) {
            if (node == this.zzWhW) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzJz zzJz2 = (zzJz)((Object)node2);
            if (this.zzEG == null) {
                this.zzEG = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzXCa.zz45(this.zzEG, Integer.valueOf(zzJz2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzZJg();
                zzXCa.zzYFr(this.zzEG, Integer.valueOf(zzJz2.getIdInternal()), Integer.valueOf(n));
            }
            zzJz2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzXCa.zz45(this.zzEG, Integer.valueOf(zzJz2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzJz2.setParentIdInternal(n2);
            }
        }
    }
}

