/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.AiModel;
import com.aspose.words.CheckGrammarOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.IAiModelText;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Run;
import com.aspose.words.SummarizeOptions;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzXSc;
import com.aspose.words.internal.zzXoW;
import com.aspose.words.internal.zzY5Z;
import com.aspose.words.internal.zzY8J;
import com.aspose.words.internal.zzZa4;
import com.aspose.words.internal.zzZov;
import com.aspose.words.zzVRW;
import com.aspose.words.zzW24;
import com.aspose.words.zzWab;
import com.aspose.words.zzWjM;
import com.aspose.words.zzWwl;
import com.aspose.words.zzYKG;
import com.aspose.words.zzYYh;
import com.aspose.words.zzmR;
import java.util.ArrayList;

public abstract class OpenAiModel
extends AiModel
implements IAiModelText {
    private String zzX4G;
    private String zzej;
    private double zzWDX = 1.0;
    private double zzZWJ = 1.0;
    private int zzce = 1;

    protected OpenAiModel() {
    }

    public Document summarize(Document sourceDocument) throws Exception {
        return this.summarize(sourceDocument, null);
    }

    @Override
    public Document summarize(Document sourceDocument, SummarizeOptions options) throws Exception {
        String string = sourceDocument.toString(70);
        String string2 = this.zz45(string, options);
        Document document = zzWwl.zzWR1(zzW24.zzWku(string2));
        document.zzWo().add(32);
        return document;
    }

    public Document summarize(Document[] sourceDocuments) throws Exception {
        return this.summarize(sourceDocuments, null);
    }

    @Override
    public Document summarize(Document[] sourceDocuments, SummarizeOptions options) throws Exception {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = sourceDocuments;
        int n = sourceDocuments.length;
        for (int i = 0; i < n; ++i) {
            Document document = object[i];
            String string = document.toString(70);
            String string2 = this.zz45(string, options);
            zzXCa.zz45(stringBuilder, string2);
        }
        object = this.zz45(stringBuilder.toString(), options);
        Document document = zzWwl.zzWR1(zzW24.zzWku((String)object));
        document.zzWo().add(32);
        return document;
    }

    @Override
    public Document translate(Document sourceDocument, int targetLanguage) throws Exception {
        NodeCollection nodeCollection;
        Document document = sourceDocument.deepClone();
        document.joinRunsWithSameFormatting();
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document, new zzYYh(), true);
        ArrayList<Node> arrayList = nodeCollection.zzZEC();
        if (arrayList.size() == 0) {
            return document;
        }
        document.zzWo().add(32);
        zzWwl.zzZWj(arrayList);
        String string = zzWwl.zzXbn(arrayList);
        ArrayList<zzmR> arrayList2 = new ArrayList<zzmR>();
        zzY5Z.zz45(arrayList2, new zzVRW(zzXoW.zzYFr("Never write any explanations. Pay special attention to never translating '{0}' and leaving it in the text as is. ", new Object[]{"___run___"})));
        String string2 = zzXoW.zzYFx(this.zz45(string, targetLanguage, arrayList2), "\r\n".toCharArray());
        if ("CanNotTranslate!".equals(string2)) {
            return document;
        }
        zzZov zzZov2 = zzWwl.zzYFr(string2, arrayList);
        zzZov zzZov3 = zzWwl.zzYFr(zzZov2, arrayList.size() - 1);
        for (int i = 0; i < zzZov3.getCount(); ++i) {
            int n = zzZov3.get(i);
            this.zzYFr((Run)arrayList.get(n), targetLanguage);
        }
        return document;
    }

    @Override
    final String zzXV5(ArrayList<zzmR> arrayList, int n) {
        zzWjM zzWjM2 = new zzWjM();
        zzWjM2.zzYtF("{\n");
        zzWjM2.zzXdO("model", this.getName());
        if (this.zzce != 1) {
            zzWjM2.zzWOi("n", this.zzce);
        }
        if (!zzXSc.zzZpl(this.zzZWJ, 1.0)) {
            zzWjM2.zzWRN("top_p", this.zzZWJ);
        }
        if (!zzXSc.zzZpl(this.zzWDX, 1.0)) {
            zzWjM2.zzWRN("temperature", this.zzWDX);
        }
        zzWjM2.zzYKD("messages", arrayList);
        zzWjM2.zzYtF("\n}");
        return zzWjM2.toString();
    }

    public OpenAiModel withOrganization(String organizationId) {
        String string = organizationId;
        OpenAiModel openAiModel = this;
        this.zzX4G = string;
        return this;
    }

    public OpenAiModel withProject(String projectId) {
        String string = projectId;
        OpenAiModel openAiModel = this;
        this.zzej = string;
        return this;
    }

    ArrayList<zzmR> zzhG(CheckGrammarOptions checkGrammarOptions) {
        ArrayList<zzmR> arrayList = new ArrayList<zzmR>();
        zzY5Z.zz45(arrayList, new zzVRW("Don't write any explanations in response."));
        zzY5Z.zz45(arrayList, new zzVRW("Respond in the same language as the source text."));
        if (checkGrammarOptions != null && checkGrammarOptions.getImproveStylistics()) {
            zzY5Z.zz45(arrayList, new zzVRW("Paraphrase output text more nicely."));
        }
        zzY5Z.zz45(arrayList, new zzVRW(zzXoW.zzYFr("Always preserve every '{0}' in text and do not change it, even at the very start, middle or end of text.", new Object[]{"run___"})));
        zzY5Z.zz45(arrayList, new zzVRW("Make sure there is a punctuation mark at the very end of text."));
        zzY5Z.zz45(arrayList, new zzVRW(zzXoW.zzYFr("Check spelling and grammar and correct all found errors ignoring every '{0}'.", new Object[]{"run___"})));
        zzY5Z.zz45(arrayList, new zzVRW(zzXoW.zzYFr("Don't add any punctuation or whitespace character immediately after the numbers coming immediately after the {0}.", new Object[]{"run___"})));
        zzY5Z.zz45(arrayList, new zzVRW("The text is the following."));
        return arrayList;
    }

    private String zz45(String string, SummarizeOptions summarizeOptions) throws Exception {
        Object object;
        ArrayList<zzYKG> arrayList = this.zzYFr(string, summarizeOptions);
        while (arrayList.size() > 1) {
            object = OpenAiModel.zzXC5(arrayList);
            arrayList = this.zzYFr((String)object, summarizeOptions);
        }
        object = arrayList.get(0);
        if (object == null || ((zzYKG)object).zzWP().size() == 0) {
            return "";
        }
        return ((zzYKG)object).zzWP().get(0);
    }

    private ArrayList<zzYKG> zzYFr(String string, SummarizeOptions summarizeOptions) throws Exception {
        ArrayList<zzYKG> arrayList = new ArrayList<zzYKG>();
        String string2 = SummarizeOptions.zz45(summarizeOptions);
        ArrayList<zzmR> arrayList2 = new ArrayList<zzmR>();
        zzWab zzWab2 = new zzWab(zzXoW.zzYFr("Please summarize the following text in {0} sentences. The result must be in the same language in which this text is written.", new Object[]{string2}));
        zzY5Z.zz45(arrayList2, zzWab2);
        ArrayList<zzmR> arrayList3 = OpenAiModel.zzZET(string, 0x100000);
        zzY5Z.zz45(arrayList2, arrayList3);
        String string3 = this.zzZpR(arrayList2, 1);
        zzW24 zzW242 = new zzW24(string3);
        zzYKG zzYKG2 = zzYKG.zzWRN(zzW242);
        if (zzYKG2.zzYeN() == 1) {
            int n = zzYKG2.zz75().zzXRR();
            if (n == -1) {
                throw new Exception(zzXoW.zzYFr("Cannot parse resulted tokens: {0}", new Object[]{zzYKG2.zz75().getMessage()}));
            }
            zzWab2.zzNm("Please summarize the following text. The result must be in the same language in which this text is written.");
            double d = (double)this.getContextWindow() / (double)n;
            int n2 = (int)((double)string.length() * d);
            while (string.length() > n2) {
                int n3 = zzWwl.zzZZI(string, n2);
                if (n3 <= 0) {
                    throw new IllegalStateException("Cannot split by sentences. Please check ContextWindow");
                }
                zzY5Z.zz45(arrayList, this.zzYFr(string.substring(0, n3 + 0), summarizeOptions));
                int n4 = n3;
                string = string.substring(n4, n4 + (string.length() - n3));
            }
            if (string.length() > 0) {
                zzY5Z.zz45(arrayList, this.zzYFr(string, summarizeOptions));
            }
            return arrayList;
        }
        if (zzYKG2.zzYeN() != 0) {
            throw new Exception(zzYKG2.zz75().getMessage());
        }
        zzY5Z.zz45(arrayList, zzYKG2);
        return arrayList;
    }

    private void zzYFr(Run run, int n) throws Exception {
        if (zzY8J.zzOI(run.getText()) == -1) {
            return;
        }
        String string = zzXoW.zzYFx(this.zz45(run.getText(), n, null), "\r\n".toCharArray());
        if ("CanNotTranslate!".equals(string)) {
            return;
        }
        run.setText(string);
    }

    private String zz45(String string, int n, ArrayList<zzmR> arrayList) throws Exception {
        ArrayList<zzYKG> arrayList2 = this.zzYFr(string, n, arrayList);
        String string2 = OpenAiModel.zzXC5(arrayList2);
        return zzW24.zzWku(string2);
    }

    private ArrayList<zzYKG> zzYFr(String string, int n, ArrayList<zzmR> arrayList) throws Exception {
        String string2;
        ArrayList<zzYKG> arrayList2 = new ArrayList<zzYKG>();
        ArrayList<zzmR> arrayList3 = new ArrayList<zzmR>();
        if (arrayList != null) {
            zzY5Z.zz45(arrayList3, arrayList);
        }
        zzY5Z.zz45(arrayList3, new zzVRW(zzXoW.zzYFr("I will send you a text in any language and you will translate it to {0}.", new Object[]{zzWwl.zzYij(n)})));
        zzY5Z.zz45(arrayList3, new zzVRW("If provided text can not be translated, then respond only: CanNotTranslate!"));
        zzY5Z.zz45(arrayList3, new zzVRW("Always preserve all punctuations, digits and whitespace characters, even at the very start, middle or end of words."));
        ArrayList<zzmR> arrayList4 = OpenAiModel.zzZET(string, 0x100000);
        zzY5Z.zz45(arrayList3, arrayList4);
        double d = this.zzWDX;
        try {
            this.zzWDX = 0.3;
            string2 = this.zzZpR(arrayList3, 1);
        }
        finally {
            this.zzWDX = d;
        }
        zzW24 zzW242 = new zzW24(string2);
        zzYKG zzYKG2 = zzYKG.zzWRN(zzW242);
        if (zzYKG2.zzYeN() == 1) {
            int n2 = zzYKG2.zz75().zzXRR();
            if (n2 == -1) {
                throw new Exception(zzXoW.zzYFr("Cannot parse resulted tokens: {0}", new Object[]{zzYKG2.zz75().getMessage()}));
            }
            double d2 = (double)this.getContextWindow() / (double)n2;
            int n3 = (int)((double)string.length() * d2);
            while (string.length() > n3) {
                int n4 = zzWwl.zzZZI(string, n3);
                if (n4 <= 0) {
                    throw new IllegalStateException("Cannot split by sentences. Please check ContextWindow");
                }
                zzY5Z.zz45(arrayList2, this.zzYFr(string.substring(0, n4 + 0), n, arrayList));
                int n5 = n4;
                string = string.substring(n5, n5 + (string.length() - n4));
            }
            if (string.length() > 0) {
                zzY5Z.zz45(arrayList2, this.zzYFr(string, n, arrayList));
            }
            return arrayList2;
        }
        if (zzYKG2.zzYeN() != 0) {
            throw new Exception(zzYKG2.zz75().getMessage());
        }
        zzY5Z.zz45(arrayList2, zzYKG2);
        return arrayList2;
    }

    @Override
    final String zz45(String string, CheckGrammarOptions checkGrammarOptions) throws Exception {
        ArrayList<zzYKG> arrayList = this.zzYFr(string, checkGrammarOptions);
        String string2 = OpenAiModel.zzXC5(arrayList);
        return zzW24.zzWku(string2);
    }

    private ArrayList<zzYKG> zzYFr(String string, CheckGrammarOptions checkGrammarOptions) throws Exception {
        ArrayList<zzYKG> arrayList = new ArrayList<zzYKG>();
        ArrayList<zzmR> arrayList2 = this.zzhG(checkGrammarOptions);
        ArrayList<zzmR> arrayList3 = OpenAiModel.zzZET(string, 0x100000);
        zzY5Z.zz45(arrayList2, arrayList3);
        String string2 = this.zzZpR(arrayList2, 1);
        zzW24 zzW242 = new zzW24(string2);
        zzYKG zzYKG2 = zzYKG.zzWRN(zzW242);
        if (zzYKG2.zzYeN() == 1) {
            int n = zzYKG2.zz75().zzXRR();
            if (n == -1) {
                throw new Exception(zzXoW.zzYFr("Cannot parse resulted tokens: {0}", new Object[]{zzYKG2.zz75().getMessage()}));
            }
            double d = (double)this.getContextWindow() / (double)n;
            int n2 = (int)((double)string.length() * d);
            while (string.length() > n2) {
                int n3 = zzWwl.zzZZI(string, n2);
                if (n3 <= 0) {
                    throw new IllegalStateException("Cannot split by sentences. Please check ContextWindow");
                }
                zzY5Z.zz45(arrayList, this.zzYFr(string.substring(0, n3 + 0), checkGrammarOptions));
                int n4 = n3;
                string = string.substring(n4, n4 + (string.length() - n3));
            }
            if (string.length() > 0) {
                zzY5Z.zz45(arrayList, this.zzYFr(string, checkGrammarOptions));
            }
            return arrayList;
        }
        if (zzYKG2.zzYeN() != 0) {
            throw new Exception(zzYKG2.zz75().getMessage());
        }
        zzY5Z.zz45(arrayList, zzYKG2);
        return arrayList;
    }

    private static ArrayList<zzmR> zzZET(String string, int n) {
        zzXCa.zzYFx(n, "MaxStringLength");
        ArrayList<zzmR> arrayList = new ArrayList<zzmR>();
        String string2 = string;
        while (string2.length() > n) {
            zzY5Z.zz45(arrayList, new zzWab(string2.substring(0, n + 0)));
            int n2 = n;
            string2 = string2.substring(n2, n2 + (string2.length() - n));
        }
        zzY5Z.zz45(arrayList, new zzWab(string2));
        return arrayList;
    }

    private static String zzXC5(ArrayList<zzYKG> arrayList) {
        StringBuilder stringBuilder = new StringBuilder();
        for (zzYKG zzYKG2 : arrayList) {
            for (String string : zzYKG2.zzWP()) {
                zzXCa.zzYFr(stringBuilder, string);
            }
        }
        return stringBuilder.toString();
    }

    @Override
    protected String getUrl() {
        return "https://api.openai.com/";
    }

    @Override
    final String zzVZV() {
        return "v1/chat/completions";
    }

    @Override
    final String zzWDG() {
        return "";
    }

    @Override
    final zzZa4 zzWP9() {
        zzZa4 zzZa42 = new zzZa4();
        zzZa42.add("Authorization", zzXoW.zzYFr("Bearer {0}", new Object[]{this.zzUX()}));
        OpenAiModel openAiModel = this;
        if (zzY8J.zzXvF(openAiModel.zzX4G)) {
            openAiModel = this;
            zzZa42.add("OpenAI-Organization", openAiModel.zzX4G);
        }
        openAiModel = this;
        if (zzY8J.zzXvF(openAiModel.zzej)) {
            openAiModel = this;
            zzZa42.add("OpenAI-Project", openAiModel.zzej);
        }
        return zzZa42;
    }

    protected int getContextWindow() {
        return 16385;
    }

    protected int getMaxOutputTokens() {
        return 4096;
    }
}

