/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.FindReplaceOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.Node;
import com.aspose.words.Processor;
import com.aspose.words.ReplacerContext;
import com.aspose.words.Run;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWPP;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzWjz;
import com.aspose.words.internal.zzY8J;
import com.aspose.words.internal.zzZco;
import com.aspose.words.internal.zznl;
import com.aspose.words.zzLB;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Replacer
extends Processor {
    private ReplacerContext zzXrq;

    private Replacer(ReplacerContext context) {
        super(context);
        this.zzXrq = context;
    }

    public static Replacer create(ReplacerContext context) {
        return new Replacer(context);
    }

    @Override
    protected void executeCore() throws Exception {
        this.mResultDocument = this.zzVPV().zzSw();
        if (this.zzXrq.zzCm() != null) {
            this.zzXrq.zzGE(Replacer.zz45(this.mResultDocument, this.zzXrq.zzCm(), this.zzXrq.getReplacement(), this.zzXrq.getFindReplaceOptions()));
        } else {
            this.zzXrq.zzGE(Replacer.zz45(this.mResultDocument, this.zzXrq.zzVYd(), this.zzXrq.getReplacement(), this.zzXrq.getFindReplaceOptions()));
        }
        super.executeCore();
    }

    @Override
    protected void checkArgumentsSet() {
        if (this.zzXrq.zzCm() == null && !zzY8J.zzXvF(this.zzXrq.zzVYd())) {
            throw new IllegalArgumentException("Search pattern is not specified. Specify search pattern and replacement using ReplacerContext.SetReplacement method.");
        }
        super.checkArgumentsSet();
    }

    public static int replace(String inputFileName, String outputFileName, String pattern, String replacement) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZco.zzcq(outputFileName));
        return Replacer.replace(inputFileName, outputFileName, n, pattern, replacement);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, String pattern, String replacement) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, saveFormat, pattern, replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, zzLB.zzXky(saveFormat, outputFileName), pattern, replacement, options);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, saveOptions, pattern, replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.setReplacement(pattern, replacement);
        if (options != null) {
            replacerContext.zz45(options);
        }
        Replacer.create(replacerContext).from(inputFileName).to(outputFileName, saveOptions).execute();
        return replacerContext.zzZ47();
    }

    private static int zz45(zzWf9 zzWf92, zzWf9 zzWf93, int n, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zz45(zzWf92, zzWf93, zzLB.zzXky(n, null), string, string2, findReplaceOptions);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, String pattern, String replacement) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveFormat, pattern, replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveFormat, pattern, replacement, options);
    }

    private static int zz45(zzWf9 zzWf92, zzWf9 zzWf93, SaveOptions saveOptions, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.setReplacement(string, string2);
        if (findReplaceOptions != null) {
            replacerContext.zz45(findReplaceOptions);
        }
        Replacer.create(replacerContext).zz1k(zzWf92).zzYFr(zzWf93, saveOptions).execute();
        return replacerContext.zzZ47();
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveOptions, pattern, replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveOptions, pattern, replacement, options);
    }

    private static int zz45(String string, String string2, zznl zznl2, String string3) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZco.zzcq(string2));
        return Replacer.zz45(string, string2, n, zznl2, string3);
    }

    public static int replace(String inputFileName, String outputFileName, Pattern pattern, String replacement) throws Exception {
        return Replacer.zz45(inputFileName, outputFileName, zznl.zz45(pattern), replacement);
    }

    private static int zz45(String string, String string2, int n, zznl zznl2, String string3) throws Exception {
        return Replacer.zz45(string, string2, n, zznl2, string3, null);
    }

    private static int zz45(String string, String string2, int n, zznl zznl2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zz45(string, string2, zzLB.zzXky(n, string2), zznl2, string3, findReplaceOptions);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, Pattern pattern, String replacement) throws Exception {
        return Replacer.zz45(inputFileName, outputFileName, saveFormat, zznl.zz45(pattern), replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zz45(inputFileName, outputFileName, saveFormat, zznl.zz45(pattern), replacement, options);
    }

    private static int zz45(String string, String string2, SaveOptions saveOptions, zznl zznl2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYFr(zznl2, string3);
        if (findReplaceOptions != null) {
            replacerContext.zz45(findReplaceOptions);
        }
        Replacer.create(replacerContext).from(string).to(string2, saveOptions).execute();
        return replacerContext.zzZ47();
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return Replacer.zz45(inputFileName, outputFileName, saveOptions, zznl.zz45(pattern), replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zz45(inputFileName, outputFileName, saveOptions, zznl.zz45(pattern), replacement, options);
    }

    private static int zz45(zzWf9 zzWf92, zzWf9 zzWf93, int n, zznl zznl2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zz45(zzWf92, zzWf93, zzLB.zzXky(n, null), zznl2, string, findReplaceOptions);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, Pattern pattern, String replacement) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveFormat, zznl.zz45(pattern), replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveFormat, zznl.zz45(pattern), replacement, options);
    }

    private static int zz45(zzWf9 zzWf92, zzWf9 zzWf93, SaveOptions saveOptions, zznl zznl2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYFr(zznl2, string);
        if (findReplaceOptions != null) {
            replacerContext.zz45(findReplaceOptions);
        }
        Replacer.create(replacerContext).zz1k(zzWf92).zzYFr(zzWf93, saveOptions).execute();
        return replacerContext.zzZ47();
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveOptions, zznl.zz45(pattern), replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zz45(zzWf9.zzYFr(inputStream), (zzWf9)zzWf9.zzhG(outputStream), saveOptions, zznl.zz45(pattern), replacement, options);
    }

    private static zzWf9[] zz45(String string, ImageSaveOptions imageSaveOptions, String string2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zz45(string, imageSaveOptions, new zznl(zznl.zzZVT(string2)), string3, findReplaceOptions);
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(inputFileName, saveOptions, pattern, replacement, null));
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(inputFileName, saveOptions, pattern, replacement, options));
    }

    private static zzWf9[] zz45(zzWf9 zzWf92, ImageSaveOptions imageSaveOptions, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zz45(zzWf92, imageSaveOptions, new zznl(zznl.zzZVT(string)), string2, findReplaceOptions);
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(zzWf9.zzYFr(inputStream), saveOptions, pattern, replacement, null));
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(zzWf9.zzYFr(inputStream), saveOptions, pattern, replacement, options));
    }

    private static zzWf9[] zz45(String string, ImageSaveOptions imageSaveOptions, zznl zznl2, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYFr(zznl2, string2);
        if (findReplaceOptions != null) {
            replacerContext.zz45(findReplaceOptions);
        }
        ArrayList<zzWf9> arrayList = new ArrayList<zzWf9>();
        Replacer.create(replacerContext).from(string).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzWf9[] zzWf9Array = new zzWf9[]{};
        ArrayList<zzWf9> arrayList2 = arrayList;
        return arrayList2.toArray(zzWf9Array);
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(inputFileName, saveOptions, zznl.zz45(pattern), replacement, null));
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(inputFileName, saveOptions, zznl.zz45(pattern), replacement, options));
    }

    private static zzWf9[] zz45(zzWf9 zzWf92, ImageSaveOptions imageSaveOptions, zznl zznl2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYFr(zznl2, string);
        if (findReplaceOptions != null) {
            replacerContext.zz45(findReplaceOptions);
        }
        ArrayList<zzWf9> arrayList = new ArrayList<zzWf9>();
        Replacer.create(replacerContext).zz1k(zzWf92).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzWf9[] zzWf9Array = new zzWf9[]{};
        ArrayList<zzWf9> arrayList2 = arrayList;
        return arrayList2.toArray(zzWf9Array);
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(zzWf9.zzYFr(inputStream), saveOptions, zznl.zz45(pattern), replacement, null));
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzWf9.zzYFr(Replacer.zz45(zzWf9.zzYFr(inputStream), saveOptions, zznl.zz45(pattern), replacement, options));
    }

    private static int zz45(Document document, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        if (findReplaceOptions.getReplacementFormat() == 0) {
            return document.getRange().replace(string, string2, findReplaceOptions);
        }
        int n = document.getRange().replace(string, "[[WordizeTempPlaceholder]]", findReplaceOptions);
        Replacer.zz45(document, string2, findReplaceOptions.getReplacementFormat());
        return n;
    }

    private static int zz45(Document document, zznl zznl2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        if (findReplaceOptions.getReplacementFormat() == 0) {
            return document.getRange().zz45(zznl2, string, findReplaceOptions);
        }
        int n = document.getRange().zz45(zznl2, "[[WordizeTempPlaceholder]]", findReplaceOptions);
        Replacer.zz45(document, string, findReplaceOptions.getReplacementFormat());
        return n;
    }

    private static void zz45(Document document, String string, int n) throws Exception {
        DocumentBuilder documentBuilder = new DocumentBuilder(document);
        for (Node node : document.getChildNodes(21, true)) {
            Run run = (Run)node;
            if (!"[[WordizeTempPlaceholder]]".equals(run.getText())) continue;
            documentBuilder.moveTo(run);
            switch (n) {
                case 2: {
                    documentBuilder.insertHtml(string, 2);
                    break;
                }
                case 1: {
                    zzWPP zzWPP2 = new zzWPP(zzWjz.zzZtf().zzWlL(string));
                    try {
                        LoadOptions loadOptions = new LoadOptions();
                        loadOptions.setLoadFormat(63);
                        Document document2 = new Document(zzWPP2, loadOptions);
                        documentBuilder.insertDocumentInline(document2, 0, new ImportFormatOptions());
                        break;
                    }
                    finally {
                        zzWPP2.close();
                    }
                }
                default: {
                    documentBuilder.write(string);
                }
            }
            run.remove();
        }
    }
}

