/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzXoW;
import com.aspose.words.internal.zzY8J;
import com.aspose.words.internal.zzYCw;
import com.aspose.words.internal.zzYqn;
import com.aspose.words.internal.zzZ0o;
import com.aspose.words.zzWxX;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public final class Watermark {
    private Document zzYf3;
    private zzWxX zzX4t;

    Watermark(Document doc, zzWxX watermarkProvider) {
        this.zzYf3 = doc;
        this.zzX4t = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzZbp(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zz45(text, textWatermarkOptions, this.zzYf3);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzXCa.zzYFr((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzYf3, 75);
        shape.getImageData().setImage(image);
        this.zz45(shape, options, this.zzYf3);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzXCa.zzYFr((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzYf3, 75);
        shape.getImageData().setImage(imagePath);
        this.zz45(shape, options, this.zzYf3);
    }

    final void zz45(zzWf9 zzWf92, ImageWatermarkOptions imageWatermarkOptions) throws Exception {
        zzXCa.zzYFr((Object)zzWf92, "imageStream");
        Shape shape = new Shape((DocumentBase)this.zzYf3, 75);
        shape.getImageData().zzXC5(zzWf92);
        this.zz45(shape, imageWatermarkOptions, this.zzYf3);
    }

    public final void setImage(InputStream imageStream, ImageWatermarkOptions options) throws Exception {
        this.zz45(zzWf9.zzYFr(imageStream), options);
    }

    public final int getType() {
        Shape shape = this.zzX4t.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWM8();
        if (shape.zzVWQ()) {
            return 0;
        }
        if (shape.zzYbq()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzX4t.add(shape);
    }

    public final void remove() {
        this.zzX4t.remove();
    }

    private static void zzZbp(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzY8J.zzYPW(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzXCa.zz45(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zz45(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYFr(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzYiH(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYFr(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZik() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzZva()) / d2) > (double)(f = pageSetup.zzYYz())) {
            d = (double)f / d3;
        }
        shape.zzZRc(zzZ0o.zzhG(d2 * d, 2, 1));
        shape.zzZ1T(zzZ0o.zzhG(d3 * d, 2, 1));
    }

    private Shape zz45(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zz45(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzYiH(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zz45(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzYDH() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYCw zzYCw2 = document.zzYU3().zzhG(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYCw2.zzTb(shape.getTextPath().getText());
        if (textWatermarkOptions.zzYDH()) {
            l = Watermark.zz45(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzZRc(zzZ0o.zzhG(Float.intBitsToFloat(n), 2, 1));
        shape.zzZ1T(zzZ0o.zzhG(zzYqn.zzX2s(l), 2, 1));
    }

    private static long zz45(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzZva();
        float f2 = pageSetup.zzYYz();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzYqn.zzX2s(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzYqn.zzYCZ(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzYqn.zzX2s(l) >= Float.intBitsToFloat(n)) {
            return zzYqn.zzYCZ(f2 / f3, f2);
        }
        float f6 = f;
        return zzYqn.zzYCZ(f6, f6 * f3);
    }

    private static void zzYiH(Shape shape, String string) {
        shape.setName(zzXoW.zzYFr("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

