/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz47;
import com.aspose.words.internal.zz7w;
import com.aspose.words.internal.zzA9;
import com.aspose.words.internal.zzEL;
import com.aspose.words.internal.zzIY;
import com.aspose.words.internal.zzW97;
import com.aspose.words.internal.zzWDb;
import com.aspose.words.internal.zzWIX;
import com.aspose.words.internal.zzWY1;
import com.aspose.words.internal.zzWbe;
import com.aspose.words.internal.zzWdG;
import com.aspose.words.internal.zzWjM;
import com.aspose.words.internal.zzWms;
import com.aspose.words.internal.zzWpN;
import com.aspose.words.internal.zzWva;
import com.aspose.words.internal.zzWzd;
import com.aspose.words.internal.zzX12;
import com.aspose.words.internal.zzX6K;
import com.aspose.words.internal.zzX9z;
import com.aspose.words.internal.zzXMJ;
import com.aspose.words.internal.zzXQP;
import com.aspose.words.internal.zzXS1;
import com.aspose.words.internal.zzXrR;
import com.aspose.words.internal.zzY9w;
import com.aspose.words.internal.zzYJ5;
import com.aspose.words.internal.zzYP9;
import com.aspose.words.internal.zzYie;
import com.aspose.words.internal.zzYrr;
import com.aspose.words.internal.zzZ4V;
import com.aspose.words.internal.zzZEi;
import com.aspose.words.internal.zzZLl;
import com.aspose.words.internal.zzZT6;
import com.aspose.words.internal.zzpf;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class zzWFZ
extends X509Certificate {
    protected zzXQP zzZE4;
    protected zzWjM zztE;
    protected zzW97 zzZgu;
    protected boolean[] zzWyY;
    protected String zzMw;
    protected byte[] zzNO;

    zzWFZ(zzXQP zzXQP2, zzWjM zzWjM2, zzW97 zzW972, boolean[] blArray, String string, byte[] byArray) {
        this.zzZE4 = zzXQP2;
        this.zztE = zzWjM2;
        this.zzZgu = zzW972;
        this.zzWyY = blArray;
        this.zzMw = string;
        this.zzNO = byArray;
    }

    public final zzYP9 zzZLZ() {
        return this.zztE.zzVX9();
    }

    public final zzWms zzX4y() {
        return this.zztE.zzEg();
    }

    public final zzYP9 zzYGf() {
        return this.zztE.zzVRO();
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.zztE.zzjb().zzY6c());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.zztE.zzXNK().zzY6c());
        }
    }

    @Override
    public int getVersion() {
        return this.zztE.zzYv();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.zztE.zzXyJ().zzW4P();
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            byte[] byArray = this.zztE.zzVX9().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        try {
            byte[] byArray = this.zztE.zzVRO().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode subject DN");
        }
    }

    @Override
    public Date getNotBefore() {
        return this.zztE.zzXNK().zzXPK();
    }

    @Override
    public Date getNotAfter() {
        return this.zztE.zzjb().zzXPK();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.zztE.zzEg().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.zztE.zzWEG().zzYG2();
    }

    @Override
    public String getSigAlgName() {
        return this.zzMw;
    }

    @Override
    public String getSigAlgOID() {
        return this.zztE.zz32().zzX7I().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        return zzWbe.zzYEy(this.zzNO);
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        zzX6K zzX6K2 = this.zztE.zzEg().zzWD1();
        if (zzX6K2 != null) {
            byte[] byArray = zzX6K2.zzYqH();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzX6K2.zzR1()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        zzX6K zzX6K2 = this.zztE.zzEg().zzWlU();
        if (zzX6K2 != null) {
            byte[] byArray = zzX6K2.zzYqH();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzX6K2.zzR1()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        return zzWbe.zzYKD(this.zzWyY);
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = zzWFZ.zzYFr(this.zztE, "2.5.29.37");
        if (byArray == null) {
            return null;
        }
        try {
            zzX9z zzX9z2 = zzX9z.zzVU2(zzWva.zzX46(byArray));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i != zzX9z2.size(); ++i) {
                arrayList.add(((zzWzd)zzX9z2.zzXJC(i)).getId());
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException("error processing extended key usage extension");
        }
    }

    @Override
    public int getBasicConstraints() {
        if (this.zzZgu != null) {
            if (this.zzZgu.zzXFS()) {
                if (this.zzZgu.zzWI5() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.zzZgu.zzWI5().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return zzWFZ.zz45(this.zztE, zzWdG.zzZOd.getId());
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return zzWFZ.zz45(this.zztE, zzWdG.zzS6.getId());
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzWpN zzWpN2 = this.zztE.zzEg().zzXVd();
            if (zzWpN2 != null) {
                Enumeration enumeration = zzWpN2.zzZ5S();
                while (enumeration.hasMoreElements()) {
                    zzWzd zzWzd2 = (zzWzd)enumeration.nextElement();
                    zzWdG zzWdG2 = zzWpN2.zzWRN(zzWzd2);
                    if (!zzWdG2.isCritical()) continue;
                    hashSet.add(zzWzd2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        zzXrR zzXrR2 = zzWFZ.zzhG(this.zztE, oid);
        if (zzXrR2 != null) {
            try {
                return zzXrR2.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzWpN zzWpN2 = this.zztE.zzEg().zzXVd();
            if (zzWpN2 != null) {
                Enumeration enumeration = zzWpN2.zzZ5S();
                while (enumeration.hasMoreElements()) {
                    zzWzd zzWzd2 = (zzWzd)enumeration.nextElement();
                    zzWdG zzWdG2 = zzWpN2.zzWRN(zzWzd2);
                    if (zzWdG2.isCritical()) continue;
                    hashSet.add(zzWzd2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        zzWpN zzWpN2;
        if (this.getVersion() == 3 && (zzWpN2 = this.zztE.zzEg().zzXVd()) != null) {
            Enumeration enumeration = zzWpN2.zzZ5S();
            while (enumeration.hasMoreElements()) {
                zzWdG zzWdG2;
                zzWzd zzWzd2 = (zzWzd)enumeration.nextElement();
                if (zzWzd2.zzYFr(zzWdG.zzam) || zzWzd2.zzYFr(zzWdG.zz8m) || zzWzd2.zzYFr(zzWdG.zzbQ) || zzWzd2.zzYFr(zzWdG.zzZxh) || zzWzd2.zzYFr(zzWdG.zzX3G) || zzWzd2.zzYFr(zzWdG.zzXCY) || zzWzd2.zzYFr(zzWdG.zzYec) || zzWzd2.zzYFr(zzWdG.zzZjf) || zzWzd2.zzYFr(zzWdG.zzWeJ) || zzWzd2.zzYFr(zzWdG.zzZOd) || zzWzd2.zzYFr(zzWdG.zzYU5) || !(zzWdG2 = zzWpN2.zzWRN(zzWzd2)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.zzZE4.zzZod(this.zztE.zzZWG());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzWY1.zzWYA();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        if (byArray.length > 20) {
            stringBuffer.append("            Signature: ").append(zzXMJ.zzZmZ(byArray, 0, 20)).append(string);
            for (int i = 20; i < byArray.length; i += 20) {
                if (i < byArray.length - 20) {
                    stringBuffer.append("                       ").append(zzXMJ.zzZmZ(byArray, i, 20)).append(string);
                    continue;
                }
                stringBuffer.append("                       ").append(zzXMJ.zzZmZ(byArray, i, byArray.length - i)).append(string);
            }
        } else {
            stringBuffer.append("            Signature: ").append(zzXMJ.zzYOL(byArray)).append(string);
        }
        zzWpN zzWpN2 = this.zztE.zzEg().zzXVd();
        if (zzWpN2 != null) {
            Enumeration enumeration = zzWpN2.zzZ5S();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                zzWzd zzWzd2 = (zzWzd)enumeration.nextElement();
                zzWdG zzWdG2 = zzWpN2.zzWRN(zzWzd2);
                if (zzWdG2.zzW2I() != null) {
                    byte[] byArray2 = zzWdG2.zzW2I().zzYG2();
                    zz7w zz7w2 = new zz7w(byArray2);
                    stringBuffer.append("                       critical(").append(zzWdG2.isCritical()).append(") ");
                    try {
                        if (zzWzd2.zzYFr(zzWdG.zzWeJ)) {
                            stringBuffer.append(zzW97.zzXv3(zz7w2.zzWPo())).append(string);
                            continue;
                        }
                        if (zzWzd2.zzYFr(zzWdG.zzam)) {
                            stringBuffer.append(zzpf.zzGR(zz7w2.zzWPo())).append(string);
                            continue;
                        }
                        if (zzWzd2.zzYFr(zz47.zzq8)) {
                            stringBuffer.append(new zzYie(zzX6K.zzWi5(zz7w2.zzWPo()))).append(string);
                            continue;
                        }
                        if (zzWzd2.zzYFr(zz47.zzXIu)) {
                            stringBuffer.append(new zzYrr(zzZ4V.zzZVB(zz7w2.zzWPo()))).append(string);
                            continue;
                        }
                        if (zzWzd2.zzYFr(zz47.zzWWb)) {
                            stringBuffer.append(new zzYJ5(zzZ4V.zzZVB(zz7w2.zzWPo()))).append(string);
                            continue;
                        }
                        stringBuffer.append(zzWzd2.getId());
                        stringBuffer.append(" value = ").append(zzEL.zzW6i(zz7w2.zzWPo())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(zzWzd2.getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = zzZEi.zzYYh(this.zztE.zz32());
        try {
            signature = this.zzZE4.zzY1q(string);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.zzYFr(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = zzZEi.zzYYh(this.zztE.zz32());
        Signature signature = sigProvider != null ? Signature.getInstance(string, sigProvider) : Signature.getInstance(string);
        this.zzYFr(key, signature);
    }

    private void zzYFr(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!zzWFZ.zz45(this.zztE.zz32(), this.zztE.zzEg().zzW6J())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        zzY9w zzY9w2 = this.zztE.zz32().zzVTZ();
        zzZEi.zz45(signature, zzY9w2);
        signature.initVerify(publicKey);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zzIY.zz45(signature), 512);
            this.zztE.zzEg().zz45(bufferedOutputStream, "DER");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private static boolean zz45(zzA9 zzA92, zzA9 zzA93) {
        if (!zzA92.zzX7I().zzYFr(zzA93.zzX7I())) {
            return false;
        }
        if (zzX12.zzVVL("org.bouncycastle.x509.allow_absent_equiv_NULL")) {
            if (zzA92.zzVTZ() == null) {
                return zzA93.zzVTZ() == null || zzA93.zzVTZ().equals(zzXS1.zzXfJ);
            }
            if (zzA93.zzVTZ() == null) {
                return zzA92.zzVTZ() == null || zzA92.zzVTZ().equals(zzXS1.zzXfJ);
            }
        }
        if (zzA92.zzVTZ() != null) {
            return zzA92.zzVTZ().equals(zzA93.zzVTZ());
        }
        if (zzA93.zzVTZ() != null) {
            return zzA93.zzVTZ().equals(zzA92.zzVTZ());
        }
        return true;
    }

    private static Collection zz45(zzWjM zzWjM2, String string) throws CertificateParsingException {
        byte[] byArray = zzWFZ.zzYFr(zzWjM2, string);
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = zzX9z.zzVU2(byArray).zzWSE();
            block11: while (enumeration.hasMoreElements()) {
                zzWIX zzWIX2 = zzWIX.zzYgc(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                int n = zzWIX2.zzvq();
                arrayList2.add(n);
                switch (zzWIX2.zzvq()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(zzWIX2.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(zzYP9.zz45(zzZT6.zzZ0y, zzWIX2.zzYDk()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((zzWDb)((Object)zzWIX2.zzYDk())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(zzWzd.zzZbm(zzWIX2.zzYDk()).getId());
                        break;
                    }
                    case 7: {
                        String string2;
                        byte[] byArray2 = zzZLl.zzx3(zzWIX2.zzYDk()).zzYG2();
                        try {
                            string2 = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string2);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + zzWIX2.zzvq());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    protected static byte[] zzYFr(zzWjM zzWjM2, String string) {
        zzXrR zzXrR2 = zzWFZ.zzhG(zzWjM2, string);
        if (zzXrR2 != null) {
            return zzXrR2.zzYG2();
        }
        return null;
    }

    private static zzXrR zzhG(zzWjM zzWjM2, String string) {
        zzWdG zzWdG2;
        zzWpN zzWpN2 = zzWjM2.zzEg().zzXVd();
        if (zzWpN2 != null && (zzWdG2 = zzWpN2.zzWRN(new zzWzd(string))) != null) {
            return zzWdG2.zzW2I();
        }
        return null;
    }
}

