/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzXoW;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzXpD = new ArrayList();
    private final Map<String, DataColumn> zzZJx = new HashMap<String, DataColumn>();
    private DataTable zzZWd;

    DataColumnCollection(DataTable table) {
        this.zzZWd = table;
    }

    public void add(DataColumn column) {
        if (zzXoW.zzYBJ(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzH7(column.getColumnName());
        if (this.zzZJx.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzYFx(this.zzZWd);
        column.setOrdinal(this.zzXpD.size());
        this.zzXpD.add(column);
        this.zzZJx.put(string, column);
        this.zzZWd.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZWd);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzZWd);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzXoW.zzYBJ(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzH7(columnName);
        DataColumn dataColumn = this.zzZJx.get(string);
        if (dataColumn != null) {
            int n = this.zzXpD.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzXpD.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzXpD.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzXpD.remove(n);
            this.zzZJx.remove(DataColumnCollection.zzH7(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzZWd.getRows()) {
                dataRow.remove(n);
            }
            this.zzZWd.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzXpD.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzXpD.iterator();
    }

    public void clear() {
        this.zzZJx.clear();
        this.zzXpD.clear();
    }

    final DataColumn[] zzZ9n() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzXpD);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zz45(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzXpD.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzXpD.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzH7(string);
            String string3 = DataColumnCollection.zzH7(dataColumn.getColumnName());
            this.zzZJx.remove(string3);
            this.zzZJx.put(string2, dataColumn);
            return;
        }
    }

    private static String zzH7(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

