/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzYAp;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzYFr;
import com.aspose.words.net.System.Data.zzYiH;
import com.aspose.words.net.System.Data.zzZod;
import com.aspose.words.net.System.Data.zzhG;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzys;
    private final DataColumnCollection zzWRA;
    private final ConstraintCollection zzZNA;
    private final zzZod zzVRR;
    private ResultSet zzWbZ;
    private String zzWiE;
    private DataSet zzXz6;
    private String zzWc3;
    private UniqueConstraint zzZ51;
    private boolean zzYC7;
    private final List<DataTableEventListener> zzX4H;
    private final Set<DataRow> zzdx;
    private DataRelationCollection zz2G;

    public DataTable() {
        this.zzys = new DataRowCollection(this);
        this.zzWRA = new DataColumnCollection(this);
        this.zzZNA = new ConstraintCollection(this);
        this.zzVRR = new zzZod(this);
        this.zzWc3 = "";
        this.zzYC7 = true;
        this.zzX4H = new ArrayList<DataTableEventListener>();
        this.zzdx = new HashSet<DataRow>();
        this.zz2G = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzys = new DataRowCollection(this);
        this.zzWRA = new DataColumnCollection(this);
        this.zzZNA = new ConstraintCollection(this);
        this.zzVRR = new zzZod(this);
        this.zzWc3 = "";
        this.zzYC7 = true;
        this.zzX4H = new ArrayList<DataTableEventListener>();
        this.zzdx = new HashSet<DataRow>();
        this.zz2G = new DataRelationCollection();
        this.zzWiE = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYFr.zz45(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzys = new DataRowCollection(this);
        this.zzWRA = new DataColumnCollection(this);
        this.zzZNA = new ConstraintCollection(this);
        this.zzVRR = new zzZod(this);
        this.zzWc3 = "";
        this.zzYC7 = true;
        this.zzX4H = new ArrayList<DataTableEventListener>();
        this.zzdx = new HashSet<DataRow>();
        this.zz2G = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWbZ = resultSet;
        this.zzWiE = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWbZ != null) {
            if (this.zzWbZ.getStatement() != null) {
                this.zzWbZ.getStatement().getConnection().close();
            }
            this.zzWbZ = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzWiE;
    }

    public void setTableName(String tableName) {
        this.zzWiE = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzWRA.getCount();
    }

    public String getColumnName(int index) {
        return this.zzWRA.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWbZ;
    }

    public DataSet getDataSet() {
        return this.zzXz6;
    }

    final void zzYFx(DataSet dataSet) {
        this.zzXz6 = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzXz6.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zz2G.add(dataRelation);
        }
        return this.zz2G;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzXz6.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzys;
    }

    public DataColumnCollection getColumns() {
        return this.zzWRA;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZNA;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzZ51 == null) {
            return new DataColumn[0];
        }
        return this.zzZ51.getColumns();
    }

    final void zzZod(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzZ51 != null) {
                this.zzZ51.zzWiy(false);
                this.getConstraints().remove(this.zzZ51);
                this.zzZ51 = null;
            }
            return;
        }
        if (this.zzZ51 != null && DataColumn.areColumnSetsTheSame(value, this.zzZ51.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zz45(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzZ51 != null) {
            this.zzZ51.zzWiy(false);
            this.getConstraints().remove(this.zzZ51);
            this.zzZ51 = null;
        }
        UniqueConstraint.zz45(this.getConstraints(), uniqueConstraint);
        this.zzZ51 = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzWc3;
    }

    public void setNamespace(String namespace) {
        this.zzWc3 = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzYC7;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzYC7 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzdx.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYFr.zz45(this.getResultSet(), this);
            zzYFr.zzYFr(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzYAp.zzYFx(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYFr.zzYKD(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzX4H.contains(listener)) {
            this.zzX4H.add(listener);
        }
    }

    public void removeEventListener(zzhG listener) {
        if (this.zzX4H.contains(listener)) {
            this.zzX4H.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzX4H.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzdx.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzX4H) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzdx.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzX4H) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzdx.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzX4H) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzX4H) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzX4H) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzYiH zz45(zzYFr[] zzYFrArray) {
        DataColumn[] dataColumnArray = new DataColumn[zzYFrArray.length];
        for (int i = 0; i < zzYFrArray.length; ++i) {
            dataColumnArray[i] = zzYFrArray[i].zzD();
        }
        DataTable dataTable = this;
        zzYiH zzYiH2 = dataTable.zzVRR.zzYFx(dataColumnArray);
        if (zzYiH2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzYiH2;
    }

    final zzZod zzY9m() {
        return this.zzVRR;
    }

    final Set<DataRow> zzXBO() {
        return this.zzdx;
    }
}

