/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CheckGrammarOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Run;
import com.aspose.words.SummarizeOptions;
import com.aspose.words.internal.zzWla;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzXRQ;
import com.aspose.words.internal.zzXoW;
import com.aspose.words.internal.zzZa4;
import com.aspose.words.internal.zzZdX;
import com.aspose.words.internal.zzZov;
import com.aspose.words.zzSD;
import com.aspose.words.zzVQQ;
import com.aspose.words.zzWYs;
import com.aspose.words.zzWdQ;
import com.aspose.words.zzWwl;
import com.aspose.words.zzX1B;
import com.aspose.words.zzXA0;
import com.aspose.words.zzXBH;
import com.aspose.words.zzY7I;
import com.aspose.words.zzYYh;
import com.aspose.words.zzYuR;
import com.aspose.words.zzZLC;
import com.aspose.words.zzZuI;
import com.aspose.words.zzaX;
import com.aspose.words.zzmR;
import com.aspose.words.zzzz;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public abstract class AiModel {
    private String zzmq;

    public abstract Document summarize(Document var1, SummarizeOptions var2) throws Exception;

    public abstract Document summarize(Document[] var1, SummarizeOptions var2) throws Exception;

    public Document checkGrammar(Document sourceDocument, CheckGrammarOptions options) throws Exception {
        Document document = options == null || options.getPreserveFormatting() ? this.zzYFr(sourceDocument, options) : this.zz45(sourceDocument, options);
        document.zzWo().add(32);
        if (options != null && options.getMakeRevisions()) {
            Document document2 = sourceDocument.deepClone();
            document2.zz45(document, "AI", zzWla.zzYpB());
            return document2;
        }
        return document;
    }

    public abstract Document translate(Document var1, int var2) throws Exception;

    public AiModel withApiKey(String apiKey) {
        String string = apiKey;
        AiModel aiModel = this;
        this.zzmq = string;
        return this;
    }

    public static AiModel create(int modelType) {
        switch (modelType) {
            case 0: {
                return new zzWYs();
            }
            case 1: {
                return new zzWdQ();
            }
            case 2: {
                return new zzZuI();
            }
            case 3: {
                return new zzX1B();
            }
            case 4: {
                return new zzYuR();
            }
            case 5: {
                return new zzZLC();
            }
            case 6: {
                return new zzXBH();
            }
            case 7: {
                return new zzzz();
            }
            case 8: {
                return new zzVQQ();
            }
            case 10: {
                return new zzSD();
            }
            case 9: {
                return new zzY7I();
            }
            case 11: {
                return new zzaX();
            }
        }
        throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: modelType" + modelType);
    }

    AiModel() {
    }

    private static String zzYKD(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        while (-1 != (n = bufferedReader.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    final String zzZpR(ArrayList<zzmR> arrayList, int n) throws Exception {
        String string = this.zzXV5(arrayList, n);
        zzZdX zzZdX2 = new zzZdX();
        byte[] byArray = zzZdX2.zzWlL(string);
        HttpURLConnection httpURLConnection = this.zzWyv(n);
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        AiModel.zz45(string, httpURLConnection);
        return AiModel.zzhG(httpURLConnection);
    }

    private HttpURLConnection zzWyv(int n) throws Exception {
        String string = zzXoW.zzYFr("{0}{1}{2}", new Object[]{this.getUrl(), zzXoW.zzYFr(this.getUrl(), "/", zzXRQ.INVARIANT_CULTURE_IGNORE_CASE) ? "" : "/", this.toString(n)});
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestMethod("POST");
        if (this.zzWP9() != null) {
            zzZa4.zz45 zz452 = this.zzWP9().zzWr0();
            while (zz452.moveNext()) {
                httpURLConnection.setRequestProperty(zz452.zzWLd(), zz452.zzWio());
            }
        }
        return httpURLConnection;
    }

    private static void zz45(String string, HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.setDoOutput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        bufferedWriter.write(string);
        bufferedWriter.flush();
        bufferedWriter.close();
        outputStream.close();
    }

    private static String zzhG(HttpURLConnection httpURLConnection) throws IOException {
        try {
            String string = AiModel.zzYKD(httpURLConnection.getInputStream());
            int n = httpURLConnection.getResponseCode();
            if (n == 200 || n == 202 || n == 201) {
                return string;
            }
        }
        catch (Exception exception) {
            String string = AiModel.zzYKD(httpURLConnection.getErrorStream());
            if (string.isEmpty()) {
                throw new IllegalStateException("Request error with Error message: " + exception.getMessage());
            }
            return string;
        }
        return "";
    }

    private String toString(int requestMethod) {
        switch (requestMethod) {
            case 0: {
                return this.zzWDG();
            }
            case 1: {
                return this.zzVZV();
            }
        }
        throw new IllegalArgumentException(null + "\r\nParameter name: " + zzXA0.toString(requestMethod) + "\r\nParameter value: " + requestMethod);
    }

    private Document zz45(Document document, CheckGrammarOptions checkGrammarOptions) throws Exception {
        Object object2;
        NodeCollection nodeCollection;
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document, new zzYYh(), true);
        ArrayList arrayList = nodeCollection.zzZEC();
        if (arrayList.size() == 0) {
            return document.deepClone();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : arrayList) {
            zzXCa.zzYFr(stringBuilder, ((Run)object2).getText());
        }
        String string = zzXoW.zzYFx(this.zz45(stringBuilder.toString(), checkGrammarOptions), "\r\n".toCharArray());
        object2 = new DocumentBuilder();
        ((DocumentBuilder)object2).write(string);
        return ((DocumentBuilder)object2).getDocument();
    }

    private Document zzYFr(Document document, CheckGrammarOptions checkGrammarOptions) throws Exception {
        String string;
        NodeCollection nodeCollection;
        Document document2 = document.deepClone();
        document2.joinRunsWithSameFormatting();
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document2, new zzYYh(), true);
        ArrayList<Node> arrayList = nodeCollection.zzZEC();
        if (arrayList.size() == 0) {
            return document2;
        }
        zzWwl.zzZWj(arrayList);
        String string2 = zzWwl.zzW8T(arrayList);
        zzZov zzZov2 = null;
        for (int i = 0; i <= 3 && (zzZov2 = zzWwl.zzhG(string = zzXoW.zzYFx(this.zz45(string2, checkGrammarOptions), "\r\n".toCharArray()), arrayList)).getCount() <= 0; ++i) {
        }
        if (zzZov2.getCount() > 0) {
            zzZov zzZov3 = zzWwl.zzYFr(zzZov2, arrayList.size() - 1);
            for (int i = 0; i < zzZov3.getCount(); ++i) {
                int n = zzZov3.get(i);
                arrayList.get(n).remove();
            }
        }
        return document2;
    }

    protected abstract String getName();

    protected abstract String getUrl();

    final String zzUX() {
        return this.zzmq;
    }

    abstract String zz45(String var1, CheckGrammarOptions var2) throws Exception;

    abstract String zzXV5(ArrayList<zzmR> var1, int var2);

    abstract String zzVZV();

    abstract String zzWDG();

    abstract zzZa4 zzWP9();
}

