/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.zzLB;
import com.aspose.words.zzVWe;
import com.aspose.words.zzVX0;
import com.aspose.words.zzW26;
import com.aspose.words.zzXOq;
import com.aspose.words.zzYDW;
import com.aspose.words.zzYUw;
import com.aspose.words.zzvt;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzYUw,
Iterable<V> {
    private Node zzY49;
    private Node zzW3S;
    private Node zzXXt;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzVWe zzVWe2 = new zzVWe(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzYFx(this, true);
            return;
        }
        finally {
            zzVWe2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zzX12() {
        return this.zzWnZ() != null;
    }

    final boolean zzZn6() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzZ0W() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzXOq) {
                return true;
            }
            CompositeNode compositeNode = zzXCa.zz45((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzZ0W()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzY49;
    }

    public Node getLastChild() {
        return this.zzW3S;
    }

    final Node zzWnZ() {
        return zzLB.zzW36(this.getFirstChild(), false);
    }

    final Node zzWWe() {
        return zzLB.zzZ5g(this.getLastChild(), false);
    }

    final CompositeNode zzkm() {
        return (CompositeNode)zzLB.zzW36(this.getFirstChild(), true);
    }

    final CompositeNode zzWtO() {
        return (CompositeNode)zzLB.zzZ5g(this.getLastChild(), true);
    }

    final Node zzed() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzLB.zzYIH((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zz41() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzLB.zzYIH((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zz45(boolean bl, zzYDW zzYDW2) {
        CompositeNode compositeNode = (CompositeNode)super.zz45(bl, zzYDW2);
        ((CompositeNode)super.zz45(bl, zzYDW2)).zzW3S = null;
        compositeNode.zzY49 = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzXbn(node.zz45(true, zzYDW2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzXHX(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzXHX(StringBuilder stringBuilder) {
        this.zzWDc(stringBuilder);
        zzXCa.zzYFr(stringBuilder, this.zzXIr());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYFr(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzLB.zzZa4(nodeType);
            Node node2 = node = bl ? this.zzWnZ() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zz6A() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzLB.zzhG((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzLB.zzYFx((Node)this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzW26(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zz45(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zz45(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzYFx(oldChild, false);
    }

    private <T extends Node> T zzYFx(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzLB.zz45(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzZ2t() && zzLB.zzXYx(t)) {
            return t;
        }
        zzLB.zz45(documentBase, nodeChangingArgs);
        if (!bl && zzLB.zzYx4(t)) {
            zzLB.zzZpR(t, false);
        }
        T t2 = this.zzW8T(t);
        zzLB.zzYFr(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzvt.zzYdS(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzXbn(Node node) {
        node.getParentNode();
        if (this.zzW3S == null) {
            node.zzZCB(null);
            node.zzuY(null);
            this.zzY49 = node;
        } else {
            node.zzZCB(this.zzW3S);
            node.zzuY(null);
            this.zzW3S.zzuY(node);
        }
        this.zzW3S = node;
        node.zzR4(this);
        return node;
    }

    final void zz45(Node node, Node node2, Node node3) {
        this.zz45(node, node2, node3, false);
    }

    final void zz45(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzWHP(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYFr(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzYKD(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzLB.zzYIH(node3.getNodeType())) continue;
            if (zzLB.zzYKD(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzXIr().length();
    }

    String zzXIr() {
        return "";
    }

    final String zzWY1() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWDc(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzWDc(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzXHX(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzWHP(Node node) {
        return true;
    }

    final <T extends Node> T zz45(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzZq7(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzLB.zz45(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzWHP(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzVX0(documentBase);
            try {
                compositeNode.zzYFx(t, true);
            }
            finally {
                ((zzVX0)object).dispose();
            }
        }
        object = zzLB.zz45(documentBase, t, null, (Node)this, 0);
        zzLB.zz45(documentBase, (NodeChangingArgs)object);
        if (this.zzW3S == null) {
            t.zzZCB(null);
            t.zzuY(null);
            this.zzY49 = t;
            this.zzW3S = t;
        } else if (bl) {
            if (node != null) {
                this.zzYFr(t, node);
            } else {
                this.zzhG(t, this.zzY49);
            }
        } else if (node != null) {
            this.zzhG(t, node);
        } else {
            this.zzYFr(t, this.zzW3S);
        }
        t.zzR4(this);
        zzLB.zzYFr(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzZ2t()) {
            zzLB.zz45(t, compositeNode, node2);
        }
        return t;
    }

    private void zzYFr(Node node, Node node2) {
        Node node3 = node2.zzZGT();
        node.zzZCB(node2);
        node.zzuY(node3);
        node2.zzuY(node);
        if (node3 == null) {
            this.zzW3S = node;
            return;
        }
        node3.zzZCB(node);
    }

    private void zzhG(Node node, Node node2) {
        Node node3 = node2.zzYiB();
        node.zzZCB(node3);
        node.zzuY(node2);
        node2.zzZCB(node);
        if (node3 == null) {
            this.zzY49 = node;
            return;
        }
        node3.zzuY(node);
    }

    private <T extends Node> T zzW8T(T t) {
        if (t == this.zzY49) {
            if (this.zzY49 == this.zzW3S) {
                this.zzY49 = null;
                this.zzW3S = null;
            } else {
                this.zzY49 = t.zzZGT();
                this.zzY49.zzZCB(null);
            }
        } else {
            Node node = t.zzYiB();
            Node node2 = t.zzZGT();
            node.zzuY(node2);
            if (node2 == null) {
                this.zzW3S = node;
            } else {
                node2.zzZCB(node);
            }
        }
        t.zzuY(null);
        t.zzZCB(null);
        t.zzR4(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzXXt = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzXXt;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

