/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.ConverterContext;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.PageSet;
import com.aspose.words.Processor;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWPP;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzWjz;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzY5Z;
import com.aspose.words.internal.zzYe6;
import com.aspose.words.internal.zzZco;
import com.aspose.words.internal.zzZds;
import com.aspose.words.internal.zzZpT;
import com.aspose.words.zzLB;
import com.aspose.words.zzWn5;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;

public class Converter
extends Processor {
    private static final String zzYgr = zzWjz.zzZtf().zzWyU(new byte[]{110, 65, 105, 32, 118, 110, 108, 97, 100, 105, 83, 32, 118, 97, 70, 101, 114, 111, 97, 109, 32, 116, 97, 119, 32, 115, 104, 99, 115, 111, 110, 101, 32, 46, 110, 79, 121, 108, 69, 32, 102, 109, 32, 44, 101, 87, 80, 98, 32, 44, 105, 84, 102, 102, 32, 44, 110, 80, 44, 103, 66, 32, 112, 109, 32, 44, 112, 74, 103, 101, 32, 44, 118, 83, 44, 103, 71, 32, 102, 105, 97, 32, 100, 110, 69, 32, 115, 112, 105, 32, 97, 109, 101, 103, 115, 32, 118, 97, 32, 101, 111, 102, 109, 114, 116, 97, 32, 115, 114, 97, 32, 101, 108, 97, 111, 108, 101, 119, 100});

    private Converter(ConverterContext context) {
        super(context);
    }

    public static Converter create() {
        return Converter.create(new ConverterContext());
    }

    public static Converter create(ConverterContext context) {
        return new Converter(context);
    }

    @Override
    protected void executeCore() throws Exception {
        zzZds<zzWn5> zzZds2;
        if (this.mResultDocument == null && ((zzZds2 = this.zzWKe()).size() > 0 || (zzZds2 = this.zzXnb()).size() > 0)) {
            this.mResultDocument = this.zzVPV().zzSw();
        }
        super.executeCore();
    }

    public static void convert(String inputFile, String outputFile) throws Exception {
        String string = outputFile;
        Converter.convert(inputFile, string, FileFormatUtil.extensionToSaveFormat(zzZco.zzcq(string)));
    }

    public static void convert(String inputFile, String outputFile, int saveFormat) throws Exception {
        Converter.convert(inputFile, outputFile, zzLB.zzXky(saveFormat, outputFile));
    }

    public static void convert(String inputFile, String outputFile, SaveOptions saveOptions) throws Exception {
        Converter.convert(inputFile, null, outputFile, saveOptions);
    }

    public static void convert(String inputFile, LoadOptions loadOptions, String outputFile, SaveOptions saveOptions) throws Exception {
        Converter.create().from(inputFile, loadOptions).to(outputFile, saveOptions).execute();
    }

    private static void zz45(zzWf9 zzWf92, zzWf9 zzWf93, int n) throws Exception {
        SaveOptions saveOptions = zzLB.zzXky(n, null);
        zzWf9 zzWf94 = zzWf93;
        zzWf9 zzWf95 = zzWf92;
        Converter.zz45(zzWf95, null, zzWf94, saveOptions);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, int saveFormat) throws Exception {
        Converter.zz45(zzWf9.zzYFr(inputStream), zzWf9.zzhG(outputStream), saveFormat);
    }

    public static void convert(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        SaveOptions saveOptions2 = saveOptions;
        zzYe6 zzYe62 = zzWf9.zzhG(outputStream);
        zzWf9 zzWf92 = zzWf9.zzYFr(inputStream);
        Converter.zz45(zzWf92, null, zzYe62, saveOptions2);
    }

    private static void zz45(zzWf9 zzWf92, LoadOptions loadOptions, zzWf9 zzWf93, SaveOptions saveOptions) throws Exception {
        Converter.create().zzhG(zzWf92, loadOptions).zzYFr(zzWf93, saveOptions).execute();
    }

    public static void convert(InputStream inputStream, LoadOptions loadOptions, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        Converter.zz45(zzWf9.zzYFr(inputStream), loadOptions, zzWf9.zzhG(outputStream), saveOptions);
    }

    @Deprecated
    public static void convertToImages(String inputFile, String outputFile) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZco.zzcq(outputFile));
        Converter.convertToImages(inputFile, outputFile, n);
    }

    @Deprecated
    public static void convertToImages(String inputFile, String outputFile, int saveFormat) throws Exception {
        if (!FileFormatUtil.zzW87(saveFormat)) {
            throw new IllegalArgumentException(zzYgr);
        }
        Converter.convertToImages(inputFile, outputFile, new ImageSaveOptions(saveFormat));
    }

    @Deprecated
    public static void convertToImages(String inputFile, String outputFile, ImageSaveOptions saveOptions) throws Exception {
        Converter.convertToImages(inputFile, null, outputFile, saveOptions);
    }

    @Deprecated
    public static void convertToImages(String inputFile, LoadOptions loadOptions, String outputFile, ImageSaveOptions saveOptions) throws Exception {
        Converter.create().from(inputFile, loadOptions).to(outputFile, (SaveOptions)saveOptions).execute();
    }

    private static zzWf9[] zzXXe(String string, int n) throws Exception {
        if (!FileFormatUtil.zzW87(n)) {
            throw new IllegalArgumentException(zzYgr);
        }
        return Converter.zz45(string, new ImageSaveOptions(n));
    }

    public static OutputStream[] convertToImages(String inputFile, int saveFormat) throws Exception {
        return zzWf9.zzYFr(Converter.zzXXe(inputFile, saveFormat));
    }

    private static zzWf9[] zz45(String string, ImageSaveOptions imageSaveOptions) throws Exception {
        try (zzZpT zzZpT2 = zzXCa.zzjd(string);){
            ImageSaveOptions imageSaveOptions2 = imageSaveOptions;
            zzZpT zzZpT3 = zzZpT2;
            zzWf9[] zzWf9Array = Converter.zz45((zzWf9)zzZpT3, null, imageSaveOptions2);
            return zzWf9Array;
        }
    }

    public static OutputStream[] convertToImages(String inputFile, ImageSaveOptions saveOptions) throws Exception {
        return zzWf9.zzYFr(Converter.zz45(inputFile, saveOptions));
    }

    private static zzWf9[] zzWwl(zzWf9 zzWf92, int n) throws Exception {
        if (!FileFormatUtil.zzW87(n)) {
            throw new IllegalArgumentException(zzYgr);
        }
        ImageSaveOptions imageSaveOptions = new ImageSaveOptions(n);
        zzWf9 zzWf93 = zzWf92;
        return Converter.zz45(zzWf93, null, imageSaveOptions);
    }

    public static OutputStream[] convertToImages(InputStream inputStream, int saveFormat) throws Exception {
        return zzWf9.zzYFr(Converter.zzWwl(zzWf9.zzYFr(inputStream), saveFormat));
    }

    public static OutputStream[] convertToImages(InputStream inputStream, ImageSaveOptions saveOptions) throws Exception {
        ImageSaveOptions imageSaveOptions = saveOptions;
        zzWf9 zzWf92 = zzWf9.zzYFr(inputStream);
        return zzWf9.zzYFr(Converter.zz45(zzWf92, null, imageSaveOptions));
    }

    private static zzWf9[] zz45(zzWf9 zzWf92, LoadOptions loadOptions, ImageSaveOptions imageSaveOptions) throws Exception {
        ArrayList<zzWf9> arrayList = new ArrayList<zzWf9>();
        Converter.create().zzhG(zzWf92, loadOptions).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzWf9[] zzWf9Array = new zzWf9[]{};
        ArrayList<zzWf9> arrayList2 = arrayList;
        return arrayList2.toArray(zzWf9Array);
    }

    public static OutputStream[] convertToImages(InputStream inputStream, LoadOptions loadOptions, ImageSaveOptions saveOptions) throws Exception {
        return zzWf9.zzYFr(Converter.zz45(zzWf9.zzYFr(inputStream), loadOptions, saveOptions));
    }

    private static zzWf9[] zzYFr(Document document, int n) throws Exception {
        if (!FileFormatUtil.zzW87(n)) {
            throw new IllegalArgumentException(zzYgr);
        }
        return Converter.zz45(document, new ImageSaveOptions(n));
    }

    public static OutputStream[] convertToImages(Document doc, int saveFormat) throws Exception {
        return zzWf9.zzYFr(Converter.zzYFr(doc, saveFormat));
    }

    private static zzWf9[] zz45(Document document, ImageSaveOptions imageSaveOptions) throws Exception {
        int n;
        ArrayList arrayList = new ArrayList();
        Iterator<Integer> iterator = imageSaveOptions.getPageSet().iterator();
        while (iterator.hasNext() && (n = iterator.next().intValue()) < document.getPageCount()) {
            ImageSaveOptions imageSaveOptions2 = imageSaveOptions.deepClone();
            imageSaveOptions2.setPageSet(new PageSet(n));
            zzWPP zzWPP2 = new zzWPP();
            document.zz45((zzWf9)zzWPP2, imageSaveOptions2);
            zzWPP2.zzW8T(0L);
            zzY5Z.zz45(arrayList, zzWPP2);
        }
        zzWf9[] zzWf9Array = new zzWf9[]{};
        ArrayList arrayList2 = arrayList;
        return arrayList2.toArray(zzWf9Array);
    }

    public static OutputStream[] convertToImages(Document doc, ImageSaveOptions saveOptions) throws Exception {
        return zzWf9.zzYFr(Converter.zz45(doc, saveOptions));
    }
}

