/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzWc2;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.internal.zzY5Z;
import com.aspose.words.internal.zzY8J;
import com.aspose.words.internal.zzZpT;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXI4;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzmw = new HashMap();
    private static HashMap<Integer, Integer> zzX6y = new HashMap();
    private static HashMap<Integer, Integer> zzVQx = new HashMap();
    private static HashMap<Integer, Integer> zzWMl = new HashMap();
    private static HashMap<Integer, Integer> zzZqD = new HashMap();
    private static HashMap<Integer, Integer> zzYwv = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzXCa.zzYiH(fileName, "fileName");
        try (zzZpT zzZpT2 = zzXCa.zzjd(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzYJU(zzZpT2);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzYJU(zzY5Z.zz45(stream));
    }

    static FileFormatInfo zzYJU(zzWf9 zzWf92) throws Exception {
        if (zzWf92 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzXI4 zzXI42 = new zzXI4();
            zzWf9 zzWf93 = zzWf92;
            zzXI4 zzXI43 = zzXI42;
            return zzXI42.zzYFr(zzWf93, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzhG(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzYgb(zzWc2.zzYU9(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzVSL(zzWc2.zzYU9(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzY8J.zzXvF(string = zzWc2.zzZOG(FileFormatUtil.zz18(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzYgb(FileFormatUtil.zzWiV(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzVSL(FileFormatUtil.zz18(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzWc2.zzZOG(FileFormatUtil.zzWiV(saveFormat));
        if (zzY8J.zzXvF(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzVSL(zzWc2.zzWP0(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzWc2.zzZOG(FileFormatUtil.zzXJI(imageType));
    }

    static Exception zzhG(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static boolean zzYLQ(int n) {
        return n == 50;
    }

    static String zzZ9Z(int n) {
        return zzWc2.toString(FileFormatUtil.zzWiV(n));
    }

    static int zzVSL(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXCa.zz45(zzZqD, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzW4n(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzXCa.zz45(zzYwv, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzVTX(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    static boolean zzfO(int n) {
        return n == 40 || n == 107 || n == 103 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106 || n == 41 || n == 48 || n == 46 || n == 45;
    }

    static boolean zzW87(int n) {
        return n == 103 || n == 107 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106;
    }

    static int zz18(int n) {
        return zzXCa.zz45(zzmw, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzWiV(int n) {
        return zzXCa.zz45(zzX6y, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXJI(int n) {
        return zzXCa.zz45(zzVQx, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzYgb(int n) {
        return zzXCa.zz45(zzWMl, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzZpl(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzXCa.zzYFr(zzZqD, Integer.valueOf(n), Integer.valueOf(n2));
            zzXCa.zzYFr(zzX6y, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzWMl.containsKey(n)) {
                zzXCa.zzYFr(zzWMl, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzXCa.zzYFr(zzmw, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzXCa.zzYFr(zzYwv, Integer.valueOf(n), Integer.valueOf(n4));
            zzXCa.zzYFr(zzVQx, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzZpl(13, 10, 10, 1);
        FileFormatUtil.zzZpl(13, 0, 0, 1);
        FileFormatUtil.zzZpl(14, 11, 11, 1);
        FileFormatUtil.zzZpl(15, 20, 20, 1);
        FileFormatUtil.zzZpl(15, 0, 254, 1);
        FileFormatUtil.zzZpl(16, 21, 21, 1);
        FileFormatUtil.zzZpl(17, 22, 22, 1);
        FileFormatUtil.zzZpl(18, 23, 23, 1);
        FileFormatUtil.zzZpl(20, 24, 24, 1);
        FileFormatUtil.zzZpl(21, 25, 25, 1);
        FileFormatUtil.zzZpl(22, 26, 26, 1);
        FileFormatUtil.zzZpl(23, 27, 27, 1);
        FileFormatUtil.zzZpl(26, 30, 30, 1);
        FileFormatUtil.zzZpl(19, 31, 31, 1);
        FileFormatUtil.zzZpl(27, 50, 50, 1);
        FileFormatUtil.zzZpl(28, 45, 255, 1);
        FileFormatUtil.zzZpl(29, 51, 51, 1);
        FileFormatUtil.zzZpl(30, 54, 52, 1);
        FileFormatUtil.zzZpl(31, 0, 53, 1);
        FileFormatUtil.zzZpl(33, 53, 54, 1);
        FileFormatUtil.zzZpl(24, 60, 60, 1);
        FileFormatUtil.zzZpl(25, 61, 61, 1);
        FileFormatUtil.zzZpl(36, 40, 64, 1);
        FileFormatUtil.zzZpl(43, 47, 255, 1);
        FileFormatUtil.zzZpl(44, 48, 255, 1);
        FileFormatUtil.zzZpl(37, 41, 255, 1);
        FileFormatUtil.zzZpl(38, 46, 255, 1);
        FileFormatUtil.zzZpl(40, 42, 255, 1);
        FileFormatUtil.zzZpl(39, 44, 255, 1);
        FileFormatUtil.zzZpl(32, 52, 55, 1);
        FileFormatUtil.zzZpl(34, 70, 62, 1);
        FileFormatUtil.zzZpl(35, 73, 63, 1);
        FileFormatUtil.zzZpl(41, 71, 255, 1);
        FileFormatUtil.zzZpl(8, 100, 255, 1);
        FileFormatUtil.zzZpl(9, 105, 255, 10);
        FileFormatUtil.zzZpl(6, 101, 255, 6);
        FileFormatUtil.zzZpl(7, 102, 255, 7);
        FileFormatUtil.zzZpl(5, 104, 255, 5);
        FileFormatUtil.zzZpl(4, 0, 255, 4);
        FileFormatUtil.zzZpl(3, 0, 255, 3);
        FileFormatUtil.zzZpl(42, 72, 255, 1);
        FileFormatUtil.zzZpl(2, 103, 255, 2);
        FileFormatUtil.zzZpl(10, 106, 255, 8);
        FileFormatUtil.zzZpl(48, 80, 255, 1);
        FileFormatUtil.zzZpl(11, 107, 255, 9);
        FileFormatUtil.zzZpl(49, 0, 8, 1);
    }
}

