/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.MergerContext;
import com.aspose.words.Processor;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzZco;
import com.aspose.words.zzLB;
import com.aspose.words.zzZ18;
import com.aspose.words.zzZdj;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Merger
extends Processor {
    private MergerContext zzY8B;

    private Merger(MergerContext context) {
        super(context);
        this.zzY8B = context;
    }

    public static Merger create() {
        return Merger.create(new MergerContext());
    }

    public static Merger create(MergerContext context) {
        return new Merger(context);
    }

    @Override
    protected void executeCore() throws Exception {
        Document[] documentArray = new Document[this.zzY4r().size()];
        for (int i = 0; i < this.zzY4r().size(); ++i) {
            documentArray[i] = this.zzY4r().get(i).zzSw();
        }
        this.mResultDocument = Merger.zz45(documentArray, this.zzY8B.getMergeFormatMode());
        super.executeCore();
    }

    public static void merge(String outputFile, String[] inputFiles) throws Exception {
        Merger.merge(outputFile, inputFiles, FileFormatUtil.extensionToSaveFormat(zzZco.zzcq(outputFile)), 1);
    }

    public static void merge(String outputFile, String[] inputFiles, int saveFormat, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, zzLB.zzXky(saveFormat, outputFile), mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, null, saveOptions, mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, LoadOptions[] loadOptions, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        if (loadOptions != null && inputFiles.length != loadOptions.length) {
            throw new IllegalArgumentException("Arrays of input files and load options must be of the same dimension.");
        }
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(mergeFormatMode);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < inputFiles.length; ++i) {
            merger.from(inputFiles[i], loadOptions != null ? loadOptions[i] : null);
        }
        merger.to(outputFile, saveOptions).execute();
    }

    public static Document merge(String[] inputFiles, int mergeFormatMode) throws Exception {
        return Merger.merge(inputFiles, null, mergeFormatMode);
    }

    public static Document merge(String[] inputFiles, LoadOptions[] loadOptions, int mergeFormatMode) throws Exception {
        if (loadOptions != null && inputFiles.length != loadOptions.length) {
            throw new IllegalArgumentException("Arrays of input files and load options must be of the same dimension.");
        }
        Document[] documentArray = new Document[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            documentArray[i] = new Document(inputFiles[i], loadOptions != null ? loadOptions[i] : null);
        }
        return Merger.zz45(documentArray, mergeFormatMode);
    }

    public static Document merge(Document[] inputDocuments, int mergeFormatMode) throws Exception {
        return Merger.zz45(inputDocuments, mergeFormatMode);
    }

    private static void zz45(zzWf9 zzWf92, zzWf9[] zzWf9Array, int n) throws Exception {
        Merger.zz45(zzWf92, zzWf9Array, zzLB.zzXky(n, null), 1);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, int saveFormat) throws Exception {
        Merger.zz45(zzWf9.zzhG(outputStream), zzWf9.zz45(inputStreams), saveFormat);
    }

    private static void zz45(zzWf9 zzWf92, zzWf9[] zzWf9Array, SaveOptions saveOptions, int n) throws Exception {
        Merger.zz45(zzWf92, zzWf9Array, null, saveOptions, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.zz45(zzWf9.zzhG(outputStream), zzWf9.zz45(inputStreams), saveOptions, mergeFormatMode);
    }

    private static void zz45(zzWf9 zzWf92, zzWf9[] zzWf9Array, LoadOptions[] loadOptionsArray, SaveOptions saveOptions, int n) throws Exception {
        Merger.zzYFr(zzWf92, zzWf9Array, loadOptionsArray, saveOptions, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, LoadOptions[] loadOptions, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.zz45(zzWf9.zzhG(outputStream), zzWf9.zz45(inputStreams), loadOptions, saveOptions, mergeFormatMode);
    }

    private static Document zz45(zzWf9[] zzWf9Array, int n) throws Exception {
        int n2 = n;
        LoadOptions[] loadOptionsArray = null;
        zzWf9[] zzWf9Array2 = zzWf9Array;
        return Merger.zz45(zzWf9Array, loadOptionsArray, n2);
    }

    public static Document merge(InputStream[] inputStreams, int mergeFormatMode) throws Exception {
        return Merger.zz45(zzWf9.zz45(inputStreams), mergeFormatMode);
    }

    public static Document merge(InputStream[] inputStreams, LoadOptions[] loadOptions, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        LoadOptions[] loadOptionsArray = loadOptions;
        zzWf9[] zzWf9Array = zzWf9.zz45(inputStreams);
        return Merger.zz45(zzWf9Array, loadOptionsArray, n);
    }

    private static zzWf9[] zz45(String[] stringArray, ImageSaveOptions imageSaveOptions, int n) throws Exception {
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < stringArray.length; ++i) {
            merger.from(stringArray[i]);
        }
        ArrayList<zzWf9> arrayList = new ArrayList<zzWf9>();
        merger.to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzWf9[] zzWf9Array = new zzWf9[]{};
        ArrayList<zzWf9> arrayList2 = arrayList;
        return arrayList2.toArray(zzWf9Array);
    }

    public static InputStream[] mergeToImages(String[] inputFiles, ImageSaveOptions saveOptions, int mergeFormatMode) throws Exception {
        return zzWf9.zz45(Merger.zz45(inputFiles, saveOptions, mergeFormatMode));
    }

    private static zzWf9[] zz45(zzWf9[] zzWf9Array, ImageSaveOptions imageSaveOptions, int n) throws Exception {
        Object object;
        zzWf9[] zzWf9Array2;
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < zzWf9Array.length; ++i) {
            zzWf9Array2 = zzWf9Array[i];
            object = merger;
            ((Processor)object).zzhG((zzWf9)zzWf9Array2, null);
        }
        ArrayList<zzWf9> arrayList = new ArrayList<zzWf9>();
        merger.to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzWf9Array2 = new zzWf9[]{};
        object = arrayList;
        return ((ArrayList)object).toArray(zzWf9Array2);
    }

    public static InputStream[] mergeToImages(InputStream[] inputStreams, ImageSaveOptions saveOptions, int mergeFormatMode) throws Exception {
        return zzWf9.zz45(Merger.zz45(zzWf9.zz45(inputStreams), saveOptions, mergeFormatMode));
    }

    private static Document zz45(Document[] documentArray, int n) throws Exception {
        if (documentArray == null || documentArray.length == 0) {
            return null;
        }
        Document document = documentArray[0].deepClone();
        for (int i = 1; i < documentArray.length; ++i) {
            if (n == 2) {
                Document[] documentArray2 = new Document[]{documentArray[i]};
                Document document2 = document;
                zzZ18.zz45(document2, documentArray2);
                continue;
            }
            document.appendDocument(documentArray[i], Merger.zzXjw(n));
        }
        return document;
    }

    private static void zzYFr(zzWf9 zzWf92, zzWf9[] zzWf9Array, LoadOptions[] loadOptionsArray, SaveOptions saveOptions, int n) throws Exception {
        if (loadOptionsArray != null && zzWf9Array.length != loadOptionsArray.length) {
            throw new IllegalArgumentException("Arrays of input streams and load options must be of the same dimension.");
        }
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < zzWf9Array.length; ++i) {
            merger.zzhG(zzWf9Array[i], loadOptionsArray != null ? loadOptionsArray[i] : null);
        }
        merger.zzYFr(zzWf92, saveOptions).execute();
    }

    private static Document zz45(zzWf9[] zzWf9Array, LoadOptions[] loadOptionsArray, int n) throws Exception {
        if (loadOptionsArray != null && zzWf9Array.length != loadOptionsArray.length) {
            throw new IllegalArgumentException("Arrays of input streams and load options must be of the same dimension.");
        }
        Document[] documentArray = new Document[zzWf9Array.length];
        for (int i = 0; i < zzWf9Array.length; ++i) {
            zzZdj zzZdj2 = new zzZdj(zzWf9Array[i], loadOptionsArray != null ? loadOptionsArray[i] : null, null);
            documentArray[i] = zzZdj2.zzSw();
        }
        return Merger.zz45(documentArray, n);
    }

    private static int zzXjw(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }
}

