/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.LoadOptions;
import com.aspose.words.ProcessorContext;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzWf9;
import com.aspose.words.internal.zzY5Z;
import com.aspose.words.internal.zzZco;
import com.aspose.words.internal.zzZds;
import com.aspose.words.zzLB;
import com.aspose.words.zzWn5;
import com.aspose.words.zzZdj;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Processor {
    private static boolean zzXzp = false;
    protected Document mResultDocument;
    private ProcessorContext zzZd5;
    private zzZdj zzYaj;
    private ArrayList<zzZdj> zzXuR = new ArrayList();
    private zzZds<zzWn5> zz3M = new zzZds();
    private zzZds<zzWn5> zzQd = new zzZds();

    Processor(ProcessorContext context) {
        this.zzZd5 = context;
    }

    public Processor from(String input) {
        return this.from(input, null);
    }

    public Processor from(String input, LoadOptions loadOptions) {
        this.zzYaj = new zzZdj(input, this.zzYFx(loadOptions), this.zzZd5.getLayoutOptions());
        zzY5Z.zz45(this.zzXuR, this.zzYaj);
        return this;
    }

    final Processor zz1k(zzWf9 zzWf92) {
        return this.zzhG(zzWf92, null);
    }

    final Processor zzhG(zzWf9 zzWf92, LoadOptions loadOptions) {
        this.zzYaj = new zzZdj(zzWf92, this.zzYFx(loadOptions), this.zzZd5.getLayoutOptions());
        zzY5Z.zz45(this.zzXuR, this.zzYaj);
        return this;
    }

    public Processor from(InputStream input) {
        return this.zzhG(zzWf9.zzYFr(input), null);
    }

    public Processor from(InputStream input, LoadOptions loadOptions) {
        return this.zzhG(zzWf9.zzYFr(input), loadOptions);
    }

    public Processor to(String output) throws Exception {
        return this.to(output, null);
    }

    public Processor to(String output, SaveOptions saveOptions) throws Exception {
        if (saveOptions == null) {
            int n = FileFormatUtil.extensionToSaveFormat(zzZco.zzcq(output));
            saveOptions = zzLB.zzXky(n, output);
        }
        this.zz45(new zzWn5(output, saveOptions));
        return this;
    }

    public Processor to(String output, int saveFormat) throws Exception {
        SaveOptions saveOptions = zzLB.zzXky(saveFormat, output);
        this.zz45(new zzWn5(output, saveOptions));
        return this;
    }

    final Processor zzYFr(zzWf9 zzWf92, SaveOptions saveOptions) {
        this.zz45(new zzWn5(zzWf92, saveOptions));
        return this;
    }

    public Processor to(OutputStream output, SaveOptions saveOptions) {
        return this.zzYFr(zzWf9.zzhG(output), saveOptions);
    }

    private Processor zzZ5g(zzWf9 zzWf92, int n) throws Exception {
        SaveOptions saveOptions = zzLB.zzXky(n, null);
        this.zz45(new zzWn5(zzWf92, saveOptions));
        return this;
    }

    public Processor to(OutputStream output, int saveFormat) throws Exception {
        return this.zzZ5g(zzWf9.zzhG(output), saveFormat);
    }

    public Processor toOutput(ArrayList<OutputStream> output, SaveOptions saveOptions) {
        return this.to(zzWf9.zzYCZ(output), saveOptions);
    }

    public Processor to(ArrayList<zzWf9> output, SaveOptions saveOptions) {
        this.zz45(new zzWn5(output, saveOptions));
        return this;
    }

    public Processor toOutput(ArrayList<OutputStream> output, int saveFormat) throws Exception {
        return this.to(zzWf9.zzYCZ(output), saveFormat);
    }

    public Processor to(ArrayList<zzWf9> output, int saveFormat) throws Exception {
        SaveOptions saveOptions = zzLB.zzXky(saveFormat, null);
        this.zz45(new zzWn5(output, saveOptions));
        return this;
    }

    public void execute() throws Exception {
        this.checkArgumentsSet();
        this.executeCore();
    }

    protected void executeCore() throws Exception {
        zzZds<zzWn5> zzZds2 = this;
        zzZds2 = ((Processor)((Object)zzZds2)).zzQd;
        if (zzZds2.size() == 0) {
            zzZds2 = this;
            zzZds2 = ((Processor)((Object)zzZds2)).zz3M;
            if (zzZds2.size() == 0) {
                return;
            }
        }
        this.zzWI8();
        this.zzXvG();
    }

    protected void checkArgumentsSet() {
        zzZds<zzWn5> zzZds2 = this;
        if (((Processor)((Object)zzZds2)).zzXuR.size() == 0) {
            throw new IllegalArgumentException("Input document is not specified.");
        }
        zzZds2 = this;
        zzZds2 = ((Processor)((Object)zzZds2)).zzQd;
        if (zzZds2.size() == 0) {
            zzZds2 = this;
            zzZds2 = ((Processor)((Object)zzZds2)).zz3M;
            if (zzZds2.size() == 0) {
                throw new IllegalArgumentException("Output document is not specified.");
            }
        }
    }

    private void zzWI8() throws Exception {
        if (this.mResultDocument == null) {
            throw new IllegalStateException("Result document is not initialized.");
        }
        while (true) {
            zzZds<zzWn5> zzZds2 = this;
            zzZds2 = ((Processor)((Object)zzZds2)).zzQd;
            if (zzZds2.size() <= 0) break;
            zzZds2 = this;
            zzWn5 zzWn52 = (zzWn5)((Processor)((Object)zzZds2)).zzQd.pop();
            zzWn52.zz1r(this.mResultDocument);
        }
    }

    private void zzXvG() throws Exception {
        if (this.mResultDocument == null) {
            throw new IllegalStateException("Result document is not initialized.");
        }
        if (this.mResultDocument.getOriginalLoadFormat() == 64) {
            this.mResultDocument.zzZgk();
        }
        while (true) {
            zzZds<zzWn5> zzZds2 = this;
            zzZds2 = ((Processor)((Object)zzZds2)).zz3M;
            if (zzZds2.size() <= 0) break;
            zzZds2 = this;
            zzWn5 zzWn52 = (zzWn5)((Processor)((Object)zzZds2)).zz3M.pop();
            zzWn52.zz1r(this.mResultDocument);
        }
    }

    private LoadOptions zzYFx(LoadOptions loadOptions) {
        if (this.zzZd5.getWarningCallback() != null || this.zzZd5.getFontSettings() != null) {
            if (loadOptions == null) {
                loadOptions = new LoadOptions();
            }
            if (loadOptions.getWarningCallback() == null) {
                loadOptions.setWarningCallback(this.zzZd5.getWarningCallback());
            }
            if (loadOptions.getFontSettings() == null) {
                loadOptions.setFontSettings(this.zzZd5.getFontSettings());
            }
        }
        return loadOptions;
    }

    private void zz45(zzWn5 zzWn52) {
        if (FileFormatUtil.zzfO(zzWn52.zzZwo().getSaveFormat())) {
            this.zz3M.push(zzWn52);
            return;
        }
        this.zzQd.push(zzWn52);
    }

    protected static String getPartFileName(String fileName, int partIndex, int saveFormat) throws Exception {
        String string = zzZco.zzZWu(fileName);
        String string2 = zzZco.zzYCw(fileName) + "_" + partIndex + FileFormatUtil.saveFormatToExtension(saveFormat);
        return zzZco.zznq(string, string2);
    }

    final zzZdj zzVPV() {
        return this.zzYaj;
    }

    final ArrayList<zzZdj> zzY4r() {
        return this.zzXuR;
    }

    final zzZds<zzWn5> zzWKe() {
        return this.zz3M;
    }

    final zzZds<zzWn5> zzXnb() {
        return this.zzQd;
    }
}

