/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.PreferredWidth;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzXCa;
import com.aspose.words.zzLB;
import com.aspose.words.zzRp;
import com.aspose.words.zzWCg;
import com.aspose.words.zzWZC;
import com.aspose.words.zzXOs;
import com.aspose.words.zzXQP;
import com.aspose.words.zzXtX;
import com.aspose.words.zzYDW;
import com.aspose.words.zzYWR;
import com.aspose.words.zzZbH;
import com.aspose.words.zzfd;

public class Row
extends CompositeNode<Cell>
implements zzZbH,
zzfd {
    private int zzXWT;
    private int zzYcf;
    private zzXOs zzZOU;
    private RowFormat zzYbi;
    private CellCollection zzX9m;

    public Row(DocumentBase doc) {
        this(doc, zzXOs.zzoX());
    }

    Row(DocumentBase doc, zzXOs rowPr) {
        super(doc);
        this.zzZOU = rowPr;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    public Table getParentTable() {
        return (Table)this.zzYrV();
    }

    public boolean isFirstRow() {
        Row row = this;
        return row == row.getParentTable().getFirstRow();
    }

    public boolean isLastRow() {
        Row row = this;
        return row == row.getParentTable().getLastRow();
    }

    final boolean zzXZ() {
        if (!this.getRowFormat().getHeadingFormat()) {
            return false;
        }
        return this.isFirstRow() || this.getPreviousRow().zzXZ();
    }

    public Row getNextRow() {
        return (Row)this.zzqt();
    }

    public Row getPreviousRow() {
        return (Row)this.zzXPo();
    }

    final int zzpo() {
        Table table = this.getParentTable();
        if (table != null) {
            for (int i = 0; i < table.getRows().getCount(); ++i) {
                if (this != table.getRows().get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public Cell getFirstCell() {
        return (Cell)this.zzkm();
    }

    public Cell getLastCell() {
        return (Cell)this.zzWtO();
    }

    public CellCollection getCells() {
        if (this.zzX9m == null) {
            this.zzX9m = new CellCollection(this);
        }
        return this.zzX9m;
    }

    public RowFormat getRowFormat() {
        if (this.zzYbi == null) {
            this.zzYbi = new RowFormat(this);
        }
        return this.zzYbi;
    }

    public boolean getHidden() {
        return this.zzZOU.getHidden();
    }

    public void setHidden(boolean value) {
        this.zzZOU.setHidden(value);
        this.zzY2c(value);
    }

    private void zzY2c(boolean bl) {
        for (Cell cell : this.zzX9m) {
            for (Paragraph paragraph : cell.getParagraphs()) {
                paragraph.zzWfy().zz45(bl ? zzWZC.zzXYw : zzWZC.zzXhh);
                for (Run run : paragraph.getRuns()) {
                    run.getFont().setHidden(bl);
                }
            }
        }
    }

    final zzXOs zzwc() {
        return this.zzZOU;
    }

    final void zz45(zzXOs zzXOs2) {
        this.zzZOU = zzXOs2;
    }

    final boolean zzWu5() {
        PreferredWidth preferredWidth = this.zzXpy();
        return preferredWidth != null && preferredWidth.zzZrr();
    }

    final int zzWto() {
        if (this.zzWu5()) {
            return Math.max(this.zzXpy().zzYyb(), 0);
        }
        return 0;
    }

    private PreferredWidth zzXpy() {
        PreferredWidth preferredWidth = (PreferredWidth)this.getDirectRowAttr(4290);
        if (preferredWidth == null) {
            TableStyle tableStyle = zzXCa.zz45((Object)this.getParentTable().getStyle(), TableStyle.class);
            while (tableStyle != null && (preferredWidth = (PreferredWidth)tableStyle.getDirectRowAttr(4290)) == null) {
                tableStyle = zzXCa.zz45((Object)tableStyle.zzXLk(), TableStyle.class);
            }
        }
        return preferredWidth;
    }

    final void zzYOD() {
        Row row = this;
        if (row.zzZOU.zzYzx(4005)) {
            row = this;
            Style style = this.getDocument().getStyles().zz1d(row.zzZOU.zzZ3L(), false);
            if (style == null || style.getType() != 3) {
                row = this;
                row.zzZOU.zzXsA(11);
            }
        }
    }

    @Override
    final Node zz45(boolean bl, zzYDW zzYDW2) {
        Row row = (Row)super.zz45(bl, zzYDW2);
        zzXOs zzXOs2 = this.zzZOU;
        ((Row)super.zz45(bl, zzYDW2)).zzZOU = (zzXOs)zzXOs2.zzZsT();
        row.zzYbi = null;
        row.zzX9m = null;
        return row;
    }

    final boolean zzWJ7(Row row) {
        Paragraph paragraph;
        Paragraph paragraph2;
        Cell cell;
        Cell cell2;
        Row row2 = this;
        Row row3 = row2;
        row3 = row;
        if (!row2.zzZOU.zzZWj(row3.zzZOU)) {
            return false;
        }
        row3 = this;
        if (!row3.zzZOU.zzXzs() && !this.getParentTable().zzWIy() && zzXCa.zzW36(cell2 = this.getFirstCell(), cell = row.getFirstCell()) && zzXCa.zzW36(paragraph2 = (Paragraph)cell2.getChild(8, 0, true), paragraph = (Paragraph)cell.getChild(8, 0, true))) {
            zzXQP zzXQP2 = paragraph2.zzZkL(265);
            zzXQP zzXQP3 = paragraph.zzZkL(265);
            return zzXQP2.zzW36(zzXQP3);
        }
        return true;
    }

    final void zzXkc() {
        Table table = this.getParentTable();
        Table table2 = new Table(table.getDocument());
        table.zzY2Z(table2);
        Node node = this;
        while (node != null) {
            Node node2 = node.getNextSibling();
            node.remove();
            table2.zzXbn(node);
            node = node2;
        }
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitRowStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitRowEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public void ensureMinimum() {
        Cell cell = this.getFirstCell();
        if (cell == null) {
            cell = this.appendChild(new Cell(this.getDocument()));
        }
        cell.ensureMinimum();
    }

    @Override
    final String zzXIr() {
        return ControlChar.CELL;
    }

    @Override
    final boolean zzWHP(Node node) {
        return zzLB.zznq(node);
    }

    final void zz45(CellCollection cellCollection) {
        this.getCells().getCount();
        cellCollection.getCount();
        for (int i = 0; i < cellCollection.getCount(); ++i) {
            zzYWR zzYWR2 = this.getCells().get(i).zzZ94();
            if (zzYWR2 == null) continue;
            zzYWR zzYWR3 = zzYWR2;
            cellCollection.get(i).zz45((zzYWR)zzYWR3.zzZsT());
        }
    }

    final void zzw8() {
        for (Paragraph paragraph : this.getChildNodes(8, true)) {
            paragraph.zzYzm().zzWaE();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzZOU.zzXk9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        Object object = this.zzZOU.get(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedRowAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        TableStyle tableStyle;
        if (this.getParentTable() != null && (tableStyle = zzXCa.zz45((Object)this.getParentTable().getStyle(), TableStyle.class)) != null) {
            return tableStyle.fetchRowAttr(key);
        }
        return zzXOs.zzYJt(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzZOU.zzZ5g(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzZOU.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() throws Exception {
        this.zzZOU.resetToDefaultAttrs();
    }

    final void zzZ4i() {
        if (!this.getDocument().zzX9p().zzYWt.zzGq()) {
            return;
        }
        Row row = this;
        if (row.zzZOU.getAlignment() != 0) {
            row = this;
            row.zzZOU.remove(4340);
        }
        row = this;
        if (row.zzZOU.zzZo6()) {
            int n;
            row = this;
            zzXOs zzXOs2 = (zzXOs)row.zzZOU.zzYvk().zzY97();
            if (zzXOs2.zzZVT(4010)) {
                n = zzXOs2.getAlignment();
            } else {
                int n2;
                row = this;
                n = n2 = row.zzZOU.getAlignment();
            }
            if (n != 0) {
                zzXOs2.remove(4340);
            }
        }
    }

    final int zzWR() {
        return this.zzXWT;
    }

    final void zzXwl(int n) {
        this.zzXWT = n;
    }

    final int zzZo5() {
        return this.zzYcf;
    }

    final void zzW9r(int n) {
        this.zzYcf = n;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXtX getInsertRevision() {
        Row row = this;
        return row.zzZOU.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzXtX value) {
        Cloneable cloneable = this;
        zzXtX zzXtX2 = value;
        cloneable = cloneable.zzZOU;
        ((zzWCg)cloneable).zzZ5g(14, zzXtX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzXtX getDeleteRevision() {
        Row row = this;
        return row.zzZOU.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzXtX value) {
        Cloneable cloneable = this;
        zzXtX zzXtX2 = value;
        cloneable = cloneable.zzZOU;
        ((zzWCg)cloneable).zzZ5g(12, zzXtX2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzRp getMoveFromRevision() {
        Row row = this;
        return row.zzZOU.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzRp value) {
        Cloneable cloneable = this;
        zzRp zzRp2 = value;
        cloneable = cloneable.zzZOU;
        ((zzWCg)cloneable).zzZ5g(13, zzRp2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzRp getMoveToRevision() {
        Row row = this;
        return row.zzZOU.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzRp value) {
        Cloneable cloneable = this;
        zzRp zzRp2 = value;
        cloneable = cloneable.zzZOU;
        ((zzWCg)cloneable).zzZ5g(15, zzRp2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Row row = this;
        row.zzZOU.remove(13);
        row = this;
        row.zzZOU.remove(15);
    }
}

