/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzWYW;
import com.aspose.words.internal.zzWc2;
import com.aspose.words.internal.zzZco;
import java.util.TimeZone;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzYNW;
    private boolean zzXvb;
    boolean zzXE1 = true;
    private boolean zzWgl = true;
    private boolean zzXyM = false;
    private boolean zzxC;
    private boolean zzYFf = true;
    private boolean zzWfG;
    private String zzYn0;
    private boolean zzZnA;
    private boolean zzsZ = false;
    private int zzX0l = 1;
    private int zzY3e = 1;
    private int zzZsy = 0;
    private String zzZks = "";
    private boolean zzYjN = true;
    private boolean zzYr9 = true;
    private boolean zzW5L;
    private boolean zzWbC;
    private int zzZts = 0;
    private boolean zzWEE = true;
    private boolean zzYhS = false;
    private boolean zzWvH = false;
    private TimeZone zzZEE = zzWYW.getTimeZone();

    protected SaveOptions() {
    }

    final boolean zzYjd() {
        return this.zzxC;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzZDB() {
        return false;
    }

    boolean zzGl() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzYFf;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzYFf = value;
    }

    public String getTempFolder() {
        return this.zzYn0;
    }

    public void setTempFolder(String value) {
        this.zzYn0 = value;
    }

    public boolean getPrettyFormat() {
        return this.zzWfG;
    }

    public void setPrettyFormat(boolean value) {
        this.zzWfG = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzZnA;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzZnA = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzsZ;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzsZ = value;
    }

    public int getDmlRenderingMode() {
        return this.zzX0l;
    }

    public void setDmlRenderingMode(int value) {
        this.zzX0l = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzZsy;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzZsy = value;
    }

    public int getImlRenderingMode() {
        return this.zzY3e;
    }

    public void setImlRenderingMode(int value) {
        this.zzY3e = value;
    }

    public String getDefaultTemplate() {
        return this.zzZks;
    }

    public void setDefaultTemplate(String value) {
        this.zzZks = value;
    }

    public boolean getUpdateFields() {
        return this.zzYjN;
    }

    public void setUpdateFields(boolean value) {
        this.zzYjN = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzW5L;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzW5L = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzWbC;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzWbC = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzYhS;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzYhS = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzXyM;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzXyM = value;
    }

    public boolean getUpdateAmbiguousTextFont() {
        return this.zzWvH;
    }

    public void setUpdateAmbiguousTextFont(boolean value) {
        this.zzWvH = value;
    }

    final boolean zzYtm() {
        return this.zzYr9;
    }

    final boolean zzgJ() {
        return this.zzWEE;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzVSL(zzWc2.zzWP0(zzZco.zzcq(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzZts;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzZts = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzYNW;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzYNW = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzXvb;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzXvb = value;
    }

    public TimeZone getCustomTimeZoneInfo() {
        return this.zzZEE;
    }

    public void setCustomTimeZoneInfo(TimeZone value) {
        this.zzZEE = value;
    }

    final boolean zzXeQ() {
        return this.zzWgl;
    }

    final void zzYLJ(boolean bl) {
        this.zzWgl = false;
    }
}

