/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CheckGrammarOptions;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.Node;
import com.aspose.words.NodeCollection;
import com.aspose.words.Run;
import com.aspose.words.SummarizeOptions;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzW1b;
import com.aspose.words.internal.zzWoj;
import com.aspose.words.internal.zzXKN;
import com.aspose.words.internal.zzXaS;
import com.aspose.words.internal.zzYXq;
import com.aspose.words.internal.zzuk;
import com.aspose.words.zz2f;
import com.aspose.words.zzI;
import com.aspose.words.zzUV;
import com.aspose.words.zzW7p;
import com.aspose.words.zzWZT;
import com.aspose.words.zzWcZ;
import com.aspose.words.zzWlI;
import com.aspose.words.zzXzL;
import com.aspose.words.zzY0y;
import com.aspose.words.zzY3F;
import com.aspose.words.zzYU4;
import com.aspose.words.zzYWW;
import com.aspose.words.zzYwz;
import com.aspose.words.zzZ3X;
import com.aspose.words.zzZhX;
import com.aspose.words.zzZnm;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;

public abstract class AiModel {
    private String zzYwL;

    public abstract Document summarize(Document var1, SummarizeOptions var2) throws Exception;

    public abstract Document summarize(Document[] var1, SummarizeOptions var2) throws Exception;

    public Document checkGrammar(Document sourceDocument, CheckGrammarOptions options) throws Exception {
        Document document = options == null || options.getPreserveFormatting() ? this.zzYQ4(sourceDocument, options) : this.zzW07(sourceDocument, options);
        document.zzuR().add(32);
        if (options != null && options.getMakeRevisions()) {
            Document document2 = sourceDocument.deepClone();
            document2.zzW07(document, "AI", zzXaS.zzX8p());
            return document2;
        }
        return document;
    }

    public abstract Document translate(Document var1, int var2) throws Exception;

    public AiModel withApiKey(String apiKey) {
        String string = apiKey;
        AiModel aiModel = this;
        this.zzYwL = string;
        return this;
    }

    public static AiModel create(int modelType) {
        switch (modelType) {
            case 0: {
                return new zzXzL();
            }
            case 1: {
                return new zz2f();
            }
            case 2: {
                return new zzY3F();
            }
            case 3: {
                return new zzYwz();
            }
            case 4: {
                return new zzYU4();
            }
            case 5: {
                return new zzZnm();
            }
            case 6: {
                return new zzWlI();
            }
            case 7: {
                return new zzWZT();
            }
            case 8: {
                return new zzI();
            }
            case 10: {
                return new zzZ3X();
            }
            case 9: {
                return new zzW7p();
            }
            case 11: {
                return new zzYWW();
            }
        }
        throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: modelType" + modelType);
    }

    AiModel() {
    }

    private static String zzWql(InputStream inputStream) throws IOException {
        int n;
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        StringBuilder stringBuilder = new StringBuilder();
        while (-1 != (n = bufferedReader.read())) {
            stringBuilder.append((char)n);
        }
        return stringBuilder.toString();
    }

    final String zzW2x(ArrayList<zzUV> arrayList, int n) throws Exception {
        String string = this.zzYiv(arrayList, n);
        zzXKN zzXKN2 = new zzXKN();
        byte[] byArray = zzXKN2.zzXPO(string);
        HttpURLConnection httpURLConnection = this.zzXo(n);
        httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
        AiModel.zzW07(string, httpURLConnection);
        return AiModel.zzYIm(httpURLConnection);
    }

    private HttpURLConnection zzXo(int n) throws Exception {
        String string = zzWoj.zzYQ4("{0}{1}{2}", new Object[]{this.getUrl(), zzWoj.zzYQ4(this.getUrl(), "/", zzW1b.INVARIANT_CULTURE_IGNORE_CASE) ? "" : "/", this.toString(n)});
        HttpURLConnection httpURLConnection = (HttpURLConnection)new URL(string).openConnection();
        httpURLConnection.setRequestProperty("Content-Type", "application/json");
        httpURLConnection.setRequestMethod("POST");
        if (this.zzYhe() != null) {
            zzYXq.zzW07 zzW072 = this.zzYhe().zzZba();
            while (zzW072.moveNext()) {
                httpURLConnection.setRequestProperty(zzW072.zzLJ(), zzW072.zzZoE());
            }
        }
        return httpURLConnection;
    }

    private static void zzW07(String string, HttpURLConnection httpURLConnection) throws IOException {
        httpURLConnection.setDoOutput(true);
        OutputStream outputStream = httpURLConnection.getOutputStream();
        BufferedWriter bufferedWriter = new BufferedWriter(new OutputStreamWriter(outputStream, "UTF-8"));
        bufferedWriter.write(string);
        bufferedWriter.flush();
        bufferedWriter.close();
        outputStream.close();
    }

    private static String zzYIm(HttpURLConnection httpURLConnection) throws IOException {
        try {
            String string = AiModel.zzWql(httpURLConnection.getInputStream());
            int n = httpURLConnection.getResponseCode();
            if (n == 200 || n == 202 || n == 201) {
                return string;
            }
        }
        catch (Exception exception) {
            String string = AiModel.zzWql(httpURLConnection.getErrorStream());
            if (string.isEmpty()) {
                throw new IllegalStateException("Request error with Error message: " + exception.getMessage());
            }
            return string;
        }
        return "";
    }

    private String toString(int requestMethod) {
        switch (requestMethod) {
            case 0: {
                return this.zzWah();
            }
            case 1: {
                return this.zzXka();
            }
        }
        throw new IllegalArgumentException(null + "\r\nParameter name: " + zzY0y.toString(requestMethod) + "\r\nParameter value: " + requestMethod);
    }

    private Document zzW07(Document document, CheckGrammarOptions checkGrammarOptions) throws Exception {
        Object object2;
        NodeCollection nodeCollection;
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document, new zzWcZ(), true);
        ArrayList arrayList = nodeCollection.zzXS8();
        if (arrayList.size() == 0) {
            return document.deepClone();
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Object object2 : arrayList) {
            zzVUI.zzYQ4(stringBuilder, ((Run)object2).getText());
        }
        String string = zzWoj.zzYpS(this.zzW07(stringBuilder.toString(), checkGrammarOptions), "\r\n".toCharArray());
        object2 = new DocumentBuilder();
        ((DocumentBuilder)object2).write(string);
        return ((DocumentBuilder)object2).getDocument();
    }

    private Document zzYQ4(Document document, CheckGrammarOptions checkGrammarOptions) throws Exception {
        String string;
        NodeCollection nodeCollection;
        Document document2 = document.deepClone();
        document2.joinRunsWithSameFormatting();
        NodeCollection nodeCollection2 = nodeCollection = new NodeCollection((CompositeNode)document2, new zzWcZ(), true);
        ArrayList<Node> arrayList = nodeCollection.zzXS8();
        if (arrayList.size() == 0) {
            return document2;
        }
        zzZhX.zzWD3(arrayList);
        String string2 = zzZhX.zzYwY(arrayList);
        zzuk zzuk2 = null;
        for (int i = 0; i <= 3 && (zzuk2 = zzZhX.zzYIm(string = zzWoj.zzYpS(this.zzW07(string2, checkGrammarOptions), "\r\n".toCharArray()), arrayList)).getCount() <= 0; ++i) {
        }
        if (zzuk2.getCount() > 0) {
            zzuk zzuk3 = zzZhX.zzYQ4(zzuk2, arrayList.size() - 1);
            for (int i = 0; i < zzuk3.getCount(); ++i) {
                int n = zzuk3.get(i);
                arrayList.get(n).remove();
            }
        }
        return document2;
    }

    protected abstract String getName();

    protected abstract String getUrl();

    final String zzuK() {
        return this.zzYwL;
    }

    abstract String zzW07(String var1, CheckGrammarOptions var2) throws Exception;

    abstract String zzYiv(ArrayList<zzUV> var1, int var2);

    abstract String zzXka();

    abstract String zzWah();

    abstract zzYXq zzYhe();
}

