/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CommentCollection;
import com.aspose.words.CommentRangeEnd;
import com.aspose.words.CommentRangeStart;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.InlineStory;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SpecialChar;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzXaS;
import com.aspose.words.internal.zzZlO;
import com.aspose.words.zz0s;
import com.aspose.words.zzVQP;
import com.aspose.words.zzWqU;
import com.aspose.words.zzXNL;
import com.aspose.words.zzY72;
import com.aspose.words.zzaK;
import com.aspose.words.zzvR;
import java.util.ArrayList;
import java.util.Date;

public final class Comment
extends InlineStory
implements zzVQP,
zzWqU {
    private zzvR zzYLC;
    private int zzYSI;
    private boolean zzZ2v;
    private boolean zzYH;
    private int zzYLf;
    private int zzWam = -1;
    private String zzEP = "";
    private String zzYMW = "";
    private zzXaS zzZ9o = zzXaS.zzQd;
    private zzXaS zzXL0 = zzXaS.zzQd;
    private CommentCollection zzXcS;

    Comment(DocumentBase doc, zz0s runPr) {
        super(doc, runPr);
        this.zzYLf = doc.zzWJC();
    }

    public Comment(DocumentBase doc) {
        this(doc, "", "", zzXaS.zzQd);
    }

    private Comment(DocumentBase doc, String author, String initial, zzXaS dateTime) {
        this(doc, new zz0s());
        this.setAuthor(author);
        this.setInitial(initial);
        zzXaS zzXaS2 = dateTime;
        Comment comment = this;
        this.zzZ9o = zzXaS2;
        this.getFont().setStyleIdentifier(39);
    }

    public Comment(DocumentBase doc, String author, String initial, Date dateTime) {
        this(doc, author, initial, zzXaS.zzW07(dateTime));
    }

    @Override
    public final int getNodeType() {
        return 19;
    }

    @Override
    public final int getStoryType() {
        return 4;
    }

    public final int getId() {
        return this.zzYLf;
    }

    public final void setId(int value) {
        this.zzYLf = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWF1();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getIdInternal() {
        return this.getId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setIdInternal(int value) {
        this.setId(value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final int getParentIdInternal() {
        return this.getParentId();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setParentIdInternal(int value) {
        this.setParentId(value);
    }

    public final String getInitial() {
        return this.zzEP;
    }

    public final void setInitial(String value) {
        zzVUI.zzYQ4((Object)value, "Initial");
        this.zzEP = value;
    }

    public final Date getDateTime() {
        Comment comment = this;
        return zzXaS.zzYSz(comment.zzZ9o);
    }

    private void zzYlB(zzXaS zzXaS2) {
        this.zzZ9o = zzXaS2;
        if (!zzXaS.zzW07(this.zzXL0, zzXaS.zzQd)) {
            this.zzXL0 = !zzXaS.zzW07(zzXaS2, zzXaS.zzQd) ? zzXaS2.zzZ8E() : zzXaS.zzQd;
        }
    }

    public final void setDateTime(Date value) {
        this.zzYlB(zzXaS.zzW07(value));
    }

    final zzXaS zzWVF() {
        if (!zzXaS.zzW07(this.zzXL0, zzXaS.zzQd)) {
            return this.zzXL0;
        }
        if (!zzXaS.zzW07(this.zzZ9o, zzXaS.zzQd)) {
            return this.zzZ9o.zzZ8E();
        }
        return zzXaS.zzQd;
    }

    public final Date getDateTimeUtc() {
        return zzXaS.zzYSz(this.zzWVF());
    }

    final void zzY2S(zzXaS zzXaS2) {
        this.zzXL0 = zzXaS2;
    }

    public final String getAuthor() {
        return this.zzYMW;
    }

    public final void setAuthor(String value) {
        zzVUI.zzYQ4((Object)value, "Author");
        this.zzYMW = value;
    }

    final zzXaS zzZGr() {
        return this.zzZ9o;
    }

    final void zzOE(zzXaS zzXaS2) {
        this.zzZ9o = zzXaS2;
    }

    final boolean zzW9j() {
        return !zzXaS.zzW07(this.zzXL0, zzXaS.zzQd);
    }

    final zzvR zzXqb() {
        return this.zzYLC;
    }

    final void zzW07(zzvR zzvR2) {
        this.zzYLC = zzvR2;
    }

    final boolean zzHO() {
        Comment comment = this;
        if (comment.zzYLC != null) {
            comment = this;
            if (comment.zzYLC.getCount() > 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    private Comment zzW07(String string, String string2, zzXaS zzXaS2, String string3) throws Exception {
        if (this.getParentId() != -1) {
            throw new IllegalStateException("Cannot add a reply to another reply.");
        }
        if (this.getParentNode() == null) {
            throw new IllegalStateException("No parent node.");
        }
        Comment comment = new Comment(this.getDocument(), string, string2, zzXaS2);
        comment.setIdInternal(zzXNL.zzW07(this.getDocument()));
        comment.setParentId(this.zzYLf);
        comment.setText(string3);
        Comment comment2 = this;
        Comment comment3 = zzVUI.zzW07((Object)this.zzZpT(), Comment.class);
        while (comment3 != null && comment3.getParentId() == this.zzYLf) {
            comment2 = comment3;
            comment3 = zzVUI.zzW07((Object)comment3.zzZpT(), Comment.class);
        }
        this.getParentNode().insertAfter(comment, comment2);
        zzaK zzaK2 = new zzaK();
        if (zzaK2.zzYQ4(this.getDocument(), this.zzYLf)) {
            this.zzW07(zzaK2.zzYQ1(), new CommentRangeStart(this.getDocument(), comment.getId()));
            this.zzW07(zzaK2.zzGC(), new CommentRangeEnd(this.getDocument(), comment.getId()));
        }
        return comment;
    }

    public final Comment addReply(String author, String initial, Date dateTime, String text) throws Exception {
        return this.zzW07(author, initial, zzXaS.zzW07(dateTime), text);
    }

    private void zzW07(CommentRangeStart commentRangeStart, CommentRangeStart commentRangeStart2) {
        Node node2;
        ArrayList arrayList = new ArrayList();
        for (Node node2 : this.getReplies()) {
            zzZlO.zzW07(arrayList, Integer.valueOf(node2.getId()));
        }
        Object object = commentRangeStart;
        while (((Node)object).getNextSibling() != null && ((Node)(node2 = ((Node)object).getNextSibling())).getNodeType() == 33 && arrayList.contains(((CommentRangeStart)node2).getId())) {
            object = node2;
        }
        ((Node)object).zzYUr(commentRangeStart2);
    }

    private void zzW07(CommentRangeEnd commentRangeEnd, CommentRangeEnd commentRangeEnd2) {
        ArrayList arrayList = new ArrayList();
        for (Node node : this.getReplies()) {
            if (((Comment)node).getId() == commentRangeEnd2.getId()) continue;
            zzZlO.zzW07(arrayList, Integer.valueOf(((Comment)node).getId()));
        }
        Object object = commentRangeEnd;
        while (((Node)object).getNextSibling() != null) {
            int n;
            Node node;
            node = ((Node)object).getNextSibling();
            if (node.getNodeType() == 34) {
                n = ((CommentRangeEnd)node).getId();
            } else {
                if (node.getNodeType() != 19) break;
                n = ((Comment)node).getId();
            }
            if (!arrayList.contains(n) && n != this.zzYLf) break;
            object = node;
        }
        ((Node)object).zzYUr(commentRangeEnd2);
    }

    public final void removeReply(Comment reply) throws Exception {
        zzaK zzaK2 = new zzaK();
        if (zzaK2.zzYQ4(this.getDocument(), reply.getId())) {
            zzaK2.zzYQ1().remove();
            zzaK2.zzGC().remove();
        }
        reply.remove();
    }

    public final void removeAllReplies() throws Exception {
        for (Comment comment : this.getReplies().zzXS8()) {
            this.removeReply(comment);
        }
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitCommentEnd(this);
    }

    public final void setText(String text) {
        this.removeAllChildren();
        Paragraph paragraph = new Paragraph(this.getDocument());
        paragraph.getParagraphFormat().setStyleIdentifier(30);
        this.appendChild(paragraph);
        DocumentBuilder documentBuilder = new DocumentBuilder(this.zzWff());
        documentBuilder.moveTo(paragraph);
        SpecialChar specialChar = new SpecialChar(this.zzWff(), '\u0005', new zz0s());
        specialChar.getFont().setStyleIdentifier(39);
        documentBuilder.insertNode(specialChar);
        documentBuilder.write(text);
    }

    public final Comment getAncestor() {
        if (this.getDocument() == null || this.getParentId() == -1) {
            return null;
        }
        for (Comment comment : this.getDocument().getChildNodes(19, true)) {
            if (comment.getId() != this.getParentId()) continue;
            return comment;
        }
        return null;
    }

    public final CommentCollection getReplies() {
        if (this.zzXcS == null) {
            this.zzXcS = new CommentCollection(this.getDocument(), this);
        }
        return this.zzXcS;
    }

    public final boolean getDone() {
        return this.zzYH;
    }

    public final void setDone(boolean value) {
        this.zzYH = value;
    }

    public final int getParentId() {
        return this.zzWam;
    }

    public final void setParentId(int value) {
        this.zzWam = value;
        if (this.getDocument() != null) {
            this.getDocument().zzWF1();
        }
    }

    final int zzW6e() {
        return this.zzYSI;
    }

    final void zzXRu(int n) {
        this.zzYSI = n;
    }

    final boolean zzYM3() {
        return this.zzZ2v;
    }

    final void zzZA9(boolean bl) {
        this.zzZ2v = bl;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzY72 getMoveFromRevision() {
        return this.zzFu().getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveFromRevision(zzY72 value) {
        zzY72 zzY722 = value;
        zz0s zz0s2 = this.zzFu();
        zz0s2.zzZKJ(13, zzY722);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final zzY72 getMoveToRevision() {
        return this.zzFu().getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setMoveToRevision(zzY72 value) {
        zzY72 zzY722 = value;
        zz0s zz0s2 = this.zzFu();
        zz0s2.zzZKJ(15, zzY722);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void removeMoveRevisions() {
        this.zzFu().remove(13);
        this.zzFu().remove(15);
    }

    final String zzWuN() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWss(stringBuilder);
        if (stringBuilder.length() > 0 && stringBuilder.charAt(0) == '\u0005') {
            stringBuilder.delete(0, 1);
        }
        return stringBuilder.toString();
    }
}

