/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CertificateHolder;
import com.aspose.words.DigitalSignature;
import com.aspose.words.DigitalSignatureCollection;
import com.aspose.words.Document;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.SignOptions;
import com.aspose.words.UnsupportedFileFormatException;
import com.aspose.words.internal.zz3K;
import com.aspose.words.internal.zz98;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzWX5;
import com.aspose.words.internal.zzWa9;
import com.aspose.words.internal.zzWoj;
import com.aspose.words.internal.zzX2c;
import com.aspose.words.internal.zzXAr;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzXb;
import com.aspose.words.internal.zzXgY;
import com.aspose.words.internal.zzYb3;
import com.aspose.words.internal.zzZfS;
import com.aspose.words.ref.Ref;
import com.aspose.words.zzNY;
import com.aspose.words.zzQ1;
import com.aspose.words.zzW3k;
import com.aspose.words.zzWE3;
import com.aspose.words.zzWji;
import com.aspose.words.zzX4b;
import com.aspose.words.zzX8W;
import com.aspose.words.zzXDw;
import com.aspose.words.zzXu1;
import com.aspose.words.zzXwI;
import com.aspose.words.zzY8q;
import com.aspose.words.zzYjS;
import com.aspose.words.zzZWh;
import com.aspose.words.zzZWo;
import com.aspose.words.zzZmv;
import java.io.InputStream;
import java.io.OutputStream;

public class DigitalSignatureUtil {
    private static final String zzWab = zz98.zzAo().zzXm6(new byte[]{105, 83, 110, 103, 110, 105, 32, 103, 101, 102, 116, 97, 114, 117, 32, 101, 115, 105, 110, 32, 116, 111, 115, 32, 112, 117, 111, 112, 116, 114, 100, 101, 98, 32, 32, 121, 104, 116, 115, 105, 102, 32, 108, 105, 32, 101, 111, 102, 109, 114, 116, 97, 46});

    private DigitalSignatureUtil() {
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        zzVUI.zzYQ4((Object)zzXTI2, "srcStream");
        zzVUI.zzYQ4((Object)zzXTI3, "dstStream");
        zzVUI.zzYQ4((Object)certificateHolder, "certHolder");
        DigitalSignatureUtil.zzYQ4(zzXTI2, zzXTI3, certificateHolder, signOptions);
        zzXTI3.flush();
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        DigitalSignatureUtil.zzW07(zzXTI.zzYQ4(srcStream), (zzXTI)zzXTI.zzYIm(dstStream), certHolder, signOptions);
    }

    private static void zzYQ4(zzXTI zzXTI2, zzXTI zzXTI3, CertificateHolder certificateHolder, SignOptions signOptions) throws Exception {
        DigitalSignature digitalSignature = new DigitalSignature(certificateHolder);
        if (signOptions != null) {
            signOptions.zzYIm(digitalSignature);
        }
        DigitalSignatureUtil.zzW07(digitalSignature, signOptions);
        if (zzYjS.zzW7i(zzXTI2)) {
            DigitalSignatureUtil.zzW07(zzXTI2, zzXTI3, digitalSignature, true);
            return;
        }
        zzYjS zzYjS2 = new zzYjS();
        zzXTI zzXTI4 = zzXTI2;
        zzYjS zzYjS3 = zzYjS2;
        FileFormatInfo fileFormatInfo = zzYjS2.zzYQ4(zzXTI4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXgY zzXgY2 = new zzXgY(zzXTI2);
                int n = fileFormatInfo.zzZSp() == 1 ? 1 : 2;
                zzQ1.zzW07(zzXgY2, digitalSignature, n);
                zzXTI3.zzad(0L);
                zzXgY2.zzyp(zzXTI3);
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                if (fileFormatInfo.isEncrypted()) {
                    String string = signOptions != null ? signOptions.getDecryptionPassword() : null;
                    DigitalSignatureUtil.zzW07(fileFormatInfo.zzZhp(), zzXTI3, digitalSignature, string);
                    return;
                }
                DigitalSignatureUtil.zzW07(zzXTI2, zzXTI3, digitalSignature, false);
                return;
            }
            case 60: 
            case 61: {
                DigitalSignatureUtil.zzW07(zzXTI2, zzXTI3, digitalSignature);
                return;
            }
        }
        throw new IllegalStateException(zzWab);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder, SignOptions signOptions) throws Exception {
        zzVUI.zzXhM(srcFileName, "srcFileName");
        zzVUI.zzXhM(dstFileName, "dstFileName");
        zzYb3 zzYb32 = zzVUI.zzYQ4(srcFileName, 3, 1);
        try {
            zzYb3 zzYb33 = zzVUI.zzYQ4(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzW07((zzXTI)zzYb32, (zzXTI)zzYb33, certHolder, signOptions);
            }
            finally {
                zzYb33.close();
            }
            return;
        }
        finally {
            zzYb32.close();
        }
    }

    public static void sign(InputStream srcStream, OutputStream dstStream, CertificateHolder certHolder) throws Exception {
        CertificateHolder certificateHolder = certHolder;
        zzXAr zzXAr2 = zzXTI.zzYIm(dstStream);
        zzXTI zzXTI2 = zzXTI.zzYQ4(srcStream);
        DigitalSignatureUtil.zzW07(zzXTI2, (zzXTI)zzXAr2, certificateHolder, null);
    }

    public static void sign(String srcFileName, String dstFileName, CertificateHolder certHolder) throws Exception {
        DigitalSignatureUtil.sign(srcFileName, dstFileName, certHolder, null);
    }

    public static void removeAllSignatures(String srcFileName, String dstFileName) throws Exception {
        zzYb3 zzYb32 = zzVUI.zzYQ4(srcFileName, 3, 1);
        try {
            zzYb3 zzYb33 = zzVUI.zzYQ4(dstFileName, 4, 2);
            try {
                DigitalSignatureUtil.zzWql(zzYb32, zzYb33);
            }
            finally {
                zzYb33.close();
            }
            return;
        }
        finally {
            zzYb32.close();
        }
    }

    private static void zzWql(zzXTI zzXTI2, zzXTI zzXTI3) throws Exception {
        zzYjS zzYjS2 = new zzYjS();
        zzXTI zzXTI4 = zzXTI2;
        Object object = zzYjS2;
        FileFormatInfo fileFormatInfo = zzYjS2.zzYQ4(zzXTI4, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: {
                zzXgY zzXgY2 = new zzXgY(zzXTI2);
                zzXgY2.zzWzJ().zzyL("_xmlsignatures");
                zzXgY2.zzWzJ().zzyL("_signatures");
                zzXTI3.zzYwY(0L);
                zzXgY2.zzyp(zzXTI3);
                zzXTI zzXTI5 = zzXTI3;
                zzXTI5.zzad(zzXTI5.zzW1M());
                return;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                zzX2c zzX2c2 = new zzX2c(zzXTI2);
                zz3K zz3K2 = zzX2c2.zzW07(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (zz3K2 != null) {
                    for (zzWa9 zzWa92 : zz3K2.zzYwz()) {
                        String string = zz3K2.zzW07(zzWa92);
                        zzX2c2.zzZTX().remove(string);
                    }
                    zzX2c2.zzZTX().remove(zz3K2.getName());
                    zzWa9 zzWa93 = zzX2c2.zzYwz().zzVQy("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                    zzX2c2.zzYwz().remove(zzWa93.getId());
                    zzX2c2.zzWxP();
                }
                zzXTI3.zzYwY(0L);
                zzX2c2.zzyp(zzXTI3);
                zzXTI zzXTI6 = zzXTI3;
                zzXTI6.zzad(zzXTI6.zzW1M());
                return;
            }
            case 60: 
            case 61: {
                zzZWh zzZWh2 = new zzZWh(zzXTI2);
                zzXwI zzXwI2 = zzZWh2.zzWD3("/META-INF/documentsignatures.xml");
                if (zzXwI2 != null) {
                    zzZWh2.zzWpx().remove(zzXwI2.getName());
                }
                zzXTI3.zzYwY(0L);
                String string = "application/vnd.oasis.opendocument.text";
                zzXTI4 = zzXTI3;
                object = zzZWh2;
                ((zzZWh)object).zzW07(zzXTI4, string, null);
                zzXTI zzXTI7 = zzXTI3;
                zzXTI7.zzad(zzXTI7.zzW1M());
                return;
            }
        }
        throw new IllegalStateException(zzWab);
    }

    public static void removeAllSignatures(InputStream srcStream, OutputStream dstStream) throws Exception {
        DigitalSignatureUtil.zzWql(zzXTI.zzYQ4(srcStream), zzXTI.zzYIm(dstStream));
    }

    public static DigitalSignatureCollection loadSignatures(String fileName) throws Exception {
        zzYb3 zzYb32 = zzVUI.zzYQ4(fileName, 3, 1);
        try {
            DigitalSignatureCollection digitalSignatureCollection = DigitalSignatureUtil.zzY3r(zzYb32);
            return digitalSignatureCollection;
        }
        finally {
            zzYb32.close();
        }
    }

    private static DigitalSignatureCollection zzY3r(zzXTI zzXTI2) throws Exception {
        if (zzYjS.zzW7i(zzXTI2)) {
            return DigitalSignatureUtil.zzXKO(zzXTI2);
        }
        zzYjS zzYjS2 = new zzYjS();
        zzXTI zzXTI3 = zzXTI2;
        zzYjS zzYjS3 = zzYjS2;
        FileFormatInfo fileFormatInfo = zzYjS2.zzYQ4(zzXTI3, null);
        switch (fileFormatInfo.getLoadFormat()) {
            case 10: 
            case 11: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 60: 
            case 61: {
                Document document = new Document(zzXTI2, null, false);
                return document.getDigitalSignatures();
            }
        }
        throw new IllegalStateException(zzWab);
    }

    public static DigitalSignatureCollection loadSignatures(InputStream stream) throws Exception {
        return DigitalSignatureUtil.zzY3r(zzXTI.zzYQ4(stream));
    }

    static zzZfS zzW07(zzXgY zzXgY2, String string) throws Exception {
        zzX8W zzX8W2 = new zzX8W(zzXgY2);
        if (zzX8W2.zzqb()) {
            zzZfS zzZfS2 = zzX8W2.zzX4r(string);
            return zzZfS2;
        }
        throw new UnsupportedFileFormatException("Unknown file format.");
    }

    static String zzZQN(int n) {
        switch (n) {
            case 3: {
                return "http://www.w3.org/2001/04/xmlenc#sha256";
            }
        }
        return "http://www.w3.org/2000/09/xmldsig#sha1";
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, DigitalSignature digitalSignature, boolean bl) throws Exception {
        zzX2c zzX2c2 = new zzX2c(zzXTI2);
        zzY8q zzY8q2 = bl ? new zzXu1(zzX2c2) : new zzWji(zzX2c2);
        zzY8q2.zzYQ4(digitalSignature);
        zzXTI3.zzad(0L);
        zzX2c2.zzyp(zzXTI3);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, DigitalSignature digitalSignature) throws Exception {
        zzZWh zzZWh2 = new zzZWh(zzXTI2);
        zzZWo zzZWo2 = new zzZWo(zzZWh2);
        zzZWo2.zzYQ4(digitalSignature);
        zzXTI3.zzad(0L);
        String string = "application/vnd.oasis.opendocument.text";
        zzXTI zzXTI4 = zzXTI3;
        zzZWh zzZWh3 = zzZWh2;
        zzZWh3.zzW07(zzXTI4, string, null);
    }

    private static void zzW07(zzXgY zzXgY2, zzXTI zzXTI2, DigitalSignature digitalSignature, String string) throws Exception {
        zzZfS zzZfS2 = DigitalSignatureUtil.zzW07(zzXgY2, string);
        zzZfS zzZfS3 = new zzZfS();
        DigitalSignatureUtil.zzW07((zzXTI)zzZfS2, (zzXTI)zzZfS3, digitalSignature, false);
        zzXgY zzXgY3 = zzX8W.zzYpS(zzZfS3, string);
        zzXgY3.zzyp(zzXTI2);
    }

    private static DigitalSignatureCollection zzXKO(zzXTI zzXTI2) throws Exception {
        zzXTI2.zzYwY(0L);
        zzX2c zzX2c2 = new zzX2c(zzXTI2);
        DigitalSignatureCollection digitalSignatureCollection = new DigitalSignatureCollection();
        zz3K zz3K2 = zzX2c2.zzW07(null, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (zz3K2 != null) {
            for (zzWa9 zzWa92 : zz3K2.zzYwz()) {
                String string = zz3K2.zzW07(zzWa92);
                zz3K zz3K3 = zzX2c2.zzW7p(string);
                zz3K zz3K4 = zzX2c2.zzW07(zz3K3, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
                zzWX5 zzWX52 = zzXb.zzKA(zz3K4.zzXzL().zzSI());
                zzNY.zzW07(zz3K3.zzW04(), zzWX52, new zzWE3(zzX2c2), digitalSignatureCollection, null);
            }
        }
        return digitalSignatureCollection;
    }

    private static void zzW07(DigitalSignature digitalSignature, SignOptions signOptions) {
        byte[] byArray = zzX4b.zzVQ3();
        if (byArray == zzXDw.zzWvR) {
            return;
        }
        if (byArray == zzXDw.zzAD && zzX4b.zzW5g(30)) {
            return;
        }
        Object t = null;
        Ref<Object> ref = new Ref<Object>(t);
        boolean bl = signOptions != null && zzW3k.zzW07(signOptions.zzYZ4(), ref) == 2;
        ref.get();
        if (bl) {
            return;
        }
        String string = digitalSignature.getComments();
        if (!zzWoj.zzXxP(string, "")) {
            string = zzWoj.zziW(string, zz98.zzAo().zzXm6(new byte[]{10, 13}));
        }
        int[] nArray = new int[]{43, 25, 5, 9, 91, 21, 12, 29, 1, 1, 68, 42, 64, 24, 1, 90, 78, 44, 22, 0, 79, 0, 29, 16, 78, 24, 13, 17, 70, 84, 57, 7, 30, 0, 23, 0, 0, 35, 23, 6, 10, 28, 74, 69, 109, 27, 8, 13, 28, 6, 3, 13, 90, 84, 74, 68, 94, 92, 73, 87, 30, 70, 77, 84, 47, 28, 20, 10, 93, 17, 88, 36, 26, 22, 68, 41, 90, 16, 86, 41};
        string = zzWoj.zziW(string, zzZmv.zzYlB(nArray));
        digitalSignature.setComments(string);
    }
}

