/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.MergerContext;
import com.aspose.words.Processor;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzZTE;
import com.aspose.words.zzWGu;
import com.aspose.words.zzX51;
import com.aspose.words.zzZmv;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Merger
extends Processor {
    private MergerContext zzWfR;

    private Merger(MergerContext context) {
        super(context);
        this.zzWfR = context;
    }

    public static Merger create() {
        return Merger.create(new MergerContext());
    }

    public static Merger create(MergerContext context) {
        return new Merger(context);
    }

    @Override
    protected void executeCore() throws Exception {
        Document[] documentArray = new Document[this.zzY7b().size()];
        for (int i = 0; i < this.zzY7b().size(); ++i) {
            documentArray[i] = this.zzY7b().get(i).zzZD7();
        }
        this.mResultDocument = Merger.zzW07(documentArray, this.zzWfR.getMergeFormatMode());
        super.executeCore();
    }

    public static void merge(String outputFile, String[] inputFiles) throws Exception {
        Merger.merge(outputFile, inputFiles, FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(outputFile)), 1);
    }

    public static void merge(String outputFile, String[] inputFiles, int saveFormat, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, zzZmv.zzyp(saveFormat, outputFile), mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.merge(outputFile, inputFiles, null, saveOptions, mergeFormatMode);
    }

    public static void merge(String outputFile, String[] inputFiles, LoadOptions[] loadOptions, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        if (loadOptions != null && inputFiles.length != loadOptions.length) {
            throw new IllegalArgumentException("Arrays of input files and load options must be of the same dimension.");
        }
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(mergeFormatMode);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < inputFiles.length; ++i) {
            merger.from(inputFiles[i], loadOptions != null ? loadOptions[i] : null);
        }
        merger.to(outputFile, saveOptions).execute();
    }

    public static Document merge(String[] inputFiles, int mergeFormatMode) throws Exception {
        return Merger.merge(inputFiles, null, mergeFormatMode);
    }

    public static Document merge(String[] inputFiles, LoadOptions[] loadOptions, int mergeFormatMode) throws Exception {
        if (loadOptions != null && inputFiles.length != loadOptions.length) {
            throw new IllegalArgumentException("Arrays of input files and load options must be of the same dimension.");
        }
        Document[] documentArray = new Document[inputFiles.length];
        for (int i = 0; i < inputFiles.length; ++i) {
            documentArray[i] = new Document(inputFiles[i], loadOptions != null ? loadOptions[i] : null);
        }
        return Merger.zzW07(documentArray, mergeFormatMode);
    }

    public static Document merge(Document[] inputDocuments, int mergeFormatMode) throws Exception {
        return Merger.zzW07(inputDocuments, mergeFormatMode);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI[] zzXTIArray, int n) throws Exception {
        Merger.zzW07(zzXTI2, zzXTIArray, zzZmv.zzyp(n, null), 1);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, int saveFormat) throws Exception {
        Merger.zzW07(zzXTI.zzYIm(outputStream), zzXTI.zzW07(inputStreams), saveFormat);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI[] zzXTIArray, SaveOptions saveOptions, int n) throws Exception {
        Merger.zzW07(zzXTI2, zzXTIArray, null, saveOptions, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.zzW07(zzXTI.zzYIm(outputStream), zzXTI.zzW07(inputStreams), saveOptions, mergeFormatMode);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI[] zzXTIArray, LoadOptions[] loadOptionsArray, SaveOptions saveOptions, int n) throws Exception {
        Merger.zzYQ4(zzXTI2, zzXTIArray, loadOptionsArray, saveOptions, n);
    }

    public static void merge(OutputStream outputStream, InputStream[] inputStreams, LoadOptions[] loadOptions, SaveOptions saveOptions, int mergeFormatMode) throws Exception {
        Merger.zzW07(zzXTI.zzYIm(outputStream), zzXTI.zzW07(inputStreams), loadOptions, saveOptions, mergeFormatMode);
    }

    private static Document zzW07(zzXTI[] zzXTIArray, int n) throws Exception {
        int n2 = n;
        LoadOptions[] loadOptionsArray = null;
        zzXTI[] zzXTIArray2 = zzXTIArray;
        return Merger.zzW07(zzXTIArray, loadOptionsArray, n2);
    }

    public static Document merge(InputStream[] inputStreams, int mergeFormatMode) throws Exception {
        return Merger.zzW07(zzXTI.zzW07(inputStreams), mergeFormatMode);
    }

    public static Document merge(InputStream[] inputStreams, LoadOptions[] loadOptions, int mergeFormatMode) throws Exception {
        int n = mergeFormatMode;
        LoadOptions[] loadOptionsArray = loadOptions;
        zzXTI[] zzXTIArray = zzXTI.zzW07(inputStreams);
        return Merger.zzW07(zzXTIArray, loadOptionsArray, n);
    }

    private static zzXTI[] zzW07(String[] stringArray, ImageSaveOptions imageSaveOptions, int n) throws Exception {
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < stringArray.length; ++i) {
            merger.from(stringArray[i]);
        }
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        merger.to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzXTI[] zzXTIArray = new zzXTI[]{};
        ArrayList<zzXTI> arrayList2 = arrayList;
        return arrayList2.toArray(zzXTIArray);
    }

    public static InputStream[] mergeToImages(String[] inputFiles, ImageSaveOptions saveOptions, int mergeFormatMode) throws Exception {
        return zzXTI.zzW07(Merger.zzW07(inputFiles, saveOptions, mergeFormatMode));
    }

    private static zzXTI[] zzW07(zzXTI[] zzXTIArray, ImageSaveOptions imageSaveOptions, int n) throws Exception {
        Object object;
        zzXTI[] zzXTIArray2;
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < zzXTIArray.length; ++i) {
            zzXTIArray2 = zzXTIArray[i];
            object = merger;
            ((Processor)object).zzYIm((zzXTI)zzXTIArray2, null);
        }
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        merger.to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzXTIArray2 = new zzXTI[]{};
        object = arrayList;
        return ((ArrayList)object).toArray(zzXTIArray2);
    }

    public static InputStream[] mergeToImages(InputStream[] inputStreams, ImageSaveOptions saveOptions, int mergeFormatMode) throws Exception {
        return zzXTI.zzW07(Merger.zzW07(zzXTI.zzW07(inputStreams), saveOptions, mergeFormatMode));
    }

    private static Document zzW07(Document[] documentArray, int n) throws Exception {
        if (documentArray == null || documentArray.length == 0) {
            return null;
        }
        Document document = documentArray[0].deepClone();
        for (int i = 1; i < documentArray.length; ++i) {
            if (n == 2) {
                Document[] documentArray2 = new Document[]{documentArray[i]};
                Document document2 = document;
                zzWGu.zzW07(document2, documentArray2);
                continue;
            }
            document.appendDocument(documentArray[i], Merger.zzZz3(n));
        }
        return document;
    }

    private static void zzYQ4(zzXTI zzXTI2, zzXTI[] zzXTIArray, LoadOptions[] loadOptionsArray, SaveOptions saveOptions, int n) throws Exception {
        if (loadOptionsArray != null && zzXTIArray.length != loadOptionsArray.length) {
            throw new IllegalArgumentException("Arrays of input streams and load options must be of the same dimension.");
        }
        MergerContext mergerContext = new MergerContext();
        mergerContext.setMergeFormatMode(n);
        Merger merger = Merger.create(mergerContext);
        for (int i = 0; i < zzXTIArray.length; ++i) {
            merger.zzYIm(zzXTIArray[i], loadOptionsArray != null ? loadOptionsArray[i] : null);
        }
        merger.zzYQ4(zzXTI2, saveOptions).execute();
    }

    private static Document zzW07(zzXTI[] zzXTIArray, LoadOptions[] loadOptionsArray, int n) throws Exception {
        if (loadOptionsArray != null && zzXTIArray.length != loadOptionsArray.length) {
            throw new IllegalArgumentException("Arrays of input streams and load options must be of the same dimension.");
        }
        Document[] documentArray = new Document[zzXTIArray.length];
        for (int i = 0; i < zzXTIArray.length; ++i) {
            zzX51 zzX512 = new zzX51(zzXTIArray[i], loadOptionsArray != null ? loadOptionsArray[i] : null, null);
            documentArray[i] = zzX512.zzZD7();
        }
        return Merger.zzW07(documentArray, n);
    }

    private static int zzZz3(int n) {
        switch (n) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 1;
    }
}

