/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.GlossaryDocument;
import com.aspose.words.Range;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzLu;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzWoj;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzVQP;
import com.aspose.words.zzWg5;
import com.aspose.words.zzYpQ;
import com.aspose.words.zzZfU;
import com.aspose.words.zzZmv;
import com.aspose.words.zzZmy;
import java.util.HashMap;

public abstract class Node
implements Cloneable {
    private Node zzWdB;
    private Node zzYxv;
    private Node zzYAA;
    private int zzW0z;

    protected Node() {
    }

    protected Node(DocumentBase doc) {
        this();
        this.zzYIm(doc);
    }

    public abstract int getNodeType();

    public CompositeNode getParentNode() {
        if (this.zzWdB == null) {
            return null;
        }
        if (this.zzWdB.getNodeType() == 38) {
            return null;
        }
        return (CompositeNode)this.zzWdB;
    }

    final CompositeNode zzYJ3() {
        if (zzZmv.zzw4(this.getParentNode())) {
            return this.getParentNode().zzYJ3();
        }
        return this.getParentNode();
    }

    final CompositeNode zzW2P() {
        if (zzZmv.zzw4(this.getParentNode()) || zzZmv.zzZH4(this.getParentNode())) {
            return this.getParentNode().zzW2P();
        }
        return this.getParentNode();
    }

    public DocumentBase getDocument() {
        if (this.zzWdB != null) {
            return this.zzWdB.getDocument();
        }
        return null;
    }

    final Document zzWff() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        throw new IllegalStateException("This operation requires the node to be inside the main document.");
    }

    final Document zzXQW() {
        DocumentBase documentBase = this.getDocument();
        if (documentBase instanceof Document) {
            return (Document)documentBase;
        }
        return ((GlossaryDocument)documentBase).zzXkV();
    }

    public Node getPreviousSibling() {
        Node node = this;
        return node.zzYAA;
    }

    final Node zzXza() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getPreviousSibling()) != null && zzZmv.zznj((node = node2).getNodeType())) {
        }
        return node2;
    }

    final Node zzXxR() {
        Node node = zzZmv.zzZKJ(this.getPreviousSibling(), false);
        if (node == null && zzZmv.zzw4(this.getParentNode())) {
            node = this.getParentNode().zzXxR();
        }
        return node;
    }

    final Node zzbG() {
        Node node = zzZmv.zzYET(this.getNextSibling(), false);
        if (node == null && zzZmv.zzw4(this.getParentNode())) {
            node = this.getParentNode().zzbG();
        }
        return node;
    }

    final CompositeNode zzRJ() {
        Node node = this;
        while ((node = node.zzXxR()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    final CompositeNode zzYM5() {
        Node node = this;
        while ((node = node.zzbG()) != null && !node.isComposite()) {
        }
        return (CompositeNode)node;
    }

    public Node getNextSibling() {
        Node node = this;
        return node.zzYxv;
    }

    final Node zzZpT() {
        Node node;
        Node node2 = this;
        while ((node2 = node2.getNextSibling()) != null && zzZmv.zznj((node = node2).getNodeType())) {
        }
        return node2;
    }

    public boolean isComposite() {
        return false;
    }

    public Range getRange() {
        return new Range(this);
    }

    final boolean zzWf4() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getLastChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzYX7() {
        block3: {
            block2: {
                if (this.getParentNode() == null) break block2;
                Node node = this;
                if (node != node.getParentNode().getFirstChild()) break block3;
            }
            return true;
        }
        return false;
    }

    final boolean zzp1() {
        for (Node node = this.getPreviousSibling(); node != null; node = node.getPreviousSibling()) {
            if (zzZmv.zzVV2(node)) continue;
            return false;
        }
        return true;
    }

    final boolean zzYHj() {
        for (Node node = this.getNextSibling(); node != null; node = node.getNextSibling()) {
            if (zzZmv.zzVV2(node)) continue;
            return false;
        }
        return true;
    }

    final Node zzZQ1() {
        return this.zzYxv;
    }

    final void zzXw(Node node) {
        this.zzYxv = node;
    }

    final Node zzYtQ() {
        return this.zzYAA;
    }

    final void zzE4(Node node) {
        this.zzYAA = node;
    }

    final Node zz11() {
        Node node = this;
        if (node.zzYxv != null) {
            node = this;
            return node.zzYxv;
        }
        return this.getParentNode();
    }

    final int zzYBc() {
        int n;
        switch (this.getNodeType()) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
            case 3: 
            case 4: {
                return 2;
            }
        }
        boolean bl = zzZmv.zzyL(this);
        boolean bl2 = zzZmv.zzYdk(this);
        boolean bl3 = zzZmv.zzXjr(this);
        boolean bl4 = zzZmv.zzWZD(this);
        CompositeNode compositeNode = this.getParentNode();
        int n2 = compositeNode != null && compositeNode.getNodeType() == 28 ? this.getParentNode().zzYBc() : 7;
        int n3 = n = compositeNode != null ? compositeNode.getNodeType() : 38;
        if (bl4 && (!bl && !bl2 && !bl3 || n2 == 4 || n == 5)) {
            return 4;
        }
        if (bl3 && (!bl && !bl2 || n2 == 5 || n == 6)) {
            return 5;
        }
        if (bl2 && (!bl || n2 == 3 || compositeNode != null && compositeNode.zzYBc() != 3 && n2 != 6 && n != 27 && n != 35)) {
            return 3;
        }
        if (bl) {
            return 6;
        }
        return 7;
    }

    public Node deepClone(boolean isCloneChildren) {
        return this.zzW07(isCloneChildren, new zzW07(this));
    }

    Node zzW07(boolean bl, zzZmy zzZmy2) {
        Node node = (Node)this.memberwiseClone();
        if (this.zzWdB != null) {
            node.zzWdB = this.getDocument().zzYqx();
        }
        node.zzYxv = null;
        node.zzYAA = null;
        if (zzZmy2 != null) {
            zzZmy2.zzYpS(this, node);
        }
        return node;
    }

    public abstract boolean accept(DocumentVisitor var1) throws Exception;

    protected static boolean visitorActionToBool(int action) {
        switch (action) {
            case 0: 
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
        }
        throw new IllegalStateException("Unknown visitor action.");
    }

    public String getText() {
        return "";
    }

    void zzWss(StringBuilder stringBuilder) {
        zzVUI.zzYQ4(stringBuilder, this.getText());
    }

    public CompositeNode getAncestor(Class ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (!ancestorType.isInstance(compositeNode)) continue;
            return compositeNode;
        }
        return null;
    }

    final zzWg5 zzkE() {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            zzWg5 zzWg52 = zzVUI.zzW07((Object)compositeNode, zzWg5.class);
            if (zzWg52 == null) continue;
            return zzWg52;
        }
        return null;
    }

    public CompositeNode getAncestor(int ancestorType) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() != ancestorType) continue;
            return compositeNode;
        }
        return null;
    }

    public void remove() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("Cannot remove because there is no parent.");
        }
        this.getParentNode().removeChild(this);
    }

    final void zzZmS(Node node) {
        this.zzWdB = node != null ? node : this.getDocument().zzYqx();
    }

    final void zzYIm(DocumentBase documentBase) {
        this.zzWdB = documentBase != null ? documentBase.zzYqx() : null;
    }

    final boolean zzXNL(Node node) {
        if (node == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: node");
        }
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null && compositeNode != this; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode != node) continue;
            return true;
        }
        return false;
    }

    final Node zzWXs() {
        if (this.getParentNode() == null) {
            return this.getDocument();
        }
        Node node = this;
        while (node.getParentNode() != null) {
            node = node.getParentNode();
        }
        return node;
    }

    int getTextLength() {
        return this.getText().length();
    }

    public Node nextPreOrder(Node rootNode) {
        Node node = this.isComposite() ? ((CompositeNode)this).getFirstChild() : null;
        if (node == null) {
            for (node = this; node != null && node != rootNode && node.getNextSibling() == null; node = node.getParentNode()) {
            }
            if (node != null && node != rootNode) {
                node = node.getNextSibling();
            }
        }
        if (node == rootNode) {
            node = null;
        }
        return node;
    }

    public Node previousPreOrder(Node rootNode) {
        Node node;
        Node node2 = this.getPreviousSibling();
        while (node2 != null && (node = node2.isComposite() ? ((CompositeNode)node2).getLastChild() : null) != null) {
            node2 = node;
        }
        if (node2 == null) {
            node2 = this.getParentNode();
        }
        if (node2 == rootNode) {
            node2 = null;
        }
        return node2;
    }

    final Node zzWmD(int n) {
        Node node;
        for (node = this.getNextSibling(); node != null && n != node.getNodeType(); node = node.getNextSibling()) {
        }
        return node;
    }

    final Node zzWh3(int n) {
        Node node;
        for (node = this.getPreviousSibling(); node != null && n != node.getNodeType(); node = node.getPreviousSibling()) {
        }
        return node;
    }

    final Node zzWyk(Node node, int n) {
        for (Node node2 = this.nextPreOrder(node); node2 != null; node2 = node2.nextPreOrder(node)) {
            if (node2.getNodeType() != 8) continue;
            return node2;
        }
        return null;
    }

    final Node zzXor(Node node, int n) {
        Node node2;
        for (node2 = this.previousPreOrder(node); node2 != null && node2.getNodeType() != n; node2 = node2.previousPreOrder(node)) {
        }
        return node2;
    }

    final Node zzWTp(boolean bl) {
        if (bl) {
            return this.getNextSibling();
        }
        return this.getPreviousSibling();
    }

    final Node zzYUr(Node node) {
        return this.getParentNode().insertAfter(node, this);
    }

    final void zzZ1M(Node node, Node node2) {
        this.getParentNode().zzYQ4(node, node2, this);
    }

    final Node zzY6z(Node node) {
        return this.getParentNode().insertBefore(node, this);
    }

    final void zzYQZ(Node node, Node node2) {
        this.getParentNode().zzW07(node, node2, this);
    }

    public String toString(int saveFormat) throws Exception {
        zzZfU zzZfU2 = zzZmv.zzXs9(saveFormat);
        return zzZfU2.zzX1P(this);
    }

    public String toString(SaveOptions saveOptions) throws Exception {
        zzZfU zzZfU2 = zzZmv.zzYQ4(saveOptions);
        return zzZfU2.zzX1P(this);
    }

    final Node zzVZE(int n) {
        for (CompositeNode compositeNode = this.getParentNode(); compositeNode != null; compositeNode = compositeNode.getParentNode()) {
            if (compositeNode.getNodeType() == n) {
                return compositeNode;
            }
            if (!zzZmv.zzyW(compositeNode)) continue;
            if (n != 0) break;
            return compositeNode;
        }
        return null;
    }

    final zzYpQ zzYao() {
        Node node = this.getPreviousSibling();
        if (node != null) {
            return zzYpQ.zzXIh(node);
        }
        return zzYpQ.zzQI(this.getParentNode());
    }

    final zzYpQ zzWSk() {
        Node node = this.getNextSibling();
        if (node != null) {
            return zzYpQ.zzQI(node);
        }
        return zzYpQ.zzXIh(this.getParentNode());
    }

    final boolean zzyG(Node node) {
        return Node.zzQI(this, node);
    }

    final boolean zzX6w() {
        return this.getAncestor(1) == null;
    }

    static Node zzY8h(Node node, Node node2) {
        if (node == node2) {
            return node;
        }
        if (node == null || node2 == null) {
            return null;
        }
        zzLu<Node> zzLu2 = Node.zzJW(node);
        zzLu<Node> zzLu3 = Node.zzJW(node2);
        return Node.zzW07(zzLu2, zzLu3);
    }

    static boolean zzQI(Node node, Node node2) {
        zzLu<Node> zzLu2;
        if (node == null || node2 == null) {
            return false;
        }
        zzLu<Node> zzLu3 = Node.zzJW(node);
        Node node3 = Node.zzW07(zzLu3, zzLu2 = Node.zzJW(node2));
        if (node3 == null) {
            return false;
        }
        zzLu<Node> zzLu4 = zzLu3;
        if (zzLu4.size() == 0 || (zzLu4 = zzLu2).size() == 0) {
            zzLu4 = zzLu2;
            boolean bl = zzLu4.size() > 0;
            return bl;
        }
        Object e = zzLu3.peek();
        Object e2 = zzLu2.peek();
        for (Node node4 : ((CompositeNode)node3).getChildNodes(0, false)) {
            if (node4 == e) {
                return true;
            }
            if (node4 != e2) continue;
            return false;
        }
        return false;
    }

    private static zzLu<Node> zzJW(Node node) {
        zzLu<Node> zzLu2 = new zzLu<Node>();
        for (Node node2 = node; node2 != null; node2 = node2.getParentNode()) {
            zzLu2.push(node2);
        }
        return zzLu2;
    }

    private static Node zzW07(zzLu<Node> zzLu2, zzLu<Node> zzLu3) {
        Node node = null;
        while (zzLu2.peek() == zzLu3.peek()) {
            node = (Node)zzLu2.pop();
            zzLu3.pop();
            zzLu<Node> zzLu4 = zzLu2;
            if (zzLu4.size() != 0 && (zzLu4 = zzLu3).size() != 0) continue;
        }
        return node;
    }

    public static String nodeTypeToString(int nodeType) {
        switch (nodeType) {
            case 0: {
                return "Any";
            }
            case 1: {
                return "Document";
            }
            case 2: {
                return "Section";
            }
            case 3: {
                return "Body";
            }
            case 4: {
                return "HeaderFooter";
            }
            case 5: {
                return "Table";
            }
            case 6: {
                return "Row";
            }
            case 7: {
                return "Cell";
            }
            case 8: {
                return "Paragraph";
            }
            case 9: {
                return "BookmarkStart";
            }
            case 10: {
                return "BookmarkEnd";
            }
            case 17: {
                return "GroupShape";
            }
            case 18: {
                return "Shape";
            }
            case 19: {
                return "Comment";
            }
            case 20: {
                return "Footnote";
            }
            case 21: {
                return "Run";
            }
            case 22: {
                return "FieldStart";
            }
            case 23: {
                return "FieldSeparator";
            }
            case 24: {
                return "FieldEnd";
            }
            case 25: {
                return "FormField";
            }
            case 26: {
                return "SpecialChar";
            }
            case 27: {
                return "SmartTag";
            }
            case 28: {
                return "StructuredDocumentTag";
            }
            case 29: {
                return "StructuredDocumentTagRangeStart";
            }
            case 30: {
                return "StructuredDocumentTagRangeEnd";
            }
            case 31: {
                return "GlossaryDocument";
            }
            case 32: {
                return "BuildingBlock";
            }
            case 33: {
                return "CommentRangeStart";
            }
            case 34: {
                return "CommentRangeEnd";
            }
            case 13: {
                return "MoveFromRangeStart";
            }
            case 14: {
                return "MoveFromRangeEnd";
            }
            case 15: {
                return "MoveToRangeStart";
            }
            case 16: {
                return "MoveToRangeEnd";
            }
            case 11: {
                return "EditableRangeStart";
            }
            case 12: {
                return "EditableRangeEnd";
            }
            case 35: {
                return "OfficeMath";
            }
            case 36: {
                return "SubDocument";
            }
            case 37: {
                return "System";
            }
            case 38: {
                return "Null";
            }
        }
        return "Unknown node type.";
    }

    public int getCustomNodeId() {
        return this.zzW0z;
    }

    public void setCustomNodeId(int value) {
        this.zzW0z = value;
    }

    private String zzX7f() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Node node = this; node != null && node.getParentNode() != null; node = node.getParentNode()) {
            int n = 0;
            for (Node node2 = node.getParentNode().getFirstChild(); node2 != null && node2 != node; node2 = node2.getNextSibling()) {
                ++n;
            }
            zzVUI.zzW07(stringBuilder, "{0}{1}", node == this ? "" : ".", n);
        }
        return zzWoj.zzFy(stringBuilder.toString());
    }

    public String toString() {
        return zzWoj.zzFy(zzWoj.zzYQ4("{0} {1}", new Object[]{Node.nodeTypeToString(this.getNodeType()), this.zzX7f()}));
    }

    final Node zzYSt(int ... nArray) {
        Node node;
        for (node = this.getNextSibling(); node != null && !node.zzVQ5(nArray); node = node.getNextSibling()) {
        }
        return node;
    }

    private boolean zzVQ5(int ... nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = nArray2[i];
            if (this.getNodeType() != n2) continue;
            return true;
        }
        return false;
    }

    protected Object memberwiseClone() {
        try {
            return this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new IllegalStateException(cloneNotSupportedException);
        }
    }

    static final class zzW07
    implements zzZmy {
        private Node zzYKa;
        private HashMap<Integer, Integer> zzX5A;

        zzW07(Node node) {
            this.zzYKa = node;
        }

        @Override
        public final void zzYpS(Node node, Node node2) {
            if (node == this.zzYKa) {
                return;
            }
            if (node2.getNodeType() != 19 && node2.getNodeType() != 33 && node2.getNodeType() != 34) {
                return;
            }
            zzVQP zzVQP2 = (zzVQP)((Object)node2);
            if (this.zzX5A == null) {
                this.zzX5A = new HashMap();
            }
            RefInt refInt = new RefInt(0);
            boolean bl = !zzVUI.zzW07(this.zzX5A, Integer.valueOf(zzVQP2.getIdInternal()), refInt);
            int n = refInt.get();
            if (bl) {
                n = node2.getDocument().zzWJC();
                zzVUI.zzYQ4(this.zzX5A, Integer.valueOf(zzVQP2.getIdInternal()), Integer.valueOf(n));
            }
            zzVQP2.setIdInternal(n);
            RefInt refInt2 = new RefInt(0);
            boolean bl2 = zzVUI.zzW07(this.zzX5A, Integer.valueOf(zzVQP2.getParentIdInternal()), refInt2);
            int n2 = refInt2.get();
            if (bl2) {
                zzVQP2.setParentIdInternal(n2);
            }
        }
    }
}

