/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.Node;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.internal.zzZlO;
import com.aspose.words.zz3;
import com.aspose.words.zz73;
import com.aspose.words.zzYCZ;
import com.aspose.words.zzYbG;
import com.aspose.words.zzZmv;
import java.util.ArrayList;
import java.util.Iterator;

public class NodeCollection<T extends Node>
implements zzYCZ,
Iterable<T> {
    private Node zzX3H;
    private CompositeNode zzXYm;
    private DocumentBase zzYtW;
    private boolean zzWQZ;
    private int zzWra;
    private int zzXUD;
    private Node zzYtG;
    private int zzZwu;
    private zz73 zzYMd;

    NodeCollection(CompositeNode container, int nodeType, boolean isDeep) {
        this(container, zz3.zzYDN(nodeType), isDeep);
    }

    NodeCollection(CompositeNode container, int[] nodeTypes, boolean isDeep) {
        this(container, new zz3(nodeTypes), isDeep);
    }

    NodeCollection(CompositeNode container, zz73 matcher, boolean isDeep) {
        if (container == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: container");
        }
        if (matcher == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: matcher");
        }
        this.zzXYm = container;
        this.zzYtW = container.getDocument();
        this.zzYMd = matcher;
        this.zzWQZ = isDeep;
        this.zzW26();
    }

    public Node get(int index) {
        try {
            this.zzX8B();
            if (index < 0 && (index = this.getCount() + index) < 0) {
                return null;
            }
            if (this.zzXUD == index) {
                return this.zzYtG;
            }
            int n = index - this.zzXUD;
            NodeCollection nodeCollection = this;
            Node node = nodeCollection.zzXyq(nodeCollection.zzYtG, n);
            if (node != null) {
                this.zzXUD = index;
                this.zzYtG = node;
            }
            return node;
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public void add(Node node) {
        if (this.zzWQZ) {
            throw new UnsupportedOperationException("Adding nodes is not yet supported for deep node collections.");
        }
        this.zzXYm.appendChild(node);
    }

    public void insert(int index, Node node) {
        if (this.zzWQZ) {
            throw new UnsupportedOperationException("Inserting nodes is not yet supported for deep node collections.");
        }
        this.zzXYm.insertBefore(node, this.get(index));
    }

    public void remove(Node node) {
        node.remove();
    }

    public void removeAt(int index) {
        this.get(index).remove();
    }

    public void clear() {
        for (Node node : this) {
            node.remove();
        }
    }

    public boolean contains(Node node) {
        return this.indexOf(node) != -1;
    }

    public int indexOf(Node node) {
        int n = 0;
        for (Node node2 : this) {
            if (node == node2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public Node[] toArray() {
        Node[] nodeArray = new Node[]{};
        ArrayList arrayList = this.zzXS8();
        return arrayList.toArray(nodeArray);
    }

    @Override
    public Iterator<T> iterator() {
        return new zzYbG(this);
    }

    final <TNode extends Node> zzYbG<TNode> zzWGC() {
        return new zzYbG(this);
    }

    final ArrayList<Node> zzWde() {
        return this.zzXS8();
    }

    final <TValue extends Node> ArrayList<TValue> zzXS8() {
        ArrayList arrayList = new ArrayList();
        for (Node node : this) {
            zzZlO.zzW07(arrayList, node);
        }
        return arrayList;
    }

    private Node zzXyq(Node node, int n) throws Exception {
        boolean bl;
        boolean bl2 = bl = n > 0;
        if (n < 0) {
            n = -n;
        }
        Node node2 = node;
        for (int i = 0; i < n; ++i) {
            if ((node2 = this.zze(node2, bl)) != null) continue;
            return null;
        }
        return node2;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) throws Exception {
        return this.zzXIh(curNode, true);
    }

    private Node zzXIh(Node node, boolean bl) throws Exception {
        Node node2;
        this.zzX3H = node;
        do {
            boolean bl2;
            node2 = this.zzX3H;
            boolean bl3 = bl2 = zzZmv.zzXhQ(this.zzXYm.getNodeType()) && this.zzYMd.zzZMK();
            Node node3 = this.zzWQZ ? this.zzW07(true, this.zzX3H) : (this.zzX3H = bl2 ? this.zzYIm(true, this.zzX3H) : this.zzYQ4(true, this.zzX3H));
        } while (this.zzX3H != null && !this.zzYMd.zzW07(this.zzX3H));
        return node2;
    }

    private Node zze(Node node, boolean bl) throws Exception {
        while ((this.zzWQZ ? this.zzW07(bl, node) : (node = this.zzYMd.zzZMK() ? this.zzYIm(bl, node) : this.zzYQ4(bl, node))) != null && !this.zzYMd.zzW07(node)) {
        }
        return node;
    }

    private Node zzW07(boolean bl, Node node) {
        if (bl) {
            return node.nextPreOrder(this.zzXYm);
        }
        return node.previousPreOrder(this.zzXYm);
    }

    private Node zzYQ4(boolean bl, Node node) {
        if (bl) {
            if (node == this.zzXYm) {
                return this.zzXYm.getFirstChild();
            }
            return node.getNextSibling();
        }
        if (node == this.zzXYm) {
            return this.zzXYm.getLastChild();
        }
        return node.getPreviousSibling();
    }

    private Node zzYIm(boolean bl, Node node) {
        Node node2;
        if (bl) {
            node2 = node == this.zzXYm ? this.zzXYm.zzX4e() : node.zzbG();
        } else {
            Node node3 = node2 = node == this.zzXYm ? this.zzXYm.zzY7N() : node.zzXxR();
        }
        if (node2 == this.zzXYm.getNextSibling() || node2 == this.zzXYm.getPreviousSibling()) {
            node2 = null;
        }
        return node2;
    }

    private void zzX8B() {
        if (this.zzWra != this.zzZka()) {
            this.zzW26();
        }
    }

    private void zzW26() {
        this.zzWra = this.zzZka();
        this.zzXUD = -1;
        this.zzYtG = this.zzXYm;
        this.zzZwu = -1;
    }

    private int zzZka() {
        if (this.zzYtW != null) {
            return this.zzYtW.zzWBh();
        }
        return 0;
    }

    public int getCount() {
        this.zzX8B();
        if (this.zzZwu == -1) {
            this.zzZwu = zzYbG.zzW07(this);
        }
        return this.zzZwu;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzX3H;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this.zzXYm;
    }
}

