/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.LoadOptions;
import com.aspose.words.ProcessorContext;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzLu;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzZTE;
import com.aspose.words.internal.zzZlO;
import com.aspose.words.zzX51;
import com.aspose.words.zzY7S;
import com.aspose.words.zzZmv;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Processor {
    private static boolean zzW7M = false;
    protected Document mResultDocument;
    private ProcessorContext zzWK0;
    private zzX51 zzXwQ;
    private ArrayList<zzX51> zzZot = new ArrayList();
    private zzLu<zzY7S> zzWJ9 = new zzLu();
    private zzLu<zzY7S> zzZ8g = new zzLu();

    Processor(ProcessorContext context) {
        this.zzWK0 = context;
    }

    public Processor from(String input) {
        return this.from(input, null);
    }

    public Processor from(String input, LoadOptions loadOptions) {
        this.zzXwQ = new zzX51(input, this.zzYpS(loadOptions), this.zzWK0.getLayoutOptions());
        zzZlO.zzW07(this.zzZot, this.zzXwQ);
        return this;
    }

    final Processor zzoH(zzXTI zzXTI2) {
        return this.zzYIm(zzXTI2, null);
    }

    final Processor zzYIm(zzXTI zzXTI2, LoadOptions loadOptions) {
        this.zzXwQ = new zzX51(zzXTI2, this.zzYpS(loadOptions), this.zzWK0.getLayoutOptions());
        zzZlO.zzW07(this.zzZot, this.zzXwQ);
        return this;
    }

    public Processor from(InputStream input) {
        return this.zzYIm(zzXTI.zzYQ4(input), null);
    }

    public Processor from(InputStream input, LoadOptions loadOptions) {
        return this.zzYIm(zzXTI.zzYQ4(input), loadOptions);
    }

    public Processor to(String output) throws Exception {
        return this.to(output, null);
    }

    public Processor to(String output, SaveOptions saveOptions) throws Exception {
        if (saveOptions == null) {
            int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(output));
            saveOptions = zzZmv.zzyp(n, output);
        }
        this.zzW07(new zzY7S(output, saveOptions));
        return this;
    }

    public Processor to(String output, int saveFormat) throws Exception {
        SaveOptions saveOptions = zzZmv.zzyp(saveFormat, output);
        this.zzW07(new zzY7S(output, saveOptions));
        return this;
    }

    final Processor zzYQ4(zzXTI zzXTI2, SaveOptions saveOptions) {
        this.zzW07(new zzY7S(zzXTI2, saveOptions));
        return this;
    }

    public Processor to(OutputStream output, SaveOptions saveOptions) {
        return this.zzYQ4(zzXTI.zzYIm(output), saveOptions);
    }

    private Processor zzZKJ(zzXTI zzXTI2, int n) throws Exception {
        SaveOptions saveOptions = zzZmv.zzyp(n, null);
        this.zzW07(new zzY7S(zzXTI2, saveOptions));
        return this;
    }

    public Processor to(OutputStream output, int saveFormat) throws Exception {
        return this.zzZKJ(zzXTI.zzYIm(output), saveFormat);
    }

    public Processor toOutput(ArrayList<OutputStream> output, SaveOptions saveOptions) {
        return this.to(zzXTI.zzKA(output), saveOptions);
    }

    public Processor to(ArrayList<zzXTI> output, SaveOptions saveOptions) {
        this.zzW07(new zzY7S(output, saveOptions));
        return this;
    }

    public Processor toOutput(ArrayList<OutputStream> output, int saveFormat) throws Exception {
        return this.to(zzXTI.zzKA(output), saveFormat);
    }

    public Processor to(ArrayList<zzXTI> output, int saveFormat) throws Exception {
        SaveOptions saveOptions = zzZmv.zzyp(saveFormat, null);
        this.zzW07(new zzY7S(output, saveOptions));
        return this;
    }

    public void execute() throws Exception {
        this.checkArgumentsSet();
        this.executeCore();
    }

    protected void executeCore() throws Exception {
        zzLu<zzY7S> zzLu2 = this;
        zzLu2 = ((Processor)((Object)zzLu2)).zzZ8g;
        if (zzLu2.size() == 0) {
            zzLu2 = this;
            zzLu2 = ((Processor)((Object)zzLu2)).zzWJ9;
            if (zzLu2.size() == 0) {
                return;
            }
        }
        this.zzez();
        this.zzZNp();
    }

    protected void checkArgumentsSet() {
        zzLu<zzY7S> zzLu2 = this;
        if (((Processor)((Object)zzLu2)).zzZot.size() == 0) {
            throw new IllegalArgumentException("Input document is not specified.");
        }
        zzLu2 = this;
        zzLu2 = ((Processor)((Object)zzLu2)).zzZ8g;
        if (zzLu2.size() == 0) {
            zzLu2 = this;
            zzLu2 = ((Processor)((Object)zzLu2)).zzWJ9;
            if (zzLu2.size() == 0) {
                throw new IllegalArgumentException("Output document is not specified.");
            }
        }
    }

    private void zzez() throws Exception {
        if (this.mResultDocument == null) {
            throw new IllegalStateException("Result document is not initialized.");
        }
        while (true) {
            zzLu<zzY7S> zzLu2 = this;
            zzLu2 = ((Processor)((Object)zzLu2)).zzZ8g;
            if (zzLu2.size() <= 0) break;
            zzLu2 = this;
            zzY7S zzY7S2 = (zzY7S)((Processor)((Object)zzLu2)).zzZ8g.pop();
            zzY7S2.zzVQF(this.mResultDocument);
        }
    }

    private void zzZNp() throws Exception {
        if (this.mResultDocument == null) {
            throw new IllegalStateException("Result document is not initialized.");
        }
        if (this.mResultDocument.getOriginalLoadFormat() == 64) {
            this.mResultDocument.zzWHI();
        }
        while (true) {
            zzLu<zzY7S> zzLu2 = this;
            zzLu2 = ((Processor)((Object)zzLu2)).zzWJ9;
            if (zzLu2.size() <= 0) break;
            zzLu2 = this;
            zzY7S zzY7S2 = (zzY7S)((Processor)((Object)zzLu2)).zzWJ9.pop();
            zzY7S2.zzVQF(this.mResultDocument);
        }
    }

    private LoadOptions zzYpS(LoadOptions loadOptions) {
        if (this.zzWK0.getWarningCallback() != null || this.zzWK0.getFontSettings() != null) {
            if (loadOptions == null) {
                loadOptions = new LoadOptions();
            }
            if (loadOptions.getWarningCallback() == null) {
                loadOptions.setWarningCallback(this.zzWK0.getWarningCallback());
            }
            if (loadOptions.getFontSettings() == null) {
                loadOptions.setFontSettings(this.zzWK0.getFontSettings());
            }
        }
        return loadOptions;
    }

    private void zzW07(zzY7S zzY7S2) {
        if (FileFormatUtil.zzhT(zzY7S2.zzDL().getSaveFormat())) {
            this.zzWJ9.push(zzY7S2);
            return;
        }
        this.zzZ8g.push(zzY7S2);
    }

    protected static String getPartFileName(String fileName, int partIndex, int saveFormat) throws Exception {
        String string = zzZTE.zzVWa(fileName);
        String string2 = zzZTE.zzYJ7(fileName) + "_" + partIndex + FileFormatUtil.saveFormatToExtension(saveFormat);
        return zzZTE.zzXjr(string, string2);
    }

    final zzX51 zzWrJ() {
        return this.zzXwQ;
    }

    final ArrayList<zzX51> zzY7b() {
        return this.zzZot;
    }

    final zzLu<zzY7S> zzYZ2() {
        return this.zzWJ9;
    }

    final zzLu<zzY7S> zzWC4() {
        return this.zzZ8g;
    }
}

