/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBuilder;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.FindReplaceOptions;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.LoadOptions;
import com.aspose.words.Node;
import com.aspose.words.Processor;
import com.aspose.words.ReplacerContext;
import com.aspose.words.Run;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zz98;
import com.aspose.words.internal.zzWot;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzZTE;
import com.aspose.words.internal.zzZfS;
import com.aspose.words.internal.zzpV;
import com.aspose.words.zzZmv;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class Replacer
extends Processor {
    private ReplacerContext zzYle;

    private Replacer(ReplacerContext context) {
        super(context);
        this.zzYle = context;
    }

    public static Replacer create(ReplacerContext context) {
        return new Replacer(context);
    }

    @Override
    protected void executeCore() throws Exception {
        this.mResultDocument = this.zzWrJ().zzZD7();
        if (this.zzYle.zz44() != null) {
            this.zzYle.zzdZ(Replacer.zzW07(this.mResultDocument, this.zzYle.zz44(), this.zzYle.getReplacement(), this.zzYle.getFindReplaceOptions()));
        } else {
            this.zzYle.zzdZ(Replacer.zzW07(this.mResultDocument, this.zzYle.zzXc5(), this.zzYle.getReplacement(), this.zzYle.getFindReplaceOptions()));
        }
        super.executeCore();
    }

    @Override
    protected void checkArgumentsSet() {
        if (this.zzYle.zz44() == null && !zzpV.zzZY9(this.zzYle.zzXc5())) {
            throw new IllegalArgumentException("Search pattern is not specified. Specify search pattern and replacement using ReplacerContext.SetReplacement method.");
        }
        super.checkArgumentsSet();
    }

    public static int replace(String inputFileName, String outputFileName, String pattern, String replacement) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(outputFileName));
        return Replacer.replace(inputFileName, outputFileName, n, pattern, replacement);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, String pattern, String replacement) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, saveFormat, pattern, replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, zzZmv.zzyp(saveFormat, outputFileName), pattern, replacement, options);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return Replacer.replace(inputFileName, outputFileName, saveOptions, pattern, replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.setReplacement(pattern, replacement);
        if (options != null) {
            replacerContext.zzW07(options);
        }
        Replacer.create(replacerContext).from(inputFileName).to(outputFileName, saveOptions).execute();
        return replacerContext.zzXfG();
    }

    private static int zzW07(zzXTI zzXTI2, zzXTI zzXTI3, int n, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzW07(zzXTI2, zzXTI3, zzZmv.zzyp(n, null), string, string2, findReplaceOptions);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, String pattern, String replacement) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, pattern, replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, pattern, replacement, options);
    }

    private static int zzW07(zzXTI zzXTI2, zzXTI zzXTI3, SaveOptions saveOptions, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.setReplacement(string, string2);
        if (findReplaceOptions != null) {
            replacerContext.zzW07(findReplaceOptions);
        }
        Replacer.create(replacerContext).zzoH(zzXTI2).zzYQ4(zzXTI3, saveOptions).execute();
        return replacerContext.zzXfG();
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, pattern, replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, pattern, replacement, options);
    }

    private static int zzW07(String string, String string2, zzWot zzWot2, String string3) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(string2));
        return Replacer.zzW07(string, string2, n, zzWot2, string3);
    }

    public static int replace(String inputFileName, String outputFileName, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzW07(inputFileName, outputFileName, zzWot.zzW07(pattern), replacement);
    }

    private static int zzW07(String string, String string2, int n, zzWot zzWot2, String string3) throws Exception {
        return Replacer.zzW07(string, string2, n, zzWot2, string3, null);
    }

    private static int zzW07(String string, String string2, int n, zzWot zzWot2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzW07(string, string2, zzZmv.zzyp(n, string2), zzWot2, string3, findReplaceOptions);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzW07(inputFileName, outputFileName, saveFormat, zzWot.zzW07(pattern), replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, int saveFormat, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzW07(inputFileName, outputFileName, saveFormat, zzWot.zzW07(pattern), replacement, options);
    }

    private static int zzW07(String string, String string2, SaveOptions saveOptions, zzWot zzWot2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYQ4(zzWot2, string3);
        if (findReplaceOptions != null) {
            replacerContext.zzW07(findReplaceOptions);
        }
        Replacer.create(replacerContext).from(string).to(string2, saveOptions).execute();
        return replacerContext.zzXfG();
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzW07(inputFileName, outputFileName, saveOptions, zzWot.zzW07(pattern), replacement, null);
    }

    public static int replace(String inputFileName, String outputFileName, SaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzW07(inputFileName, outputFileName, saveOptions, zzWot.zzW07(pattern), replacement, options);
    }

    private static int zzW07(zzXTI zzXTI2, zzXTI zzXTI3, int n, zzWot zzWot2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzW07(zzXTI2, zzXTI3, zzZmv.zzyp(n, null), zzWot2, string, findReplaceOptions);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, zzWot.zzW07(pattern), replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, int saveFormat, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, zzWot.zzW07(pattern), replacement, options);
    }

    private static int zzW07(zzXTI zzXTI2, zzXTI zzXTI3, SaveOptions saveOptions, zzWot zzWot2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYQ4(zzWot2, string);
        if (findReplaceOptions != null) {
            replacerContext.zzW07(findReplaceOptions);
        }
        Replacer.create(replacerContext).zzoH(zzXTI2).zzYQ4(zzXTI3, saveOptions).execute();
        return replacerContext.zzXfG();
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, zzWot.zzW07(pattern), replacement, null);
    }

    public static int replace(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return Replacer.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, zzWot.zzW07(pattern), replacement, options);
    }

    private static zzXTI[] zzW07(String string, ImageSaveOptions imageSaveOptions, String string2, String string3, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzW07(string, imageSaveOptions, new zzWot(zzWot.zzWyG(string2)), string3, findReplaceOptions);
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(inputFileName, saveOptions, pattern, replacement, null));
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(inputFileName, saveOptions, pattern, replacement, options));
    }

    private static zzXTI[] zzW07(zzXTI zzXTI2, ImageSaveOptions imageSaveOptions, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        return Replacer.zzW07(zzXTI2, imageSaveOptions, new zzWot(zzWot.zzWyG(string)), string2, findReplaceOptions);
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, String pattern, String replacement) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(zzXTI.zzYQ4(inputStream), saveOptions, pattern, replacement, null));
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, String pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(zzXTI.zzYQ4(inputStream), saveOptions, pattern, replacement, options));
    }

    private static zzXTI[] zzW07(String string, ImageSaveOptions imageSaveOptions, zzWot zzWot2, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYQ4(zzWot2, string2);
        if (findReplaceOptions != null) {
            replacerContext.zzW07(findReplaceOptions);
        }
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        Replacer.create(replacerContext).from(string).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzXTI[] zzXTIArray = new zzXTI[]{};
        ArrayList<zzXTI> arrayList2 = arrayList;
        return arrayList2.toArray(zzXTIArray);
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(inputFileName, saveOptions, zzWot.zzW07(pattern), replacement, null));
    }

    public static OutputStream[] replaceToImages(String inputFileName, ImageSaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(inputFileName, saveOptions, zzWot.zzW07(pattern), replacement, options));
    }

    private static zzXTI[] zzW07(zzXTI zzXTI2, ImageSaveOptions imageSaveOptions, zzWot zzWot2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        ReplacerContext replacerContext = new ReplacerContext();
        replacerContext.zzYQ4(zzWot2, string);
        if (findReplaceOptions != null) {
            replacerContext.zzW07(findReplaceOptions);
        }
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        Replacer.create(replacerContext).zzoH(zzXTI2).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzXTI[] zzXTIArray = new zzXTI[]{};
        ArrayList<zzXTI> arrayList2 = arrayList;
        return arrayList2.toArray(zzXTIArray);
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, Pattern pattern, String replacement) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(zzXTI.zzYQ4(inputStream), saveOptions, zzWot.zzW07(pattern), replacement, null));
    }

    public static OutputStream[] replaceToImages(InputStream inputStream, ImageSaveOptions saveOptions, Pattern pattern, String replacement, FindReplaceOptions options) throws Exception {
        return zzXTI.zzYQ4(Replacer.zzW07(zzXTI.zzYQ4(inputStream), saveOptions, zzWot.zzW07(pattern), replacement, options));
    }

    private static int zzW07(Document document, String string, String string2, FindReplaceOptions findReplaceOptions) throws Exception {
        if (findReplaceOptions.getReplacementFormat() == 0) {
            return document.getRange().replace(string, string2, findReplaceOptions);
        }
        int n = document.getRange().replace(string, "[[WordizeTempPlaceholder]]", findReplaceOptions);
        Replacer.zzW07(document, string2, findReplaceOptions.getReplacementFormat());
        return n;
    }

    private static int zzW07(Document document, zzWot zzWot2, String string, FindReplaceOptions findReplaceOptions) throws Exception {
        if (findReplaceOptions.getReplacementFormat() == 0) {
            return document.getRange().zzW07(zzWot2, string, findReplaceOptions);
        }
        int n = document.getRange().zzW07(zzWot2, "[[WordizeTempPlaceholder]]", findReplaceOptions);
        Replacer.zzW07(document, string, findReplaceOptions.getReplacementFormat());
        return n;
    }

    private static void zzW07(Document document, String string, int n) throws Exception {
        DocumentBuilder documentBuilder = new DocumentBuilder(document);
        for (Node node : document.getChildNodes(21, true)) {
            Run run = (Run)node;
            if (!"[[WordizeTempPlaceholder]]".equals(run.getText())) continue;
            documentBuilder.moveTo(run);
            switch (n) {
                case 2: {
                    documentBuilder.insertHtml(string, 2);
                    break;
                }
                case 1: {
                    zzZfS zzZfS2 = new zzZfS(zz98.zzAo().zzXPO(string));
                    try {
                        LoadOptions loadOptions = new LoadOptions();
                        loadOptions.setLoadFormat(63);
                        Document document2 = new Document(zzZfS2, loadOptions);
                        documentBuilder.insertDocumentInline(document2, 0, new ImportFormatOptions());
                        break;
                    }
                    finally {
                        zzZfS2.close();
                    }
                }
                default: {
                    documentBuilder.write(string);
                }
            }
            run.remove();
        }
    }
}

