/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocSaveOptions;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.HtmlFixedSaveOptions;
import com.aspose.words.HtmlSaveOptions;
import com.aspose.words.IDocumentSavingCallback;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.MarkdownSaveOptions;
import com.aspose.words.OdtSaveOptions;
import com.aspose.words.OoxmlSaveOptions;
import com.aspose.words.PclSaveOptions;
import com.aspose.words.PdfSaveOptions;
import com.aspose.words.PsSaveOptions;
import com.aspose.words.RtfSaveOptions;
import com.aspose.words.SvgSaveOptions;
import com.aspose.words.TxtSaveOptions;
import com.aspose.words.WordML2003SaveOptions;
import com.aspose.words.XamlFixedSaveOptions;
import com.aspose.words.XamlFlowSaveOptions;
import com.aspose.words.XlsxSaveOptions;
import com.aspose.words.XpsSaveOptions;
import com.aspose.words.internal.zzYVu;
import com.aspose.words.internal.zzYY5;
import com.aspose.words.internal.zzZTE;
import java.util.TimeZone;

public abstract class SaveOptions {
    private IDocumentSavingCallback zzMh;
    private boolean zzWqB;
    boolean zzXYW = true;
    private boolean zz39 = true;
    private boolean zzgs = false;
    private boolean zzXEf;
    private boolean zzZmZ = true;
    private boolean zzXcK;
    private String zzWpm;
    private boolean zzWSG;
    private boolean zzWeA = false;
    private int zzZgj = 1;
    private int zzyr = 1;
    private int zzYIj = 0;
    private String zzX0m = "";
    private boolean zzXzX = true;
    private boolean zzWUQ = true;
    private boolean zzWqt;
    private boolean zzY8A;
    private int zzZFP = 0;
    private boolean zzEX = true;
    private boolean zzhp = false;
    private boolean zzZ3E = false;
    private TimeZone zzWI8 = zzYVu.getTimeZone();

    protected SaveOptions() {
    }

    final boolean zzYra() {
        return this.zzXEf;
    }

    public abstract int getSaveFormat();

    public abstract void setSaveFormat(int var1);

    boolean zzYhK() {
        return false;
    }

    boolean zzYua() {
        return true;
    }

    public boolean getExportGeneratorName() {
        return this.zzZmZ;
    }

    public void setExportGeneratorName(boolean value) {
        this.zzZmZ = value;
    }

    public String getTempFolder() {
        return this.zzWpm;
    }

    public void setTempFolder(String value) {
        this.zzWpm = value;
    }

    public boolean getPrettyFormat() {
        return this.zzXcK;
    }

    public void setPrettyFormat(boolean value) {
        this.zzXcK = value;
    }

    public boolean getUseAntiAliasing() {
        return this.zzWSG;
    }

    public void setUseAntiAliasing(boolean value) {
        this.zzWSG = value;
    }

    public boolean getUseHighQualityRendering() {
        return this.zzWeA;
    }

    public void setUseHighQualityRendering(boolean value) {
        this.zzWeA = value;
    }

    public int getDmlRenderingMode() {
        return this.zzZgj;
    }

    public void setDmlRenderingMode(int value) {
        this.zzZgj = value;
    }

    public int getDmlEffectsRenderingMode() {
        return this.zzYIj;
    }

    public void setDmlEffectsRenderingMode(int value) {
        this.zzYIj = value;
    }

    public int getImlRenderingMode() {
        return this.zzyr;
    }

    public void setImlRenderingMode(int value) {
        this.zzyr = value;
    }

    public String getDefaultTemplate() {
        return this.zzX0m;
    }

    public void setDefaultTemplate(String value) {
        this.zzX0m = value;
    }

    public boolean getUpdateFields() {
        return this.zzXzX;
    }

    public void setUpdateFields(boolean value) {
        this.zzXzX = value;
    }

    public boolean getUpdateLastSavedTimeProperty() {
        return this.zzWqt;
    }

    public void setUpdateLastSavedTimeProperty(boolean value) {
        this.zzWqt = value;
    }

    public boolean getUpdateLastPrintedProperty() {
        return this.zzY8A;
    }

    public void setUpdateLastPrintedProperty(boolean value) {
        this.zzY8A = value;
    }

    public boolean getUpdateCreatedTimeProperty() {
        return this.zzhp;
    }

    public void setUpdateCreatedTimeProperty(boolean value) {
        this.zzhp = value;
    }

    public boolean getMemoryOptimization() {
        return this.zzgs;
    }

    public void setMemoryOptimization(boolean value) {
        this.zzgs = value;
    }

    public boolean getUpdateAmbiguousTextFont() {
        return this.zzZ3E;
    }

    public void setUpdateAmbiguousTextFont(boolean value) {
        this.zzZ3E = value;
    }

    final boolean zzW8O() {
        return this.zzWUQ;
    }

    final boolean zzYBk() {
        return this.zzEX;
    }

    public static SaveOptions createSaveOptions(int saveFormat) {
        switch (saveFormat) {
            case 10: 
            case 11: {
                return new DocSaveOptions(saveFormat);
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                return new OoxmlSaveOptions(saveFormat);
            }
            case 30: {
                return new RtfSaveOptions();
            }
            case 31: {
                return new WordML2003SaveOptions();
            }
            case 40: {
                return new PdfSaveOptions();
            }
            case 47: {
                return new PsSaveOptions();
            }
            case 48: {
                return new PclSaveOptions();
            }
            case 41: {
                return new XpsSaveOptions(41);
            }
            case 46: {
                return new XpsSaveOptions(46);
            }
            case 42: {
                return new XamlFixedSaveOptions();
            }
            case 44: {
                return new SvgSaveOptions();
            }
            case 45: {
                return new HtmlFixedSaveOptions();
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: {
                return new HtmlSaveOptions(saveFormat);
            }
            case 60: 
            case 61: {
                return new OdtSaveOptions(saveFormat);
            }
            case 70: {
                return new TxtSaveOptions();
            }
            case 71: {
                return new XamlFlowSaveOptions();
            }
            case 72: {
                return new XamlFlowSaveOptions(saveFormat);
            }
            case 73: {
                return new MarkdownSaveOptions();
            }
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                return new ImageSaveOptions(saveFormat);
            }
            case 80: {
                return new XlsxSaveOptions();
            }
        }
        throw new IllegalArgumentException("Invalid save format requested.");
    }

    public static SaveOptions createSaveOptions(String fileName) throws Exception {
        return SaveOptions.createSaveOptions(FileFormatUtil.zzYzj(zzYY5.zzWf8(zzZTE.zzZNB(fileName))));
    }

    public int getDml3DEffectsRenderingMode() {
        return this.zzZFP;
    }

    public void setDml3DEffectsRenderingMode(int value) {
        this.zzZFP = value;
    }

    public IDocumentSavingCallback getProgressCallback() {
        return this.zzMh;
    }

    public void setProgressCallback(IDocumentSavingCallback value) {
        this.zzMh = value;
    }

    public boolean getAllowEmbeddingPostScriptFonts() {
        return this.zzWqB;
    }

    public void setAllowEmbeddingPostScriptFonts(boolean value) {
        this.zzWqB = value;
    }

    public TimeZone getCustomTimeZoneInfo() {
        return this.zzWI8;
    }

    public void setCustomTimeZoneInfo(TimeZone value) {
        this.zzWI8 = value;
    }

    final boolean zzZfi() {
        return this.zz39;
    }

    final void zzVPI(boolean bl) {
        this.zz39 = false;
    }
}

