/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Body;
import com.aspose.words.CompositeNode;
import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.HeaderFooter;
import com.aspose.words.HeaderFooterCollection;
import com.aspose.words.Node;
import com.aspose.words.PageSetup;
import com.aspose.words.Paragraph;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SectionStart;
import com.aspose.words.Shape;
import com.aspose.words.Story;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzWoj;
import com.aspose.words.zzVWF;
import com.aspose.words.zzYk6;
import com.aspose.words.zzZmv;
import com.aspose.words.zzZmy;
import java.util.ArrayList;

public final class Section
extends CompositeNode<Node>
implements zzVWF {
    private zzYk6 zzYWH;
    private PageSetup zzqp;
    private HeaderFooterCollection zza3;

    public Section(DocumentBase doc) {
        this(doc, new zzYk6());
    }

    Section(DocumentBase doc, zzYk6 sectPr) {
        super(doc);
        this.zzYWH = sectPr;
    }

    @Override
    public final int getNodeType() {
        return 2;
    }

    public final Body getBody() {
        return (Body)this.getChild(3, 0, false);
    }

    public final HeaderFooterCollection getHeadersFooters() {
        if (this.zza3 == null) {
            this.zza3 = new HeaderFooterCollection(this);
        }
        return this.zza3;
    }

    public final PageSetup getPageSetup() {
        if (this.zzqp == null) {
            Section section = this;
            this.zzqp = new PageSetup(section, section.getDocument().zz9w(), this.getDocument().getStyles(), new zzW07(this));
        }
        return this.zzqp;
    }

    public final boolean getProtectedForForms() {
        return !this.getPageSetup().zzXsU();
    }

    public final void setProtectedForForms(boolean value) {
        this.getPageSetup().zzW1u(!value);
    }

    final zzYk6 zzYga() {
        return this.zzYWH;
    }

    final void zzYIm(zzYk6 zzYk62) {
        this.zzYWH = zzYk62;
    }

    public final Section deepClone() {
        return (Section)this.deepClone(true);
    }

    @Override
    final Node zzW07(boolean bl, zzZmy zzZmy2) {
        zzYk6 zzYk62;
        Section section = (Section)super.zzW07(bl, zzZmy2);
        zzYk6 zzYk63 = this.zzYWH;
        section.zzYWH = zzYk62 = (zzYk6)zzYk63.zzWMc();
        section.zzqp = null;
        section.zza3 = null;
        return section;
    }

    @Override
    public final boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public final int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionStart(this);
    }

    @Override
    public final int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitSectionEnd(this);
    }

    public final void prependContent(Section sourceSection) {
        this.zzYpS(sourceSection, false);
    }

    public final void appendContent(Section sourceSection) {
        this.zzYpS(sourceSection, true);
    }

    public final void clearContent() {
        this.clearHeadersFooters();
        this.getBody().removeAllChildren();
        this.getBody().ensureMinimum();
    }

    public final void clearHeadersFooters() {
        this.clearHeadersFooters(false);
    }

    public final void clearHeadersFooters(boolean preserveWatermarks) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            HeaderFooter headerFooter = (HeaderFooter)node;
            ArrayList arrayList = preserveWatermarks ? headerFooter.getChildNodes(18, true).zzXS8() : zzZmv.zzbB().zzXS8();
            headerFooter.removeAllChildren();
            for (Shape shape : arrayList) {
                if (!shape.zzYNz() && !shape.zzYIZ()) continue;
                headerFooter.appendChild(new Paragraph(this.getDocument()));
                headerFooter.getFirstParagraph().appendChild(shape);
            }
        }
    }

    public final void deleteHeaderFooterShapes() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 4) continue;
            ((HeaderFooter)node).deleteShapes();
        }
    }

    public final void ensureMinimum() {
        Body body = this.getBody();
        if (body == null) {
            body = this.appendChild(new Body(this.getDocument()));
        }
        body.ensureMinimum();
    }

    final void zzWT7(int n) {
        switch (n) {
            case 1033: 
            case 2058: 
            case 4105: 
            case 5130: 
            case 8202: 
            case 9226: 
            case 13321: 
            case 13322: {
                this.getPageSetup().setPaperSize(9);
                return;
            }
        }
        this.getPageSetup().setPaperSize(1);
    }

    final Story zzX3O(int n) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (((Story)node).getStoryType() != n) continue;
            return (Story)node;
        }
        return null;
    }

    @Override
    final boolean zzm1(Node node) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                int n = ((Story)node).getStoryType();
                return this.zzX3O(n) == null;
            }
        }
        return false;
    }

    final void zzYIm(Shape shape, boolean bl) throws Exception {
        this.zzW07(shape, 4, bl);
        this.zzW07(shape, 0, bl);
        this.zzW07(shape, 1, bl);
    }

    private void zzW07(Shape shape, int n, boolean bl) throws Exception {
        HeaderFooter headerFooter = this.getHeadersFooters().getByHeaderFooterType(n);
        if (headerFooter == null) {
            if (!bl) {
                return;
            }
            headerFooter = new HeaderFooter(this.getDocument(), n);
            this.getHeadersFooters().add(headerFooter);
        }
        if (headerFooter.getParagraphs().getCount() == 0) {
            headerFooter.appendChild(new Paragraph(this.getDocument()));
        }
        Shape shape2 = (Shape)shape.deepClone(true);
        shape2.setId(shape2.getDocument().zzVX8());
        shape2.setName(zzWoj.zzYQ4("{0}{1}", shape2.hasImage() ? "WordPictureWatermark" : "PowerPlusWaterMarkObject", shape2.getId()));
        headerFooter.getFirstParagraph().appendChild(shape2);
    }

    final boolean zzoU() {
        boolean bl = false;
        for (HeaderFooter headerFooter : this.getHeadersFooters()) {
            if (!headerFooter.isHeader()) continue;
            for (Shape shape : headerFooter.zzZ0z()) {
                if (!shape.zzWW()) continue;
                shape.remove();
                bl = true;
            }
        }
        return bl;
    }

    private void zzYpS(Section section, boolean bl) {
        Paragraph paragraph;
        if (section == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: sourceSection");
        }
        Body body = section.getBody();
        if (body == null) {
            return;
        }
        Body body2 = this.getBody();
        if (body2 == null) {
            body2 = this.appendChild(new Body(this.getDocument()));
        }
        body = (Body)this.getDocument().importNode(body, true);
        CompositeNode compositeNode = paragraph = bl ? body2.getLastParagraph() : null;
        while (compositeNode != null && paragraph.getParentNode() != body2) {
            compositeNode = paragraph.getParentNode();
        }
        body2.zzYQ4(body.getFirstChild(), null, paragraph);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key) {
        return this.zzYWH.zzXa9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object getDirectSectionAttr(int key, int revisionsView) {
        return this.zzYWH.zzZuM(key, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchInheritedSectionAttr(int key) {
        if (key == 2600) {
            return this.getDocument().zz9w().zzYjY.zzZyj(key);
        }
        return zzYk6.zzZs3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key) {
        Object object = this.getDirectSectionAttr(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final Object fetchSectionAttr(int key, int revisionsView) {
        Object object = this.getDirectSectionAttr(key, revisionsView);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedSectionAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value) {
        if (key == 2260 || key == 2270) {
            this.zzYWH.remove(2090);
        }
        if (key == 2600) {
            this.getDocument().zz9w().zzYjY.zzZKJ(key, value);
            return;
        }
        this.zzYWH.zzZKJ(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void setSectionAttr(int key, Object value, int revisionsView) {
        if (key == 2260 || key == 2270) {
            this.zzYWH.zzWL0(2090, revisionsView);
        }
        if (key == 2600) {
            this.getDocument().zz9w().zzYjY.zzYQ4(key, value, revisionsView);
            return;
        }
        this.zzYWH.zzYQ4(key, value, revisionsView);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public final void clearSectionAttrs() {
        this.zzYWH.clear();
    }

    final boolean zzYXK() {
        return this.getParentNode().getFirstChild() == this;
    }

    final boolean zzXic() {
        return this.getParentNode().getLastChild() == this;
    }

    @Override
    public final String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = super.toString();
        Section section = this;
        objectArray[1] = SectionStart.toString(section.zzYWH.getSectionStart());
        return zzWoj.zzYQ4("{0} {1}", objectArray);
    }

    static final class zzW07
    implements zzVWF {
        private Section zzZxD;

        zzW07(Section section) {
            this.zzZxD = section;
        }

        @Override
        public final Object getDirectSectionAttr(int key) {
            return this.zzW3u().getDirectSectionAttr(key);
        }

        @Override
        public final Object getDirectSectionAttr(int key, int revisionsView) {
            return this.zzW3u().getDirectSectionAttr(key, revisionsView);
        }

        @Override
        public final Object fetchInheritedSectionAttr(int key) {
            return this.zzW3u().fetchInheritedSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key) {
            return this.zzW3u().fetchSectionAttr(key);
        }

        @Override
        public final Object fetchSectionAttr(int key, int revisionsView) {
            return this.zzW3u().fetchSectionAttr(key, revisionsView);
        }

        @Override
        public final void setSectionAttr(int key, Object value) {
        }

        @Override
        public final void setSectionAttr(int key, Object value, int revisionsView) {
        }

        @Override
        public final void clearSectionAttrs() {
        }

        private zzVWF zzW3u() {
            Document document = zzVUI.zzW07((Object)this.zzZxD.getDocument(), Document.class);
            if (document != null && document.getFirstSection() != null) {
                return document.getFirstSection();
            }
            return this.zzZxD;
        }
    }
}

