/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzWoj;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataTable;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DataColumnCollection
implements Iterable<DataColumn> {
    private final ArrayList<DataColumn> zzDk = new ArrayList();
    private final Map<String, DataColumn> zzZn9 = new HashMap<String, DataColumn>();
    private DataTable zzXWO;

    DataColumnCollection(DataTable table) {
        this.zzXWO = table;
    }

    public void add(DataColumn column) {
        if (zzWoj.zzYAJ(column.getColumnName())) {
            throw new IllegalArgumentException("Column name cannot be null or empty");
        }
        String string = DataColumnCollection.zzWOr(column.getColumnName());
        if (this.zzZn9.containsKey(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        column.zzYpS(this.zzXWO);
        column.setOrdinal(this.zzDk.size());
        this.zzDk.add(column);
        this.zzZn9.put(string, column);
        this.zzXWO.onDataColumnInserted(column);
    }

    public void add(String columnName) {
        this.add(columnName, String.class);
    }

    public DataColumn add(String columnName, Class type) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzXWO);
        this.add(dataColumn);
        return dataColumn;
    }

    public DataColumn add(String columnName, Class type, int columnMapping, boolean allowAutoIncrement, boolean allowDBNull) {
        DataColumn dataColumn = new DataColumn(columnName, type, this.zzXWO);
        dataColumn.setColumnMapping(columnMapping);
        dataColumn.setAutoIncrement(allowAutoIncrement);
        dataColumn.setAllowDBNull(allowDBNull);
        this.add(dataColumn);
        return dataColumn;
    }

    public int indexOf(String columnName) {
        if (zzWoj.zzYAJ(columnName)) {
            return -1;
        }
        String string = DataColumnCollection.zzWOr(columnName);
        DataColumn dataColumn = this.zzZn9.get(string);
        if (dataColumn != null) {
            int n = this.zzDk.size();
            for (int i = 0; i < n; ++i) {
                if (this.zzDk.get(i) != dataColumn) continue;
                return i;
            }
        }
        return -1;
    }

    public int indexOf(DataColumn column) {
        if (column == null) {
            return -1;
        }
        return this.indexOf(column.getColumnName());
    }

    public DataColumn get(int index) {
        return this.zzDk.get(index);
    }

    public DataColumn get(String columnName) {
        int n = this.indexOf(columnName);
        if (n >= 0) {
            return this.get(n);
        }
        return null;
    }

    public boolean contains(String name) {
        return this.indexOf(name) >= 0;
    }

    public void remove(String name) {
        int n = this.indexOf(name);
        if (n >= 0) {
            DataColumn dataColumn = this.zzDk.remove(n);
            this.zzZn9.remove(DataColumnCollection.zzWOr(dataColumn.getColumnName()));
            for (DataRow dataRow : this.zzXWO.getRows()) {
                dataRow.remove(n);
            }
            this.zzXWO.onDataColumnDeleted(dataColumn);
        }
    }

    public void remove(DataColumn column) {
        this.remove(column.getColumnName());
    }

    public int getCount() {
        return this.zzDk.size();
    }

    @Override
    public Iterator<DataColumn> iterator() {
        return this.zzDk.iterator();
    }

    public void clear() {
        this.zzZn9.clear();
        this.zzDk.clear();
    }

    final DataColumn[] zzYBL() {
        ArrayList<DataColumn> arrayList = new ArrayList<DataColumn>(this.zzDk);
        return arrayList.toArray(new DataColumn[arrayList.size()]);
    }

    final void zzW07(String string, DataColumn dataColumn) {
        if (this.contains(string)) {
            throw new IllegalArgumentException("Column with the same name already exists");
        }
        int n = this.zzDk.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzDk.get(i) != dataColumn) continue;
            String string2 = DataColumnCollection.zzWOr(string);
            String string3 = DataColumnCollection.zzWOr(dataColumn.getColumnName());
            this.zzZn9.remove(string3);
            this.zzZn9.put(string2, dataColumn);
            return;
        }
    }

    private static String zzWOr(String string) {
        return Normalizer.normalize(string.toLowerCase(), Normalizer.Form.NFD);
    }
}

