/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.net.System.Data;

import com.aspose.words.internal.zzW9k;
import com.aspose.words.net.System.Data.ConstraintCollection;
import com.aspose.words.net.System.Data.DataColumn;
import com.aspose.words.net.System.Data.DataColumnCollection;
import com.aspose.words.net.System.Data.DataException;
import com.aspose.words.net.System.Data.DataRelation;
import com.aspose.words.net.System.Data.DataRelationCollection;
import com.aspose.words.net.System.Data.DataRow;
import com.aspose.words.net.System.Data.DataRowCollection;
import com.aspose.words.net.System.Data.DataSet;
import com.aspose.words.net.System.Data.DataTableEventListener;
import com.aspose.words.net.System.Data.InvalidConstraintException;
import com.aspose.words.net.System.Data.UniqueConstraint;
import com.aspose.words.net.System.Data.zzXhM;
import com.aspose.words.net.System.Data.zzY6t;
import com.aspose.words.net.System.Data.zzYIm;
import com.aspose.words.net.System.Data.zzYQ4;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DataTable
implements DataTableEventListener {
    private final DataRowCollection zzs0;
    private final DataColumnCollection zzYmI;
    private final ConstraintCollection zzZui;
    private final zzY6t zzYjy;
    private ResultSet zzWWr;
    private String zzZlb;
    private DataSet zzYoi;
    private String zzXxY;
    private UniqueConstraint zzAp;
    private boolean zzYC0;
    private final List<DataTableEventListener> zzY4s;
    private final Set<DataRow> zzZYN;
    private DataRelationCollection zzZQ7;

    public DataTable() {
        this.zzs0 = new DataRowCollection(this);
        this.zzYmI = new DataColumnCollection(this);
        this.zzZui = new ConstraintCollection(this);
        this.zzYjy = new zzY6t(this);
        this.zzXxY = "";
        this.zzYC0 = true;
        this.zzY4s = new ArrayList<DataTableEventListener>();
        this.zzZYN = new HashSet<DataRow>();
        this.zzZQ7 = new DataRelationCollection();
    }

    public DataTable(String tableName) {
        this.zzs0 = new DataRowCollection(this);
        this.zzYmI = new DataColumnCollection(this);
        this.zzZui = new ConstraintCollection(this);
        this.zzYjy = new zzY6t(this);
        this.zzXxY = "";
        this.zzYC0 = true;
        this.zzY4s = new ArrayList<DataTableEventListener>();
        this.zzZYN = new HashSet<DataRow>();
        this.zzZQ7 = new DataRelationCollection();
        this.zzZlb = tableName;
    }

    public DataTable(ResultSet resultSet) throws SQLException {
        ResultSet resultSet2 = resultSet;
        this(resultSet2, zzYQ4.zzW07(resultSet2));
    }

    public DataTable(ResultSet resultSet, String tableName) throws SQLException {
        this.zzs0 = new DataRowCollection(this);
        this.zzYmI = new DataColumnCollection(this);
        this.zzZui = new ConstraintCollection(this);
        this.zzYjy = new zzY6t(this);
        this.zzXxY = "";
        this.zzYC0 = true;
        this.zzY4s = new ArrayList<DataTableEventListener>();
        this.zzZYN = new HashSet<DataRow>();
        this.zzZQ7 = new DataRelationCollection();
        if (resultSet == null) {
            throw new IllegalArgumentException("resultSet");
        }
        if (tableName == null) {
            throw new IllegalArgumentException("tableName");
        }
        this.zzWWr = resultSet;
        this.zzZlb = tableName;
        this.refresh();
    }

    public void close() throws Exception {
        if (this.zzWWr != null) {
            if (this.zzWWr.getStatement() != null) {
                this.zzWWr.getStatement().getConnection().close();
            }
            this.zzWWr = null;
            this.clearEventListneers();
        }
    }

    public String getTableName() {
        return this.zzZlb;
    }

    public void setTableName(String tableName) {
        this.zzZlb = tableName;
    }

    @Deprecated
    public boolean containsColumn(String columnName) {
        return this.getColumns().contains(columnName);
    }

    public int getColumnsCount() {
        return this.zzYmI.getCount();
    }

    public String getColumnName(int index) {
        return this.zzYmI.get(index).getColumnName();
    }

    public ResultSet getResultSet() {
        return this.zzWWr;
    }

    public DataSet getDataSet() {
        return this.zzYoi;
    }

    final void zzYpS(DataSet dataSet) {
        this.zzYoi = dataSet;
    }

    public DataRelationCollection getChildRelations() {
        for (DataRelation dataRelation : this.zzYoi.getRelations()) {
            if (dataRelation.getParentTable() != this) continue;
            this.zzZQ7.add(dataRelation);
        }
        return this.zzZQ7;
    }

    public DataRelationCollection getParentRelations() {
        DataRelationCollection dataRelationCollection = new DataRelationCollection();
        for (DataRelation dataRelation : this.zzYoi.getRelations()) {
            if (dataRelation.getChildTable() != this) continue;
            dataRelationCollection.add(dataRelation);
        }
        return dataRelationCollection;
    }

    public DataRowCollection getRows() {
        return this.zzs0;
    }

    public DataColumnCollection getColumns() {
        return this.zzYmI;
    }

    public DataRow newRow() {
        return new DataRow(this);
    }

    public ConstraintCollection getConstraints() {
        return this.zzZui;
    }

    public DataColumn[] getPrimaryKey() {
        if (this.zzAp == null) {
            return new DataColumn[0];
        }
        return this.zzAp.getColumns();
    }

    final void zzY6t(List<String> list) {
        DataColumn[] dataColumnArray = new DataColumn[list.size()];
        for (int i = 0; i < dataColumnArray.length; ++i) {
            dataColumnArray[i] = this.getColumns().get(list.get(i));
        }
        this.setPrimaryKey(dataColumnArray);
    }

    public void setPrimaryKey(DataColumn[] value) throws DataException, InvalidConstraintException {
        if (value == null || value.length == 0) {
            if (this.zzAp != null) {
                this.zzAp.zzih(false);
                this.getConstraints().remove(this.zzAp);
                this.zzAp = null;
            }
            return;
        }
        if (this.zzAp != null && DataColumn.areColumnSetsTheSame(value, this.zzAp.getColumns())) {
            return;
        }
        UniqueConstraint uniqueConstraint = UniqueConstraint.zzW07(this.getConstraints(), value);
        if (uniqueConstraint == null) {
            for (DataColumn dataColumn : value) {
                if (dataColumn.getTable() == null) break;
                if (this.getColumns().indexOf(dataColumn) >= 0) continue;
                throw new IllegalArgumentException("PrimaryKey columns do not belong to this table.");
            }
            uniqueConstraint = new UniqueConstraint(value, false);
            this.getConstraints().add(uniqueConstraint);
        }
        if (this.zzAp != null) {
            this.zzAp.zzih(false);
            this.getConstraints().remove(this.zzAp);
            this.zzAp = null;
        }
        UniqueConstraint.zzW07(this.getConstraints(), uniqueConstraint);
        this.zzAp = uniqueConstraint;
        for (int i = 0; i < uniqueConstraint.getColumns().length; ++i) {
            uniqueConstraint.getColumns()[i].setAllowDBNull(false);
        }
    }

    public String getNamespace() {
        return this.zzXxY;
    }

    public void setNamespace(String namespace) {
        this.zzXxY = namespace;
    }

    public boolean getEnforceConstraints() {
        return this.zzYC0;
    }

    public void setEnforceConstraints(boolean enforceConstraints) {
        this.zzYC0 = enforceConstraints;
    }

    public void refresh() {
        if (this.getResultSet() == null) {
            return;
        }
        try {
            this.zzZYN.clear();
            this.getRows().clear();
            this.getColumns().clear();
            zzYQ4.zzW07(this.getResultSet(), this);
            zzYQ4.zzYQ4(this.getResultSet(), this);
            return;
        }
        catch (SQLException sQLException) {
            SQLException sQLException2 = sQLException;
            zzW9k.zzYpS(sQLException);
            return;
        }
    }

    public void acceptChanges() throws SQLException {
        zzYQ4.zzWql(this);
    }

    public synchronized void addEventListener(DataTableEventListener listener) {
        if (!this.zzY4s.contains(listener)) {
            this.zzY4s.add(listener);
        }
    }

    public void removeEventListener(zzYIm listener) {
        if (this.zzY4s.contains(listener)) {
            this.zzY4s.remove(listener);
        }
    }

    public synchronized void clearEventListneers() {
        this.zzY4s.clear();
    }

    @Override
    public void onDataRowChanged(DataRow row) {
        row.setRowState(16);
        this.zzZYN.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY4s) {
            dataTableEventListener.onDataRowChanged(row);
        }
    }

    @Override
    public void onDataRowInserted(DataRow row) {
        if (row.getRowState() == 4) {
            return;
        }
        row.setRowState(1);
        this.zzZYN.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY4s) {
            dataTableEventListener.onDataRowInserted(row);
        }
    }

    @Override
    public void onDataRowDeleted(DataRow row) {
        row.setRowState(8);
        this.zzZYN.add(row);
        for (DataTableEventListener dataTableEventListener : this.zzY4s) {
            dataTableEventListener.onDataRowDeleted(row);
        }
    }

    @Override
    public void onDataColumnInserted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzY4s) {
            dataTableEventListener.onDataColumnInserted(column);
        }
    }

    @Override
    public void onDataColumnDeleted(DataColumn column) {
        for (DataTableEventListener dataTableEventListener : this.zzY4s) {
            dataTableEventListener.onDataColumnDeleted(column);
        }
    }

    final zzXhM zzW07(zzYQ4[] zzYQ4Array) {
        DataColumn[] dataColumnArray = new DataColumn[zzYQ4Array.length];
        for (int i = 0; i < zzYQ4Array.length; ++i) {
            dataColumnArray[i] = zzYQ4Array[i].zzYQ2();
        }
        DataTable dataTable = this;
        zzXhM zzXhM2 = dataTable.zzYjy.zzYpS(dataColumnArray);
        if (zzXhM2 == null) {
            throw new IllegalStateException("Index not found");
        }
        return zzXhM2;
    }

    final zzY6t zzYul() {
        return this.zzYjy;
    }

    final Set<DataRow> zztS() {
        return this.zzZYN;
    }
}

