/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Border;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzYBX;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzXyJ;
import java.awt.Color;
import java.util.Iterator;

public final class BorderCollection
implements Iterable<Border> {
    private zzXyJ zzXsV;

    BorderCollection(zzXyJ parent) {
        this.zzXsV = parent;
    }

    public final boolean equals(BorderCollection brColl) throws Exception {
        if (zzVUI.zzWyk(this, brColl)) {
            return true;
        }
        return this.getLeft().equals(brColl.getLeft()) && this.getRight().equals(brColl.getRight()) && this.getTop().equals(brColl.getTop()) && this.getBottom().equals(brColl.getBottom()) && this.getHorizontal().equals(brColl.getHorizontal()) && this.getVertical().equals(brColl.getVertical()) && this.getColor().equals(brColl.getColor()) && this.zzXUR().equals(brColl.zzXUR()) && this.getDistanceFromText() == brColl.getDistanceFromText() && this.getLineWidth() == brColl.getLineWidth() && this.getLineStyle() == brColl.getLineStyle() && this.getCount() == brColl.getCount() && this.getShadow() == brColl.getShadow() && this.isVisible() == brColl.isVisible();
    }

    public final Border getByBorderType(int borderType) throws Exception {
        RefInt refInt = new RefInt(0);
        boolean bl = !this.zzXsV.getPossibleBorderKeys().zzW07(borderType, refInt);
        int borderKey = refInt.get();
        if (bl) {
            throw new IllegalStateException("The requested border is not available for this object.");
        }
        Border border = (Border)this.zzXsV.getDirectBorderAttr(borderKey);
        if (border == null) {
            border = new Border(this.zzXsV, borderKey);
            this.zzXsV.setBorderAttr(borderKey, border);
        }
        return border;
    }

    public final Border get(int index) throws Exception {
        int n = this.zzXsV.getPossibleBorderKeys().zzKa().get(index);
        return this.getByBorderType(n);
    }

    public final Border getLeft() throws Exception {
        return this.getByBorderType(1);
    }

    public final Border getRight() throws Exception {
        return this.getByBorderType(2);
    }

    public final Border getTop() throws Exception {
        return this.getByBorderType(3);
    }

    public final Border getBottom() throws Exception {
        return this.getByBorderType(0);
    }

    public final Border getHorizontal() throws Exception {
        return this.getByBorderType(4);
    }

    public final Border getVertical() throws Exception {
        return this.getByBorderType(5);
    }

    public final int getCount() {
        return this.zzXsV.getPossibleBorderKeys().getCount();
    }

    public final double getLineWidth() throws Exception {
        return this.get(0).getLineWidth();
    }

    public final void setLineWidth(double value) throws Exception {
        Iterator iterator = this.zzXsV.getPossibleBorderKeys().zzKa().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZcX(n)) continue;
            this.getByBorderType(n).setLineWidth(value);
        }
    }

    public final int getLineStyle() throws Exception {
        return this.get(0).getLineStyle();
    }

    public final void setLineStyle(int value) throws Exception {
        Iterator iterator = this.zzXsV.getPossibleBorderKeys().zzKa().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZcX(n)) continue;
            this.getByBorderType(n).setLineStyle(value);
        }
    }

    public final Color getColor() throws Exception {
        return this.zzXUR().zzXnw();
    }

    public final void setColor(Color value) throws Exception {
        this.zzX2q(zzYBX.zzW07(value));
    }

    private zzYBX zzXUR() throws Exception {
        return this.get(0).zzXUR();
    }

    private void zzX2q(zzYBX zzYBX2) throws Exception {
        Iterator iterator = this.zzXsV.getPossibleBorderKeys().zzKa().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZcX(n)) continue;
            this.getByBorderType(n).zzX2q(zzYBX2);
        }
    }

    final boolean zzYfC(int n) {
        return this.zzXsV.getPossibleBorderKeys().zzH8(n);
    }

    public final double getDistanceFromText() throws Exception {
        return this.get(0).getDistanceFromText();
    }

    public final void setDistanceFromText(double value) throws Exception {
        Iterator iterator = this.zzXsV.getPossibleBorderKeys().zzKa().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZcX(n)) continue;
            this.getByBorderType(n).setDistanceFromText(value);
        }
    }

    public final boolean getShadow() throws Exception {
        return this.get(0).getShadow();
    }

    public final void setShadow(boolean value) throws Exception {
        Iterator iterator = this.zzXsV.getPossibleBorderKeys().zzKa().iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            if (!BorderCollection.zzZcX(n)) continue;
            this.getByBorderType(n).setShadow(value);
        }
    }

    public final void clearFormatting() {
        for (Border border : this) {
            border.clearFormatting();
        }
    }

    @Override
    public final Iterator<Border> iterator() {
        return new zzW07(this);
    }

    final boolean isVisible() {
        for (Border border : this) {
            if (!border.isVisible()) continue;
            return true;
        }
        return false;
    }

    private static boolean zzZcX(int n) {
        return n != 6 && n != 7;
    }

    static final class zzW07
    implements Iterator<Border> {
        private BorderCollection zzXQN;
        private int zzYFG;

        zzW07(BorderCollection borderCollection) {
            this.zzXQN = borderCollection;
            this.zzYFG = -1;
        }

        @Override
        public final boolean hasNext() {
            if (this.zzYFG >= this.zzXQN.getCount() - 1) {
                return false;
            }
            ++this.zzYFG;
            return true;
        }

        private Border zzZOM() {
            try {
                return this.zzXQN.get(this.zzYFG);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final /* synthetic */ Object next() {
            return this.zzZOM();
        }
    }
}

