/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompareOptions;
import com.aspose.words.ComparerContext;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.ImageSaveOptions;
import com.aspose.words.Processor;
import com.aspose.words.SaveOptions;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzXaS;
import com.aspose.words.internal.zzZTE;
import com.aspose.words.zzZmv;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;

public class Comparer
extends Processor {
    private ComparerContext zzXsl;

    private Comparer(ComparerContext context) {
        super(context);
        this.zzXsl = context;
    }

    public static Comparer create() {
        return Comparer.create(new ComparerContext());
    }

    public static Comparer create(ComparerContext context) {
        return new Comparer(context);
    }

    @Override
    protected void executeCore() throws Exception {
        Document document = this.zzY7b().get(this.zzY7b().size() - 2).zzZD7();
        Document document2 = this.zzY7b().get(this.zzY7b().size() - 1).zzZD7();
        if (this.zzXsl.getAcceptRevisions()) {
            if (document.hasRevisions()) {
                document.acceptAllRevisions();
            }
            if (document2.hasRevisions()) {
                document2.acceptAllRevisions();
            }
        } else {
            if (document.hasRevisions()) {
                document.getRevisions().rejectAll();
            }
            if (document2.hasRevisions()) {
                document2.getRevisions().rejectAll();
            }
        }
        document.zzW07(document2, this.zzXsl.getAuthor(), this.zzXsl.zzYda(), this.zzXsl.getCompareOptions());
        this.mResultDocument = document;
        super.executeCore();
    }

    @Override
    protected void checkArgumentsSet() {
        if (this.zzY7b().size() < 2) {
            throw new IllegalArgumentException("Two input documents must be set for the comparison.");
        }
        super.checkArgumentsSet();
    }

    private static void zzW07(String string, String string2, String string3, String string4, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(string3));
        Comparer.zzW07(string, string2, string3, n, string4, zzXaS2, compareOptions);
    }

    public static void compare(String v1, String v2, String outputFileName, String author, Date dateTime) throws Exception {
        Comparer.zzW07(v1, v2, outputFileName, author, zzXaS.zzW07(dateTime), null);
    }

    public static void compare(String v1, String v2, String outputFileName, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(v1, v2, outputFileName, author, zzXaS.zzW07(dateTime), compareOptions);
    }

    private static void zzW07(String string, String string2, String string3, int n, String string4, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(string, string2, string3, zzZmv.zzyp(n, string3), string4, zzXaS2, compareOptions);
    }

    public static void compare(String v1, String v2, String outputFileName, int saveFormat, String author, Date dateTime) throws Exception {
        Comparer.zzW07(v1, v2, outputFileName, saveFormat, author, zzXaS.zzW07(dateTime), null);
    }

    public static void compare(String v1, String v2, String outputFileName, int saveFormat, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(v1, v2, outputFileName, saveFormat, author, zzXaS.zzW07(dateTime), compareOptions);
    }

    private static void zzW07(String string, String string2, String string3, SaveOptions saveOptions, String string4, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        ComparerContext comparerContext = new ComparerContext();
        comparerContext.setAuthor(string4);
        comparerContext.zzYlB(zzXaS2);
        if (compareOptions != null) {
            comparerContext.zzW07(compareOptions);
        }
        Comparer.create(comparerContext).from(string).from(string2).to(string3, saveOptions).execute();
    }

    public static void compare(String v1, String v2, String outputFileName, SaveOptions saveOptions, String author, Date dateTime) throws Exception {
        Comparer.zzW07(v1, v2, outputFileName, saveOptions, author, zzXaS.zzW07(dateTime), null);
    }

    public static void compare(String v1, String v2, String outputFileName, SaveOptions saveOptions, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(v1, v2, outputFileName, saveOptions, author, zzXaS.zzW07(dateTime), compareOptions);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, zzXTI zzXTI4, int n, String string, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(zzXTI2, zzXTI3, zzXTI4, zzZmv.zzyp(n, null), string, zzXaS2, compareOptions);
    }

    public static void compare(InputStream v1, InputStream v2, OutputStream outputStream, int saveFormat, String author, Date dateTime) throws Exception {
        Comparer.zzW07(zzXTI.zzYQ4(v1), zzXTI.zzYQ4(v2), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, author, zzXaS.zzW07(dateTime), null);
    }

    public static void compare(InputStream v1, InputStream v2, OutputStream outputStream, int saveFormat, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(zzXTI.zzYQ4(v1), zzXTI.zzYQ4(v2), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, author, zzXaS.zzW07(dateTime), compareOptions);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, zzXTI zzXTI4, SaveOptions saveOptions, String string, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        ComparerContext comparerContext = new ComparerContext();
        comparerContext.setAuthor(string);
        comparerContext.zzYlB(zzXaS2);
        if (compareOptions != null) {
            comparerContext.zzW07(compareOptions);
        }
        zzXTI zzXTI5 = zzXTI2;
        Processor processor = Comparer.create(comparerContext);
        Processor processor2 = processor.zzYIm(zzXTI5, null);
        zzXTI5 = zzXTI3;
        processor = processor2;
        processor2.zzYIm(zzXTI5, null).zzYQ4(zzXTI4, saveOptions).execute();
    }

    public static void compare(InputStream v1, InputStream v2, OutputStream outputStream, SaveOptions saveOptions, String author, Date dateTime) throws Exception {
        Comparer.zzW07(zzXTI.zzYQ4(v1), zzXTI.zzYQ4(v2), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, author, zzXaS.zzW07(dateTime), null);
    }

    public static void compare(InputStream v1, InputStream v2, OutputStream outputStream, SaveOptions saveOptions, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        Comparer.zzW07(zzXTI.zzYQ4(v1), zzXTI.zzYQ4(v2), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, author, zzXaS.zzW07(dateTime), compareOptions);
    }

    private static zzXTI[] zzW07(String string, String string2, ImageSaveOptions imageSaveOptions, String string3, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        ComparerContext comparerContext = new ComparerContext();
        comparerContext.setAuthor(string3);
        comparerContext.zzYlB(zzXaS2);
        if (compareOptions != null) {
            comparerContext.zzW07(compareOptions);
        }
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        Comparer.create(comparerContext).from(string).from(string2).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzXTI[] zzXTIArray = new zzXTI[]{};
        ArrayList<zzXTI> arrayList2 = arrayList;
        return arrayList2.toArray(zzXTIArray);
    }

    public static OutputStream[] compareToImages(String v1, String v2, ImageSaveOptions imageSaveOptions, String author, Date dateTime) throws Exception {
        return zzXTI.zzYQ4(Comparer.zzW07(v1, v2, imageSaveOptions, author, zzXaS.zzW07(dateTime), null));
    }

    public static OutputStream[] compareToImages(String v1, String v2, ImageSaveOptions imageSaveOptions, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        return zzXTI.zzYQ4(Comparer.zzW07(v1, v2, imageSaveOptions, author, zzXaS.zzW07(dateTime), compareOptions));
    }

    private static zzXTI[] zzW07(zzXTI zzXTIArray, zzXTI zzXTI2, ImageSaveOptions imageSaveOptions, String string, zzXaS zzXaS2, CompareOptions compareOptions) throws Exception {
        ComparerContext comparerContext = new ComparerContext();
        comparerContext.setAuthor(string);
        comparerContext.zzYlB(zzXaS2);
        if (compareOptions != null) {
            comparerContext.zzW07(compareOptions);
        }
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        zzXTI[] zzXTIArray2 = zzXTIArray;
        Object object = Comparer.create(comparerContext);
        Processor processor = ((Processor)object).zzYIm((zzXTI)zzXTIArray2, null);
        zzXTIArray2 = zzXTI2;
        object = processor;
        processor.zzYIm((zzXTI)zzXTIArray2, null).to(arrayList, (SaveOptions)imageSaveOptions).execute();
        zzXTIArray2 = new zzXTI[]{};
        object = arrayList;
        return ((ArrayList)object).toArray(zzXTIArray2);
    }

    public static OutputStream[] compareToImages(InputStream v1, InputStream v2, ImageSaveOptions imageSaveOptions, String author, Date dateTime) throws Exception {
        return zzXTI.zzYQ4(Comparer.zzW07(zzXTI.zzYQ4(v1), zzXTI.zzYQ4(v2), imageSaveOptions, author, zzXaS.zzW07(dateTime), null));
    }

    public static OutputStream[] compareToImages(InputStream v1, InputStream v2, ImageSaveOptions imageSaveOptions, String author, Date dateTime, CompareOptions compareOptions) throws Exception {
        return zzXTI.zzYQ4(Comparer.zzW07(zzXTI.zzYQ4(v1), zzXTI.zzYQ4(v2), imageSaveOptions, author, zzXaS.zzW07(dateTime), compareOptions));
    }
}

