/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.NodeChangingArgs;
import com.aspose.words.NodeCollection;
import com.aspose.words.NodeList;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.SmartTag;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.zzGi;
import com.aspose.words.zzXKR;
import com.aspose.words.zzYCZ;
import com.aspose.words.zzYU9;
import com.aspose.words.zzYbG;
import com.aspose.words.zzYqC;
import com.aspose.words.zzZmv;
import com.aspose.words.zzZmy;
import java.util.Iterator;

public abstract class CompositeNode<V extends Node>
extends Node
implements zzYCZ,
Iterable<V> {
    private Node zzZj9;
    private Node zzGx;
    private Node zzX3H;

    protected CompositeNode() {
    }

    protected CompositeNode(DocumentBase doc) {
        super(doc);
    }

    protected void coreRemoveSelfOnly() {
        if (this.getParentNode() == null) {
            throw new IllegalStateException("This node is not attached to any document");
        }
        zzYqC zzYqC2 = new zzYqC(this.getDocument());
        try {
            while (this.hasChildNodes()) {
                this.getParentNode().insertAfter(this.getLastChild(), this);
            }
            this.getParentNode().zzYpS(this, true);
            return;
        }
        finally {
            zzYqC2.dispose();
        }
    }

    @Override
    public boolean isComposite() {
        return true;
    }

    public boolean hasChildNodes() {
        return this.getLastChild() != null;
    }

    final boolean zz1l() {
        return this.zzX4e() != null;
    }

    final boolean zzPb() {
        return this.hasChildNodes() && this.getFirstChild() == this.getLastChild();
    }

    final boolean zzuB() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node instanceof zzYU9) {
                return true;
            }
            CompositeNode compositeNode = zzVUI.zzW07((Object)node, CompositeNode.class);
            if (compositeNode == null || !compositeNode.zzuB()) continue;
            return true;
        }
        return false;
    }

    public Node getFirstChild() {
        return this.zzZj9;
    }

    public Node getLastChild() {
        return this.zzGx;
    }

    final Node zzX4e() {
        return zzZmv.zzYET(this.getFirstChild(), false);
    }

    final Node zzY7N() {
        return zzZmv.zzZKJ(this.getLastChild(), false);
    }

    final CompositeNode zzYmJ() {
        return (CompositeNode)zzZmv.zzYET(this.getFirstChild(), true);
    }

    final CompositeNode zzY8k() {
        return (CompositeNode)zzZmv.zzZKJ(this.getLastChild(), true);
    }

    final Node zzYsC() {
        Node node;
        Node node2;
        for (node2 = this.getFirstChild(); node2 != null && zzZmv.zznj((node = node2).getNodeType()); node2 = node2.getNextSibling()) {
        }
        return node2;
    }

    final Node zzsO() {
        Node node;
        Node node2;
        for (node2 = this.getLastChild(); node2 != null && zzZmv.zznj((node = node2).getNodeType()); node2 = node2.getPreviousSibling()) {
        }
        return node2;
    }

    public int getCount() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            ++n;
        }
        return n;
    }

    @Override
    Node zzW07(boolean bl, zzZmy zzZmy2) {
        CompositeNode compositeNode = (CompositeNode)super.zzW07(bl, zzZmy2);
        ((CompositeNode)super.zzW07(bl, zzZmy2)).zzGx = null;
        compositeNode.zzZj9 = null;
        if (bl) {
            for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
                compositeNode.zzad(node.zzW07(true, zzZmy2));
            }
        }
        return compositeNode;
    }

    @Override
    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzWss(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    final void zzWss(StringBuilder stringBuilder) {
        this.zzYHt(stringBuilder);
        zzVUI.zzYQ4(stringBuilder, this.zzWbE());
    }

    public NodeCollection getChildNodes(int nodeType, boolean isDeep) {
        return new NodeCollection(this, nodeType, isDeep);
    }

    final NodeCollection zzYQ4(int[] nArray, boolean bl) {
        return new NodeCollection(this, nArray, bl);
    }

    public Node getChild(int nodeType, int index, boolean isDeep) {
        if (index >= 0 && !isDeep) {
            Node node;
            int n = index + 1;
            boolean bl = zzZmv.zzXhQ(nodeType);
            Node node2 = node = bl ? this.zzX4e() : this.getFirstChild();
            while (node != null) {
                if (node.getNodeType() == nodeType || nodeType == 0) {
                    --n;
                }
                if (n == 0) {
                    return node;
                }
                node = bl ? node.zzbG() : node.getNextSibling();
            }
        } else {
            NodeCollection nodeCollection = this.getChildNodes(nodeType, isDeep);
            return nodeCollection.get(index);
        }
        return null;
    }

    public NodeList selectNodes(String xpath) {
        return zzZmv.zzYIm((Node)this, xpath);
    }

    public Node selectSingleNode(String xpath) {
        return zzZmv.zzYpS((Node)this, xpath);
    }

    @Override
    public Iterator<V> iterator() {
        return new zzYbG(this);
    }

    public <T extends Node> T appendChild(T newChild) {
        return this.insertAfter(newChild, this.getLastChild());
    }

    public <T extends Node> T prependChild(T newChild) {
        return this.insertBefore(newChild, this.getFirstChild());
    }

    public <T extends Node> T insertAfter(T newChild, Node refChild) {
        return this.zzW07(newChild, refChild, true);
    }

    public <T extends Node> T insertBefore(T newChild, Node refChild) {
        return this.zzW07(newChild, refChild, false);
    }

    public <T extends Node> T removeChild(T oldChild) {
        return this.zzYpS(oldChild, false);
    }

    private <T extends Node> T zzYpS(T t, boolean bl) {
        if (t == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: oldChild");
        }
        if (t.getParentNode() != this) {
            throw new IllegalArgumentException("This node is not a parent of the oldChild node.");
        }
        DocumentBase documentBase = this.getDocument();
        NodeChangingArgs nodeChangingArgs = zzZmv.zzW07(documentBase, t, (Node)this, null, 1);
        DocumentBase documentBase2 = documentBase;
        if (documentBase2.zzh3() && zzZmv.zzYZd(t)) {
            return t;
        }
        zzZmv.zzW07(documentBase, nodeChangingArgs);
        if (!bl && zzZmv.zzYBW(t)) {
            zzZmv.zzW2x(t, false);
        }
        T t2 = this.zzYwY(t);
        zzZmv.zzYQ4(documentBase, nodeChangingArgs);
        return t2;
    }

    public void removeAllChildren() {
        zzXKR.zzXG7(this.getFirstChild(), null);
    }

    public void removeSmartTags() {
        for (SmartTag smartTag : this.getChildNodes(27, true)) {
            smartTag.coreRemoveSelfOnly();
        }
    }

    final Node zzad(Node node) {
        node.getParentNode();
        if (this.zzGx == null) {
            node.zzE4(null);
            node.zzXw(null);
            this.zzZj9 = node;
        } else {
            node.zzE4(this.zzGx);
            node.zzXw(null);
            this.zzGx.zzXw(node);
        }
        this.zzGx = node;
        node.zzZmS(this);
        return node;
    }

    final void zzW07(Node node, Node node2, Node node3) {
        this.zzW07(node, node2, node3, false);
    }

    final void zzW07(Node node, Node node2, Node node3, boolean bl) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            if (!bl || this.zzm1(node4)) {
                this.insertBefore(node4, node3);
            }
            node4 = node5;
        }
    }

    final void zzYQ4(Node node, Node node2, Node node3) {
        if (node2 != null && node2.getParentNode() != node.getParentNode()) {
            throw new IllegalArgumentException("The start and end nodes should have the same parent.");
        }
        Node node4 = node;
        while (node4 != node2) {
            Node node5 = node4.getNextSibling();
            node3 = this.insertAfter(node4, node3);
            node4 = node5;
        }
    }

    public int indexOf(Node child) {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node == child) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    final int zzWql(Node node, boolean bl) {
        int n = 0;
        for (Node node2 = this.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            Node node3 = node2;
            if (zzZmv.zznj(node3.getNodeType())) continue;
            if (zzZmv.zzWql(node, node2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    final int getTextLength() {
        int n = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            n += node.getTextLength();
        }
        return n += this.zzWbE().length();
    }

    String zzWbE() {
        return "";
    }

    final String zz04() {
        StringBuilder stringBuilder = new StringBuilder();
        this.zzYHt(stringBuilder);
        return stringBuilder.toString();
    }

    private void zzYHt(StringBuilder stringBuilder) {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            node.zzWss(stringBuilder);
        }
    }

    protected boolean acceptCore(DocumentVisitor visitor) throws Exception {
        switch (this.acceptStart(visitor)) {
            case 0: {
                break;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            default: {
                throw new IllegalStateException("Unknown visitor action.");
            }
        }
        if (!this.acceptChildren(visitor)) {
            return false;
        }
        return CompositeNode.visitorActionToBool(this.acceptEnd(visitor));
    }

    public abstract int acceptStart(DocumentVisitor var1) throws Exception;

    public abstract int acceptEnd(DocumentVisitor var1) throws Exception;

    protected boolean acceptChildren(DocumentVisitor visitor) throws Exception {
        Node node = this.getFirstChild();
        while (node != null) {
            Node node2 = node.getNextSibling();
            if (!node.accept(visitor)) {
                return false;
            }
            node = node2;
        }
        return true;
    }

    boolean zzm1(Node node) {
        return true;
    }

    final <T extends Node> T zzW07(T t, Node node, boolean bl) {
        Object object;
        if (node != null && node.getParentNode() != this) {
            throw new IllegalArgumentException("The reference node is not a child of this node.");
        }
        if (t == null) {
            throw new IllegalArgumentException("Cannot insert a null node.");
        }
        if (t == this) {
            throw new IllegalArgumentException("Cannot add a node to self.");
        }
        if (this.zzXNL(t)) {
            throw new IllegalArgumentException("The newChild is an ancestor of this node.");
        }
        if (t == node) {
            throw new IllegalArgumentException("Cannot add a node before/after itself.");
        }
        DocumentBase documentBase = this.getDocument();
        DocumentBase documentBase2 = t.getDocument();
        zzZmv.zzW07(documentBase, documentBase2);
        if (t.getNodeType() != 37 && !this.zzm1(t)) {
            throw new IllegalArgumentException("Cannot insert a node of this type at this location.");
        }
        CompositeNode compositeNode = t.getParentNode();
        Node node2 = t.getNextSibling();
        if (compositeNode != null) {
            object = new zzGi(documentBase);
            try {
                compositeNode.zzYpS(t, true);
            }
            finally {
                ((zzGi)object).dispose();
            }
        }
        object = zzZmv.zzW07(documentBase, t, null, (Node)this, 0);
        zzZmv.zzW07(documentBase, (NodeChangingArgs)object);
        if (this.zzGx == null) {
            t.zzE4(null);
            t.zzXw(null);
            this.zzZj9 = t;
            this.zzGx = t;
        } else if (bl) {
            if (node != null) {
                this.zzYQ4(t, node);
            } else {
                this.zzYIm(t, this.zzZj9);
            }
        } else if (node != null) {
            this.zzYIm(t, node);
        } else {
            this.zzYQ4(t, this.zzGx);
        }
        t.zzZmS(this);
        zzZmv.zzYQ4(documentBase, (NodeChangingArgs)object);
        DocumentBase documentBase3 = documentBase;
        if (documentBase3.zzh3()) {
            zzZmv.zzW07(t, compositeNode, node2);
        }
        return t;
    }

    private void zzYQ4(Node node, Node node2) {
        Node node3 = node2.zzZQ1();
        node.zzE4(node2);
        node.zzXw(node3);
        node2.zzXw(node);
        if (node3 == null) {
            this.zzGx = node;
            return;
        }
        node3.zzE4(node);
    }

    private void zzYIm(Node node, Node node2) {
        Node node3 = node2.zzYtQ();
        node.zzE4(node3);
        node.zzXw(node2);
        node2.zzE4(node);
        if (node3 == null) {
            this.zzZj9 = node;
            return;
        }
        node3.zzXw(node);
    }

    private <T extends Node> T zzYwY(T t) {
        if (t == this.zzZj9) {
            if (this.zzZj9 == this.zzGx) {
                this.zzZj9 = null;
                this.zzGx = null;
            } else {
                this.zzZj9 = t.zzZQ1();
                this.zzZj9.zzE4(null);
            }
        } else {
            Node node = t.zzYtQ();
            Node node2 = t.zzZQ1();
            node.zzXw(node2);
            if (node2 == null) {
                this.zzGx = node;
            } else {
                node2.zzE4(node);
            }
        }
        t.zzXw(null);
        t.zzE4(null);
        t.zzZmS(null);
        return t;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getNextMatchingNode(Node curNode) {
        Node node = curNode;
        this.zzX3H = curNode == this ? this.getFirstChild() : curNode.getNextSibling();
        return node;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Node getCurrentNode() {
        return this.zzX3H;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public CompositeNode getContainer() {
        return this;
    }
}

