/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.FileCorruptedException;
import com.aspose.words.FileFormatInfo;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzYY5;
import com.aspose.words.internal.zzYb3;
import com.aspose.words.internal.zzZlO;
import com.aspose.words.internal.zzpV;
import com.aspose.words.ref.RefInt;
import com.aspose.words.zzYjS;
import java.io.EOFException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.ZipException;

public class FileFormatUtil {
    private static HashMap<Integer, Integer> zzZRe = new HashMap();
    private static HashMap<Integer, Integer> zzY3K = new HashMap();
    private static HashMap<Integer, Integer> zzZ7s = new HashMap();
    private static HashMap<Integer, Integer> zzt0 = new HashMap();
    private static HashMap<Integer, Integer> zzXcj = new HashMap();
    private static HashMap<Integer, Integer> zzZSE = new HashMap();

    private FileFormatUtil() {
    }

    public static FileFormatInfo detectFileFormat(String fileName) throws Exception {
        zzVUI.zzXhM(fileName, "fileName");
        try (zzYb3 zzYb32 = zzVUI.zzY3k(fileName);){
            FileFormatInfo fileFormatInfo = FileFormatUtil.zzXQG(zzYb32);
            return fileFormatInfo;
        }
    }

    public static FileFormatInfo detectFileFormat(InputStream stream) throws Exception {
        return FileFormatUtil.zzXQG(zzZlO.zzW07(stream));
    }

    static FileFormatInfo zzXQG(zzXTI zzXTI2) throws Exception {
        if (zzXTI2 == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: stream");
        }
        try {
            zzYjS zzYjS2 = new zzYjS();
            zzXTI zzXTI3 = zzXTI2;
            zzYjS zzYjS3 = zzYjS2;
            return zzYjS2.zzYQ4(zzXTI3, null);
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw FileFormatUtil.zzYIm(exception);
        }
    }

    public static int contentTypeToLoadFormat(String contentType) {
        int n = FileFormatUtil.zzZnY(zzYY5.zzyL(contentType));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a load format.");
    }

    public static int contentTypeToSaveFormat(String contentType) {
        int n = FileFormatUtil.zzYzj(zzYY5.zzyL(contentType));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this content type to a save format.");
    }

    public static String loadFormatToExtension(int loadFormat) {
        String string;
        if (loadFormat == 12) {
            loadFormat = 10;
        }
        if (zzpV.zzZY9(string = zzYY5.zzYeu(FileFormatUtil.zzXNf(loadFormat)))) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a file extension.");
    }

    public static int saveFormatToLoadFormat(int saveFormat) {
        int n = FileFormatUtil.zzZnY(FileFormatUtil.zzYr1(saveFormat));
        if (n != 255) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a load format.");
    }

    public static int loadFormatToSaveFormat(int loadFormat) {
        int n = FileFormatUtil.zzYzj(FileFormatUtil.zzXNf(loadFormat));
        if (n != 0) {
            return n;
        }
        throw new IllegalArgumentException("Cannot convert this load format to a save format.");
    }

    public static String saveFormatToExtension(int saveFormat) {
        String string = zzYY5.zzYeu(FileFormatUtil.zzYr1(saveFormat));
        if (zzpV.zzZY9(string)) {
            return "." + string;
        }
        throw new IllegalArgumentException("Cannot convert this save format to a file extension.");
    }

    public static int extensionToSaveFormat(String extension) {
        if (extension == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: extension");
        }
        return FileFormatUtil.zzYzj(zzYY5.zzWf8(extension));
    }

    public static String imageTypeToExtension(int imageType) {
        switch (imageType) {
            case 0: 
            case 1: {
                throw new IllegalArgumentException("Cannot convert this image type to a file extension.");
            }
        }
        return "." + zzYY5.zzYeu(FileFormatUtil.zzXbo(imageType));
    }

    static Exception zzYIm(Exception exception) {
        if (exception instanceof IllegalStateException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof EOFException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IndexOutOfBoundsException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof IllegalArgumentException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NullPointerException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof NumberFormatException) {
            return new FileCorruptedException(exception);
        }
        if (exception instanceof ZipException) {
            return new FileCorruptedException(exception);
        }
        return exception;
    }

    static boolean zzYEP(int n) {
        return n == 50;
    }

    static String zzMK(int n) {
        return zzYY5.toString(FileFormatUtil.zzYr1(n));
    }

    static int zzYzj(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzVUI.zzW07(zzXcj, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 0;
    }

    static int zzZ7F(int n) {
        RefInt refInt = new RefInt(0);
        boolean bl = zzVUI.zzW07(zzZSE, Integer.valueOf(n), refInt);
        int n2 = refInt.get();
        if (bl) {
            return n2;
        }
        return 1;
    }

    static boolean zzXMk(int n) {
        return n == 20 || n == 21 || n == 22 || n == 23 || n == 24 || n == 25 || n == 26 || n == 27 || n == 31;
    }

    static boolean zzhT(int n) {
        return n == 40 || n == 107 || n == 103 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106 || n == 41 || n == 48 || n == 46 || n == 45;
    }

    static boolean zzB8(int n) {
        return n == 103 || n == 107 || n == 100 || n == 101 || n == 102 || n == 104 || n == 44 || n == 105 || n == 106;
    }

    static int zzXNf(int n) {
        return zzVUI.zzW07(zzZRe, Integer.valueOf(n), Integer.valueOf(0));
    }

    static int zzYr1(int n) {
        return zzVUI.zzW07(zzY3K, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzXbo(int n) {
        return zzVUI.zzW07(zzZ7s, Integer.valueOf(n), Integer.valueOf(0));
    }

    private static int zzZnY(int n) {
        return zzVUI.zzW07(zzt0, Integer.valueOf(n), Integer.valueOf(255));
    }

    private static void zzYSz(int n, int n2, int n3, int n4) {
        if (n2 != 0) {
            zzVUI.zzYQ4(zzXcj, Integer.valueOf(n), Integer.valueOf(n2));
            zzVUI.zzYQ4(zzY3K, Integer.valueOf(n2), Integer.valueOf(n));
        }
        if (n3 != 255) {
            if (!zzt0.containsKey(n)) {
                zzVUI.zzYQ4(zzt0, Integer.valueOf(n), Integer.valueOf(n3));
            }
            zzVUI.zzYQ4(zzZRe, Integer.valueOf(n3), Integer.valueOf(n));
        }
        if (n4 != 1) {
            zzVUI.zzYQ4(zzZSE, Integer.valueOf(n), Integer.valueOf(n4));
            zzVUI.zzYQ4(zzZ7s, Integer.valueOf(n4), Integer.valueOf(n));
        }
    }

    static {
        FileFormatUtil.zzYSz(13, 10, 10, 1);
        FileFormatUtil.zzYSz(13, 0, 0, 1);
        FileFormatUtil.zzYSz(14, 11, 11, 1);
        FileFormatUtil.zzYSz(15, 20, 20, 1);
        FileFormatUtil.zzYSz(15, 0, 254, 1);
        FileFormatUtil.zzYSz(16, 21, 21, 1);
        FileFormatUtil.zzYSz(17, 22, 22, 1);
        FileFormatUtil.zzYSz(18, 23, 23, 1);
        FileFormatUtil.zzYSz(20, 24, 24, 1);
        FileFormatUtil.zzYSz(21, 25, 25, 1);
        FileFormatUtil.zzYSz(22, 26, 26, 1);
        FileFormatUtil.zzYSz(23, 27, 27, 1);
        FileFormatUtil.zzYSz(26, 30, 30, 1);
        FileFormatUtil.zzYSz(19, 31, 31, 1);
        FileFormatUtil.zzYSz(27, 50, 50, 1);
        FileFormatUtil.zzYSz(28, 45, 255, 1);
        FileFormatUtil.zzYSz(29, 51, 51, 1);
        FileFormatUtil.zzYSz(30, 54, 52, 1);
        FileFormatUtil.zzYSz(31, 0, 53, 1);
        FileFormatUtil.zzYSz(33, 53, 54, 1);
        FileFormatUtil.zzYSz(24, 60, 60, 1);
        FileFormatUtil.zzYSz(25, 61, 61, 1);
        FileFormatUtil.zzYSz(36, 40, 64, 1);
        FileFormatUtil.zzYSz(43, 47, 255, 1);
        FileFormatUtil.zzYSz(44, 48, 255, 1);
        FileFormatUtil.zzYSz(37, 41, 255, 1);
        FileFormatUtil.zzYSz(38, 46, 255, 1);
        FileFormatUtil.zzYSz(40, 42, 255, 1);
        FileFormatUtil.zzYSz(39, 44, 255, 1);
        FileFormatUtil.zzYSz(32, 52, 55, 1);
        FileFormatUtil.zzYSz(34, 70, 62, 1);
        FileFormatUtil.zzYSz(35, 73, 63, 1);
        FileFormatUtil.zzYSz(41, 71, 255, 1);
        FileFormatUtil.zzYSz(8, 100, 255, 1);
        FileFormatUtil.zzYSz(9, 105, 255, 10);
        FileFormatUtil.zzYSz(6, 101, 255, 6);
        FileFormatUtil.zzYSz(7, 102, 255, 7);
        FileFormatUtil.zzYSz(5, 104, 255, 5);
        FileFormatUtil.zzYSz(4, 0, 255, 4);
        FileFormatUtil.zzYSz(3, 0, 255, 3);
        FileFormatUtil.zzYSz(42, 72, 255, 1);
        FileFormatUtil.zzYSz(2, 103, 255, 2);
        FileFormatUtil.zzYSz(10, 106, 255, 8);
        FileFormatUtil.zzYSz(48, 80, 255, 1);
        FileFormatUtil.zzYSz(11, 107, 255, 9);
        FileFormatUtil.zzYSz(49, 0, 8, 1);
    }
}

