/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

public final class PdfPageLayout {
    public static final int SINGLE_PAGE = 0;
    public static final int ONE_COLUMN = 1;
    public static final int TWO_COLUMN_LEFT = 2;
    public static final int TWO_COLUMN_RIGHT = 3;
    public static final int TWO_PAGE_LEFT = 4;
    public static final int TWO_PAGE_RIGHT = 5;
    public static final int length = 6;

    private PdfPageLayout() {
    }

    public static String getName(int pdfPageLayout) {
        switch (pdfPageLayout) {
            case 0: {
                return "SINGLE_PAGE";
            }
            case 1: {
                return "ONE_COLUMN";
            }
            case 2: {
                return "TWO_COLUMN_LEFT";
            }
            case 3: {
                return "TWO_COLUMN_RIGHT";
            }
            case 4: {
                return "TWO_PAGE_LEFT";
            }
            case 5: {
                return "TWO_PAGE_RIGHT";
            }
        }
        return "Unknown PdfPageLayout value.";
    }

    public static String toString(int pdfPageLayout) {
        switch (pdfPageLayout) {
            case 0: {
                return "SinglePage";
            }
            case 1: {
                return "OneColumn";
            }
            case 2: {
                return "TwoColumnLeft";
            }
            case 3: {
                return "TwoColumnRight";
            }
            case 4: {
                return "TwoPageLeft";
            }
            case 5: {
                return "TwoPageRight";
            }
        }
        return "Unknown PdfPageLayout value.";
    }

    public static int fromName(String pdfPageLayoutName) {
        if ("SINGLE_PAGE".equals(pdfPageLayoutName)) {
            return 0;
        }
        if ("ONE_COLUMN".equals(pdfPageLayoutName)) {
            return 1;
        }
        if ("TWO_COLUMN_LEFT".equals(pdfPageLayoutName)) {
            return 2;
        }
        if ("TWO_COLUMN_RIGHT".equals(pdfPageLayoutName)) {
            return 3;
        }
        if ("TWO_PAGE_LEFT".equals(pdfPageLayoutName)) {
            return 4;
        }
        if ("TWO_PAGE_RIGHT".equals(pdfPageLayoutName)) {
            return 5;
        }
        throw new IllegalArgumentException("Unknown PdfPageLayout name.");
    }

    public static int[] getValues() {
        return new int[]{0, 1, 2, 3, 4, 5};
    }
}

