/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Cell;
import com.aspose.words.CellCollection;
import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.PreferredWidth;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.RowFormat;
import com.aspose.words.Run;
import com.aspose.words.Style;
import com.aspose.words.Table;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.zzVSM;
import com.aspose.words.zzVSy;
import com.aspose.words.zzVWB;
import com.aspose.words.zzWKH;
import com.aspose.words.zzX17;
import com.aspose.words.zzXBe;
import com.aspose.words.zzY72;
import com.aspose.words.zzZ3S;
import com.aspose.words.zzZX1;
import com.aspose.words.zzZmv;
import com.aspose.words.zzZmy;

public class Row
extends CompositeNode<Cell>
implements zzWKH,
zzXBe {
    private int zzXRJ;
    private int zzue;
    private zzVWB zzYJU;
    private RowFormat zz2p;
    private CellCollection zzVZx;

    public Row(DocumentBase doc) {
        this(doc, zzVWB.zzYP8());
    }

    Row(DocumentBase doc, zzVWB rowPr) {
        super(doc);
        this.zzYJU = rowPr;
    }

    @Override
    public int getNodeType() {
        return 6;
    }

    public Table getParentTable() {
        return (Table)this.zzYJ3();
    }

    public boolean isFirstRow() {
        Row row = this;
        return row == row.getParentTable().getFirstRow();
    }

    public boolean isLastRow() {
        Row row = this;
        return row == row.getParentTable().getLastRow();
    }

    final boolean zz4C() {
        if (!this.getRowFormat().getHeadingFormat()) {
            return false;
        }
        return this.isFirstRow() || this.getPreviousRow().zz4C();
    }

    public Row getNextRow() {
        return (Row)this.zzYM5();
    }

    public Row getPreviousRow() {
        return (Row)this.zzRJ();
    }

    final int zzXYU() {
        Table table = this.getParentTable();
        if (table != null) {
            for (int i = 0; i < table.getRows().getCount(); ++i) {
                if (this != table.getRows().get(i)) continue;
                return i;
            }
        }
        return -1;
    }

    public Cell getFirstCell() {
        return (Cell)this.zzYmJ();
    }

    public Cell getLastCell() {
        return (Cell)this.zzY8k();
    }

    public CellCollection getCells() {
        if (this.zzVZx == null) {
            this.zzVZx = new CellCollection(this);
        }
        return this.zzVZx;
    }

    public RowFormat getRowFormat() {
        if (this.zz2p == null) {
            this.zz2p = new RowFormat(this);
        }
        return this.zz2p;
    }

    public boolean getHidden() {
        return this.zzYJU.getHidden();
    }

    public void setHidden(boolean value) {
        this.zzYJU.setHidden(value);
        this.zzYzB(value);
    }

    private void zzYzB(boolean bl) {
        for (Cell cell : this.zzVZx) {
            for (Paragraph paragraph : cell.getParagraphs()) {
                paragraph.zzWty().zzW07(bl ? zzVSy.zzYq8 : zzVSy.zzXh9);
                for (Run run : paragraph.getRuns()) {
                    run.getFont().setHidden(bl);
                }
            }
        }
    }

    final zzVWB zzYwU() {
        return this.zzYJU;
    }

    final void zzW07(zzVWB zzVWB2) {
        this.zzYJU = zzVWB2;
    }

    final boolean zzZpY() {
        PreferredWidth preferredWidth = this.zzWJF();
        return preferredWidth != null && preferredWidth.zzXJr();
    }

    final int zzWKC() {
        if (this.zzZpY()) {
            return Math.max(this.zzWJF().zzXw3(), 0);
        }
        return 0;
    }

    private PreferredWidth zzWJF() {
        PreferredWidth preferredWidth = (PreferredWidth)this.getDirectRowAttr(4290);
        if (preferredWidth == null) {
            TableStyle tableStyle = zzVUI.zzW07((Object)this.getParentTable().getStyle(), TableStyle.class);
            while (tableStyle != null && (preferredWidth = (PreferredWidth)tableStyle.getDirectRowAttr(4290)) == null) {
                tableStyle = zzVUI.zzW07((Object)tableStyle.zzX9G(), TableStyle.class);
            }
        }
        return preferredWidth;
    }

    final void zzZtp() {
        Row row = this;
        if (row.zzYJU.zzu4(4005)) {
            row = this;
            Style style = this.getDocument().getStyles().zzZnz(row.zzYJU.zzVRc(), false);
            if (style == null || style.getType() != 3) {
                row = this;
                row.zzYJU.zzWS1(11);
            }
        }
    }

    @Override
    final Node zzW07(boolean bl, zzZmy zzZmy2) {
        Row row = (Row)super.zzW07(bl, zzZmy2);
        zzVWB zzVWB2 = this.zzYJU;
        ((Row)super.zzW07(bl, zzZmy2)).zzYJU = (zzVWB)zzVWB2.zzWMc();
        row.zz2p = null;
        row.zzVZx = null;
        return row;
    }

    final boolean zzZ1M(Row row) {
        Paragraph paragraph;
        Paragraph paragraph2;
        Cell cell;
        Cell cell2;
        Row row2 = this;
        Row row3 = row2;
        row3 = row;
        if (!row2.zzYJU.zzWD3(row3.zzYJU)) {
            return false;
        }
        row3 = this;
        if (!row3.zzYJU.zzZ7w() && !this.getParentTable().zzXBW() && zzVUI.zzYET(cell2 = this.getFirstCell(), cell = row.getFirstCell()) && zzVUI.zzYET(paragraph2 = (Paragraph)cell2.getChild(8, 0, true), paragraph = (Paragraph)cell.getChild(8, 0, true))) {
            zzX17 zzX172 = paragraph2.zzWrK(265);
            zzX17 zzX173 = paragraph.zzWrK(265);
            return zzX172.zzYET(zzX173);
        }
        return true;
    }

    final void zz7L() {
        Table table = this.getParentTable();
        Table table2 = new Table(table.getDocument());
        table.zzYUr(table2);
        Node node = this;
        while (node != null) {
            Node node2 = node.getNextSibling();
            node.remove();
            table2.zzad(node);
            node = node2;
        }
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    public int acceptStart(DocumentVisitor visitor) throws Exception {
        return visitor.visitRowStart(this);
    }

    @Override
    public int acceptEnd(DocumentVisitor visitor) throws Exception {
        return visitor.visitRowEnd(this);
    }

    @Override
    public String getText() {
        return super.getText();
    }

    public void ensureMinimum() {
        Cell cell = this.getFirstCell();
        if (cell == null) {
            cell = this.appendChild(new Cell(this.getDocument()));
        }
        cell.ensureMinimum();
    }

    @Override
    final String zzWbE() {
        return ControlChar.CELL;
    }

    @Override
    final boolean zzm1(Node node) {
        return zzZmv.zzXjr(node);
    }

    final void zzW07(CellCollection cellCollection) {
        this.getCells().getCount();
        cellCollection.getCount();
        for (int i = 0; i < cellCollection.getCount(); ++i) {
            zzVSM zzVSM2 = this.getCells().get(i).zzXnV();
            if (zzVSM2 == null) continue;
            zzVSM zzVSM3 = zzVSM2;
            cellCollection.get(i).zzW07((zzVSM)zzVSM3.zzWMc());
        }
    }

    final void zzXuv() {
        for (Paragraph paragraph : this.getChildNodes(8, true)) {
            paragraph.zzYC7().zzZaI();
        }
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectRowAttr(int key) {
        return this.zzYJU.zzXa9(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchRowAttr(int key) {
        Object object = this.zzYJU.get(key);
        if (object != null) {
            return object;
        }
        return this.fetchInheritedRowAttr(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedRowAttr(int key) {
        TableStyle tableStyle;
        if (this.getParentTable() != null && (tableStyle = zzVUI.zzW07((Object)this.getParentTable().getStyle(), TableStyle.class)) != null) {
            return tableStyle.fetchRowAttr(key);
        }
        return zzVWB.zzZs3(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setRowAttr(int key, Object value) {
        this.zzYJU.zzZKJ(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearRowAttrs() {
        this.zzYJU.clear();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void resetToDefaultAttrs() throws Exception {
        this.zzYJU.resetToDefaultAttrs();
    }

    final void zztv() {
        if (!this.getDocument().zz9w().zzwm.zzWcJ()) {
            return;
        }
        Row row = this;
        if (row.zzYJU.getAlignment() != 0) {
            row = this;
            row.zzYJU.remove(4340);
        }
        row = this;
        if (row.zzYJU.zz5L()) {
            int n;
            row = this;
            zzVWB zzVWB2 = (zzVWB)row.zzYJU.zzXqW().zzXZk();
            if (zzVWB2.zzZ4H(4010)) {
                n = zzVWB2.getAlignment();
            } else {
                int n2;
                row = this;
                n = n2 = row.zzYJU.getAlignment();
            }
            if (n != 0) {
                zzVWB2.remove(4340);
            }
        }
    }

    final int zzZx3() {
        return this.zzXRJ;
    }

    final void zzZit(int n) {
        this.zzXRJ = n;
    }

    final int zzX9k() {
        return this.zzue;
    }

    final void zzWq1(int n) {
        this.zzue = n;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ3S getInsertRevision() {
        Row row = this;
        return row.zzYJU.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZ3S value) {
        Cloneable cloneable = this;
        zzZ3S zzZ3S2 = value;
        cloneable = cloneable.zzYJU;
        ((zzZX1)cloneable).zzZKJ(14, zzZ3S2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ3S getDeleteRevision() {
        Row row = this;
        return row.zzYJU.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZ3S value) {
        Cloneable cloneable = this;
        zzZ3S zzZ3S2 = value;
        cloneable = cloneable.zzYJU;
        ((zzZX1)cloneable).zzZKJ(12, zzZ3S2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzY72 getMoveFromRevision() {
        Row row = this;
        return row.zzYJU.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzY72 value) {
        Cloneable cloneable = this;
        zzY72 zzY722 = value;
        cloneable = cloneable.zzYJU;
        ((zzZX1)cloneable).zzZKJ(13, zzY722);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzY72 getMoveToRevision() {
        Row row = this;
        return row.zzYJU.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzY72 value) {
        Cloneable cloneable = this;
        zzY72 zzY722 = value;
        cloneable = cloneable.zzYJU;
        ((zzZX1)cloneable).zzZKJ(15, zzY722);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Row row = this;
        row.zzYJU.remove(13);
        row = this;
        row.zzYJU.remove(15);
    }
}

