/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CompositeNode;
import com.aspose.words.ControlChar;
import com.aspose.words.Document;
import com.aspose.words.FileFormatUtil;
import com.aspose.words.FixedPageSaveOptions;
import com.aspose.words.IDocumentProcessorPlugin;
import com.aspose.words.ImportFormatOptions;
import com.aspose.words.Node;
import com.aspose.words.NodeImporter;
import com.aspose.words.PageSet;
import com.aspose.words.Paragraph;
import com.aspose.words.Processor;
import com.aspose.words.Run;
import com.aspose.words.SaveOptions;
import com.aspose.words.Section;
import com.aspose.words.SplitOptions;
import com.aspose.words.SplitterContext;
import com.aspose.words.internal.zzLu;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzWbT;
import com.aspose.words.internal.zzWoj;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzYb3;
import com.aspose.words.internal.zzZTE;
import com.aspose.words.internal.zzZfS;
import com.aspose.words.internal.zzZlO;
import com.aspose.words.internal.zzpV;
import com.aspose.words.zzY7S;
import com.aspose.words.zzZmv;
import com.aspose.words.zzr1;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Splitter
extends Processor {
    private SplitterContext zzYcR;

    private Splitter(SplitterContext context) {
        super(context);
        this.zzYcR = context;
    }

    public static Splitter create(SplitterContext context) {
        return new Splitter(context);
    }

    @Override
    protected void executeCore() throws Exception {
        switch (this.zzYcR.getSplitOptions().getSplitCriteria()) {
            case 0: {
                zzXTI[] zzXTIArray;
                Object object;
                zzLu<zzY7S> zzLu2;
                if (this.zzWrJ().zzZue() == 36 && (zzLu2 = this.zzYZ2()).size() > 0) {
                    object = new zzr1();
                    this.zzWrJ().zzW07((IDocumentProcessorPlugin)object);
                    while ((zzLu2 = this.zzYZ2()).size() > 0) {
                        zzXTIArray = (zzXTI[])this.zzYZ2().pop();
                        zzXTI[] zzXTIArray2 = object.toPagesInternal((FixedPageSaveOptions)zzXTIArray.zzDL());
                        zzXTIArray.zzYIm(zzXTIArray2);
                    }
                    zzLu2 = this.zzWC4();
                    if (zzLu2.size() > 0) {
                        this.mResultDocument = object.toDocument();
                    }
                }
                if ((zzLu2 = this.zzWC4()).size() > 0) {
                    if (this.mResultDocument == null) {
                        this.mResultDocument = this.zzWrJ().zzZD7();
                    }
                    object = Splitter.zzWf8(this.mResultDocument);
                    while ((zzLu2 = this.zzWC4()).size() > 0) {
                        zzXTIArray = (zzY7S)this.zzWC4().pop();
                        zzXTIArray.zzW07((Document[])object);
                    }
                }
                if ((zzLu2 = this.zzYZ2()).size() <= 0) break;
                if (this.mResultDocument == null) {
                    this.mResultDocument = this.zzWrJ().zzZD7();
                }
                while ((zzLu2 = this.zzYZ2()).size() > 0) {
                    object = (zzY7S)this.zzYZ2().pop();
                    zzXTIArray = Splitter.zzW07(this.mResultDocument, (FixedPageSaveOptions)((zzY7S)object).zzDL());
                    ((zzY7S)object).zzYIm(zzXTIArray);
                }
                break;
            }
            case 1: {
                if (this.mResultDocument == null) {
                    this.mResultDocument = this.zzWrJ().zzZD7();
                }
                Document[] documentArray = Splitter.zzw4(this.mResultDocument);
                this.zzYQ4(documentArray);
                return;
            }
            case 2: {
                if (this.mResultDocument == null) {
                    this.mResultDocument = this.zzWrJ().zzZD7();
                }
                Document[] documentArray = Splitter.zzWql(this.mResultDocument, this.zzYcR.getSplitOptions().getSplitStyle());
                this.zzYQ4(documentArray);
            }
        }
    }

    private void zzYQ4(Document[] documentArray) throws Exception {
        zzY7S zzY7S2;
        zzLu<zzY7S> zzLu2;
        while ((zzLu2 = this.zzWC4()).size() > 0) {
            zzY7S2 = (zzY7S)this.zzWC4().pop();
            zzY7S2.zzW07(documentArray);
        }
        while ((zzLu2 = this.zzYZ2()).size() > 0) {
            zzY7S2 = (zzY7S)this.zzYZ2().pop();
            zzY7S2.zzW07(documentArray);
        }
    }

    public static ArrayList<Integer> removeBlankPages(String inputFileName, String outputFileName) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(outputFileName));
        return Splitter.removeBlankPages(inputFileName, outputFileName, n);
    }

    public static ArrayList<Integer> removeBlankPages(String inputFileName, String outputFileName, int saveFormat) throws Exception {
        return Splitter.removeBlankPages(inputFileName, outputFileName, zzZmv.zzyp(saveFormat, outputFileName));
    }

    public static ArrayList<Integer> removeBlankPages(String inputFileName, String outputFileName, SaveOptions saveOptions) throws Exception {
        String string = zzZTE.zzVWa(outputFileName);
        if (zzpV.zzZY9(string) && !zzWbT.zzYPT(string)) {
            zzWbT.zzXAc(string);
        }
        try (zzYb3 zzYb32 = zzVUI.zzY3k(inputFileName);){
            ArrayList<Integer> arrayList;
            zzYb3 zzYb33 = zzVUI.zzX2q(outputFileName);
            try {
                arrayList = Splitter.zzW07((zzXTI)zzYb32, zzYb33, saveOptions);
            }
            catch (Throwable throwable) {
                ((zzXTI)zzYb33).close();
                throw throwable;
            }
            ((zzXTI)zzYb33).close();
            return arrayList;
        }
    }

    private static ArrayList<Integer> zzYQ4(zzXTI zzXTI2, zzXTI zzXTI3, int n) throws Exception {
        return Splitter.zzW07(zzXTI2, zzXTI3, zzZmv.zzyp(n, null));
    }

    public static ArrayList<Integer> removeBlankPages(InputStream inputStream, OutputStream outputStream, int saveFormat) throws Exception {
        return Splitter.zzYQ4(zzXTI.zzYQ4(inputStream), zzXTI.zzYIm(outputStream), saveFormat);
    }

    private static ArrayList<Integer> zzW07(zzXTI zzXTI2, zzXTI zzXTI3, SaveOptions saveOptions) throws Exception {
        Document document = new Document(zzXTI2);
        ArrayList<Integer> arrayList = document.removeBlankPages();
        document.zzW07(zzXTI3, saveOptions);
        return arrayList;
    }

    public static ArrayList<Integer> removeBlankPages(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions) throws Exception {
        return Splitter.zzW07(zzXTI.zzYQ4(inputStream), zzXTI.zzYIm(outputStream), saveOptions);
    }

    public static void extractPages(String inputFileName, String outputFileName, int startPageIndex, int pageCount) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(outputFileName));
        Splitter.extractPages(inputFileName, outputFileName, n, startPageIndex, pageCount);
    }

    public static void extractPages(String inputFileName, String outputFileName, int saveFormat, int startPageIndex, int pageCount) throws Exception {
        Splitter.extractPages(inputFileName, outputFileName, zzZmv.zzyp(saveFormat, outputFileName), startPageIndex, pageCount);
    }

    public static void extractPages(String inputFileName, String outputFileName, SaveOptions saveOptions, int startPageIndex, int pageCount) throws Exception {
        String string = zzZTE.zzVWa(outputFileName);
        if (zzpV.zzZY9(string) && !zzWbT.zzYPT(string)) {
            zzWbT.zzXAc(string);
        }
        try (zzYb3 zzYb32 = zzVUI.zzY3k(inputFileName);){
            try (zzYb3 zzYb33 = zzVUI.zzX2q(outputFileName);){
                Splitter.zzW07((zzXTI)zzYb32, (zzXTI)zzYb33, saveOptions, startPageIndex, pageCount);
            }
            return;
        }
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, int n, int n2, int n3) throws Exception {
        Splitter.zzW07(zzXTI2, zzXTI3, zzZmv.zzyp(n, null), n2, n3);
    }

    public static void extractPages(InputStream inputStream, OutputStream outputStream, int saveFormat, int startPageIndex, int pageCount) throws Exception {
        Splitter.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveFormat, startPageIndex, pageCount);
    }

    private static void zzW07(zzXTI zzXTI2, zzXTI zzXTI3, SaveOptions saveOptions, int n, int n2) throws Exception {
        Document document = new Document(zzXTI2);
        document.extractPages(n, n2).zzW07(zzXTI3, saveOptions);
    }

    public static void extractPages(InputStream inputStream, OutputStream outputStream, SaveOptions saveOptions, int startPageIndex, int pageCount) throws Exception {
        Splitter.zzW07(zzXTI.zzYQ4(inputStream), (zzXTI)zzXTI.zzYIm(outputStream), saveOptions, startPageIndex, pageCount);
    }

    public static void split(String inputFileName, String outputFileName, SplitOptions options) throws Exception {
        int n = FileFormatUtil.extensionToSaveFormat(zzZTE.zzZNB(outputFileName));
        Splitter.split(inputFileName, outputFileName, n, options);
    }

    public static void split(String inputFileName, String outputFileName, int saveFormat, SplitOptions options) throws Exception {
        Splitter.split(inputFileName, outputFileName, zzZmv.zzyp(saveFormat, outputFileName), options);
    }

    public static void split(String inputFileName, String outputFileName, SaveOptions saveOptions, SplitOptions options) throws Exception {
        SplitterContext splitterContext = new SplitterContext(options);
        Splitter.create(splitterContext).from(inputFileName).to(outputFileName).execute();
    }

    private static zzXTI[] zzW07(zzXTI zzXTI2, int n, SplitOptions splitOptions) throws Exception {
        return Splitter.zzW07(zzXTI2, zzZmv.zzyp(n, null), splitOptions);
    }

    public static OutputStream[] split(InputStream inputStream, int saveFormat, SplitOptions options) throws Exception {
        return zzXTI.zzYQ4(Splitter.zzW07(zzXTI.zzYQ4(inputStream), saveFormat, options));
    }

    private static zzXTI[] zzW07(zzXTI zzXTI2, SaveOptions saveOptions, SplitOptions splitOptions) throws Exception {
        SplitterContext splitterContext = new SplitterContext(splitOptions);
        ArrayList<zzXTI> arrayList = new ArrayList<zzXTI>();
        Splitter.create(splitterContext).zzoH(zzXTI2).to(arrayList, saveOptions).execute();
        zzXTI[] zzXTIArray = new zzXTI[]{};
        ArrayList<zzXTI> arrayList2 = arrayList;
        return arrayList2.toArray(zzXTIArray);
    }

    public static OutputStream[] split(InputStream inputStream, SaveOptions saveOptions, SplitOptions options) throws Exception {
        return zzXTI.zzYQ4(Splitter.zzW07(zzXTI.zzYQ4(inputStream), saveOptions, options));
    }

    private static zzXTI[] zzW07(Document document, FixedPageSaveOptions fixedPageSaveOptions) throws Exception {
        int n = document.getPageCount();
        zzXTI[] zzXTIArray = new zzXTI[n];
        for (int i = 0; i < n; ++i) {
            zzXTIArray[i] = new zzZfS();
            fixedPageSaveOptions.setPageSet(new PageSet(i));
            document.zzW07(zzXTIArray[i], fixedPageSaveOptions);
        }
        return zzXTIArray;
    }

    private static Document[] zzWf8(Document document) throws Exception {
        int n = document.getPageCount();
        Document[] documentArray = new Document[n];
        for (int i = 0; i < n; ++i) {
            documentArray[i] = document.extractPages(i, 1);
        }
        return documentArray;
    }

    private static Document[] zzw4(Document document) {
        Document[] documentArray = new Document[document.getSections().getCount()];
        for (int i = 0; i < document.getSections().getCount(); ++i) {
            Section section = document.getSections().get(i);
            Document document2 = (Document)document.deepClone(false);
            document2.appendChild(document2.importNode(section, true, 0));
            documentArray[i] = document2;
        }
        return documentArray;
    }

    private static Document[] zzWql(Document document, String string) {
        ImportFormatOptions importFormatOptions = new ImportFormatOptions();
        importFormatOptions.setKeepSourceNumbering(true);
        ArrayList arrayList = new ArrayList();
        Document document2 = (Document)document.deepClone(false);
        NodeImporter nodeImporter = new NodeImporter(document, document2, 0, importFormatOptions);
        zzZlO.zzW07(arrayList, document2);
        for (CompositeNode compositeNode : document.getSections()) {
            Section section = (Section)nodeImporter.importNode(compositeNode, true);
            section.getBody().removeAllChildren();
            document2.appendChild(section);
            for (Node node : ((Section)compositeNode).getBody().getChildNodes(0, false)) {
                Paragraph paragraph;
                if (node != ((Section)compositeNode).getBody().getFirstChild() && node.getNodeType() == 8 && zzWoj.zzXxP((paragraph = (Paragraph)node).getParagraphFormat().getStyleName(), string)) {
                    document2 = (Document)document.deepClone(false);
                    nodeImporter = new NodeImporter(document, document2, 0, importFormatOptions);
                    zzZlO.zzW07(arrayList, document2);
                    section = (Section)nodeImporter.importNode(compositeNode, true);
                    section.getBody().removeAllChildren();
                    document2.appendChild(section);
                }
                section.getBody().appendChild(nodeImporter.importNode(node, true));
            }
        }
        for (CompositeNode compositeNode : arrayList) {
            while (((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild() != null && ((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild().getNodeType() == 21 && zzWoj.zzXxP(((Run)((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild()).getText(), ControlChar.PAGE_BREAK)) {
                ((Document)compositeNode).getLastSection().getBody().getLastParagraph().getLastChild().remove();
            }
        }
        Document[] documentArray = new Document[]{};
        ArrayList arrayList2 = arrayList;
        return arrayList2.toArray(documentArray);
    }
}

