/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.Document;
import com.aspose.words.DocumentBase;
import com.aspose.words.ImageWatermarkOptions;
import com.aspose.words.PageSetup;
import com.aspose.words.Shape;
import com.aspose.words.TextWatermarkOptions;
import com.aspose.words.internal.zzVUI;
import com.aspose.words.internal.zzWoj;
import com.aspose.words.internal.zzXTI;
import com.aspose.words.internal.zzXW8;
import com.aspose.words.internal.zzYJ7;
import com.aspose.words.internal.zzZYg;
import com.aspose.words.internal.zzpV;
import com.aspose.words.zzZhW;
import java.awt.image.BufferedImage;
import java.io.InputStream;

public final class Watermark {
    private Document zzZhu;
    private zzZhW zzZNF;

    Watermark(Document doc, zzZhW watermarkProvider) {
        this.zzZhu = doc;
        this.zzZNF = watermarkProvider;
    }

    public final void setText(String text) throws Exception {
        this.setText(text, new TextWatermarkOptions());
    }

    public final void setText(String text, TextWatermarkOptions options) throws Exception {
        Watermark.zzW7u(text);
        TextWatermarkOptions textWatermarkOptions = options == null ? new TextWatermarkOptions() : options;
        Shape shape = this.zzW07(text, textWatermarkOptions, this.zzZhu);
        this.add(shape);
    }

    public final void setImage(BufferedImage image) throws Exception {
        this.setImage(image, new ImageWatermarkOptions());
    }

    public final void setImage(BufferedImage image, ImageWatermarkOptions options) throws Exception {
        zzVUI.zzYQ4((Object)image, "image");
        Shape shape = new Shape((DocumentBase)this.zzZhu, 75);
        shape.getImageData().setImage(image);
        this.zzW07(shape, options, this.zzZhu);
    }

    public final void setImage(String imagePath, ImageWatermarkOptions options) throws Exception {
        zzVUI.zzYQ4((Object)imagePath, "imagePath");
        Shape shape = new Shape((DocumentBase)this.zzZhu, 75);
        shape.getImageData().setImage(imagePath);
        this.zzW07(shape, options, this.zzZhu);
    }

    final void zzW07(zzXTI zzXTI2, ImageWatermarkOptions imageWatermarkOptions) throws Exception {
        zzVUI.zzYQ4((Object)zzXTI2, "imageStream");
        Shape shape = new Shape((DocumentBase)this.zzZhu, 75);
        shape.getImageData().zzZ2E(zzXTI2);
        this.zzW07(shape, imageWatermarkOptions, this.zzZhu);
    }

    public final void setImage(InputStream imageStream, ImageWatermarkOptions options) throws Exception {
        this.zzW07(zzXTI.zzYQ4(imageStream), options);
    }

    public final int getType() {
        Shape shape = this.zzZNF.get();
        if (shape == null) {
            return 2;
        }
        shape.zzWW();
        if (shape.zzYNz()) {
            return 0;
        }
        if (shape.zzYIZ()) {
            return 1;
        }
        return 2;
    }

    private void add(Shape shape) throws Exception {
        this.remove();
        this.zzZNF.add(shape);
    }

    public final void remove() {
        this.zzZNF.remove();
    }

    private static void zzW7u(String string) {
        if (string == null) {
            throw new NullPointerException("Value cannot be null.\r\nParameter name: text");
        }
        if (zzpV.zzXCY(string)) {
            throw new IllegalArgumentException("Specified argument was out of the range of valid values.\r\nParameter name: text");
        }
        zzVUI.zzW07(string.length(), 0.0, 0.0, 200.0, 200.0, true, "text");
    }

    private void zzW07(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        if (imageWatermarkOptions == null) {
            imageWatermarkOptions = new ImageWatermarkOptions();
        }
        Watermark.zzYQ4(shape, imageWatermarkOptions, document);
        if (imageWatermarkOptions.isWashout()) {
            shape.getImageData().setContrast(0.15);
            shape.getImageData().setBrightness(0.85);
        }
        Watermark.zzXhM(shape, "WordPictureWatermark");
        this.add(shape);
    }

    private static void zzYQ4(Shape shape, ImageWatermarkOptions imageWatermarkOptions, Document document) throws Exception {
        float f;
        PageSetup pageSetup;
        float f2;
        double d = imageWatermarkOptions.getScale();
        double d2 = shape.getImageData().getImageSize().getWidthPoints();
        double d3 = shape.getImageData().getImageSize().getHeightPoints();
        if (imageWatermarkOptions.zzZY7() && d3 * (d = (double)(f2 = (pageSetup = document.getFirstSection().getPageSetup()).zzXTF()) / d2) > (double)(f = pageSetup.zzNy())) {
            d = (double)f / d3;
        }
        shape.zzXJS(zzZYg.zzYIm(d2 * d, 2, 1));
        shape.zzZ7Z(zzZYg.zzYIm(d3 * d, 2, 1));
    }

    private Shape zzW07(String string, TextWatermarkOptions textWatermarkOptions, Document document) {
        Shape shape = new Shape((DocumentBase)document, 136);
        shape.getTextPath().setText(string);
        shape.getTextPath().setFontFamily(textWatermarkOptions.getFontFamily());
        shape.setRotation(textWatermarkOptions.getLayout());
        if (textWatermarkOptions.isSemitrasparent()) {
            shape.getFill().setOpacity(0.5);
        }
        this.zzW07(shape, textWatermarkOptions, document);
        shape.getFill().setForeColor(textWatermarkOptions.getColor());
        shape.setStrokeColor(textWatermarkOptions.getColor());
        shape.getFont().setSize(1.0);
        Watermark.zzXhM(shape, "PowerPlusWaterMarkObject");
        return shape;
    }

    private void zzW07(Shape shape, TextWatermarkOptions textWatermarkOptions, Document document) {
        float f = textWatermarkOptions.zzZZz() ? 1.0f : textWatermarkOptions.getFontSize();
        zzYJ7 zzYJ72 = document.zzXWe().zzYIm(shape.getTextPath().getFontFamily(), f, 0);
        long l = zzYJ72.zzYOb(shape.getTextPath().getText());
        if (textWatermarkOptions.zzZZz()) {
            l = Watermark.zzW07(l, textWatermarkOptions, document);
        }
        long l2 = l;
        int n = (int)l2;
        shape.zzXJS(zzZYg.zzYIm(Float.intBitsToFloat(n), 2, 1));
        shape.zzZ7Z(zzZYg.zzYIm(zzXW8.zzWQL(l), 2, 1));
    }

    private static long zzW07(long l, TextWatermarkOptions textWatermarkOptions, Document document) {
        int n;
        PageSetup pageSetup = document.getFirstSection().getPageSetup();
        float f = pageSetup.zzXTF();
        float f2 = pageSetup.zzNy();
        long l2 = l;
        int n2 = (int)l2;
        float f3 = zzXW8.zzWQL(l) / Float.intBitsToFloat(n2);
        if (textWatermarkOptions.getLayout() == 315) {
            float f4 = Math.min(f2, f);
            float f5 = f4 * (float)Math.sqrt(2.0) / (f3 + 1.0f);
            return zzXW8.zzKA(f5, f5 * f3);
        }
        l2 = l;
        n2 = (int)l2;
        if (zzXW8.zzWQL(l) >= Float.intBitsToFloat(n)) {
            return zzXW8.zzKA(f2 / f3, f2);
        }
        float f6 = f;
        return zzXW8.zzKA(f6, f6 * f3);
    }

    private static void zzXhM(Shape shape, String string) {
        shape.setName(zzWoj.zzYQ4("{0}{1}", string, shape.getId()));
        shape.setRelativeHorizontalPosition(0);
        shape.setRelativeVerticalPosition(0);
        shape.setWrapType(3);
        shape.setVerticalAlignment(2);
        shape.setHorizontalAlignment(2);
        shape.setBehindText(true);
    }
}

