/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words.internal;

import com.aspose.words.internal.zz80;
import com.aspose.words.internal.zz9x;
import com.aspose.words.internal.zzII;
import com.aspose.words.internal.zzW1E;
import com.aspose.words.internal.zzW8S;
import com.aspose.words.internal.zzW9n;
import com.aspose.words.internal.zzWJl;
import com.aspose.words.internal.zzWXm;
import com.aspose.words.internal.zzWpw;
import com.aspose.words.internal.zzX5C;
import com.aspose.words.internal.zzXD4;
import com.aspose.words.internal.zzXN8;
import com.aspose.words.internal.zzXql;
import com.aspose.words.internal.zzXtf;
import com.aspose.words.internal.zzXv4;
import com.aspose.words.internal.zzY2;
import com.aspose.words.internal.zzYOe;
import com.aspose.words.internal.zzYah;
import com.aspose.words.internal.zzYbA;
import com.aspose.words.internal.zzYkD;
import com.aspose.words.internal.zzYsH;
import com.aspose.words.internal.zzZ7A;
import com.aspose.words.internal.zzZ8L;
import com.aspose.words.internal.zzZDj;
import com.aspose.words.internal.zzZQw;
import com.aspose.words.internal.zzZT1;
import com.aspose.words.internal.zzZV;
import com.aspose.words.internal.zzZn3;
import com.aspose.words.internal.zzZur;
import com.aspose.words.internal.zzf1;
import com.aspose.words.internal.zzgz;
import com.aspose.words.internal.zzus;
import com.aspose.words.internal.zzvQ;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

abstract class zzXk5
extends X509Certificate {
    protected zzYbA zzZAZ;
    protected zzZ8L zzYRF;
    protected zzZ7A zzYYo;
    protected boolean[] zzX1Y;
    protected String zzXwW;
    protected byte[] zzVRX;

    zzXk5(zzYbA zzYbA2, zzZ8L zzZ8L2, zzZ7A zzZ7A2, boolean[] blArray, String string, byte[] byArray) {
        this.zzZAZ = zzYbA2;
        this.zzYRF = zzZ8L2;
        this.zzYYo = zzZ7A2;
        this.zzX1Y = blArray;
        this.zzXwW = string;
        this.zzVRX = byArray;
    }

    public final zzWJl zzY2v() {
        return this.zzYRF.zzZ3C();
    }

    public final zzZDj zzYtq() {
        return this.zzYRF.zzYxc();
    }

    public final zzWJl zzZcd() {
        return this.zzYRF.zzXG5();
    }

    @Override
    public void checkValidity() throws CertificateExpiredException, CertificateNotYetValidException {
        this.checkValidity(new Date());
    }

    @Override
    public void checkValidity(Date date) throws CertificateExpiredException, CertificateNotYetValidException {
        if (date.getTime() > this.getNotAfter().getTime()) {
            throw new CertificateExpiredException("certificate expired on " + this.zzYRF.zzZKH().zzZy0());
        }
        if (date.getTime() < this.getNotBefore().getTime()) {
            throw new CertificateNotYetValidException("certificate not valid till " + this.zzYRF.zzYhZ().zzZy0());
        }
    }

    @Override
    public int getVersion() {
        return this.zzYRF.zztJ();
    }

    @Override
    public BigInteger getSerialNumber() {
        return this.zzYRF.zzX1A().zzVh();
    }

    @Override
    public Principal getIssuerDN() {
        return this.getIssuerX500Principal();
    }

    @Override
    public X500Principal getIssuerX500Principal() {
        try {
            byte[] byArray = this.zzYRF.zzZ3C().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode issuer DN");
        }
    }

    @Override
    public Principal getSubjectDN() {
        return this.getSubjectX500Principal();
    }

    @Override
    public X500Principal getSubjectX500Principal() {
        try {
            byte[] byArray = this.zzYRF.zzXG5().getEncoded("DER");
            return new X500Principal(byArray);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("can't encode subject DN");
        }
    }

    @Override
    public Date getNotBefore() {
        return this.zzYRF.zzYhZ().zzYZi();
    }

    @Override
    public Date getNotAfter() {
        return this.zzYRF.zzZKH().zzYZi();
    }

    @Override
    public byte[] getTBSCertificate() throws CertificateEncodingException {
        try {
            return this.zzYRF.zzYxc().getEncoded("DER");
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
    }

    @Override
    public byte[] getSignature() {
        return this.zzYRF.zzWv7().zzXWx();
    }

    @Override
    public String getSigAlgName() {
        return this.zzXwW;
    }

    @Override
    public String getSigAlgOID() {
        return this.zzYRF.zzVOz().zzWeX().getId();
    }

    @Override
    public byte[] getSigAlgParams() {
        return zzX5C.zzac(this.zzVRX);
    }

    @Override
    public boolean[] getIssuerUniqueID() {
        zzYah zzYah2 = this.zzYRF.zzYxc().zzXgC();
        if (zzYah2 != null) {
            byte[] byArray = zzYah2.zz7u();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzYah2.zzWnv()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getSubjectUniqueID() {
        zzYah zzYah2 = this.zzYRF.zzYxc().zzTN();
        if (zzYah2 != null) {
            byte[] byArray = zzYah2.zz7u();
            boolean[] blArray = new boolean[(byArray.length << 3) - zzYah2.zzWnv()];
            for (int i = 0; i != blArray.length; ++i) {
                blArray[i] = (byArray[i / 8] & 128 >>> i % 8) != 0;
            }
            return blArray;
        }
        return null;
    }

    @Override
    public boolean[] getKeyUsage() {
        return zzX5C.zzWql(this.zzX1Y);
    }

    public List getExtendedKeyUsage() throws CertificateParsingException {
        byte[] byArray = zzXk5.zzYQ4(this.zzYRF, "2.5.29.37");
        if (byArray == null) {
            return null;
        }
        try {
            zzII zzII2 = zzII.zzZQl(zzus.zzZIS(byArray));
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i != zzII2.size(); ++i) {
                arrayList.add(((zzYkD)zzII2.zzYzH(i)).getId());
            }
            return Collections.unmodifiableList(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException("error processing extended key usage extension");
        }
    }

    @Override
    public int getBasicConstraints() {
        if (this.zzYYo != null) {
            if (this.zzYYo.zzSE()) {
                if (this.zzYYo.zzZFy() == null) {
                    return Integer.MAX_VALUE;
                }
                return this.zzYYo.zzZFy().intValue();
            }
            return -1;
        }
        return -1;
    }

    public Collection getSubjectAlternativeNames() throws CertificateParsingException {
        return zzXk5.zzW07(this.zzYRF, zz80.zzYDV.getId());
    }

    public Collection getIssuerAlternativeNames() throws CertificateParsingException {
        return zzXk5.zzW07(this.zzYRF, zz80.zzVZF.getId());
    }

    public Set getCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzgz zzgz2 = this.zzYRF.zzYxc().zzY68();
            if (zzgz2 != null) {
                Enumeration enumeration = zzgz2.zzXtN();
                while (enumeration.hasMoreElements()) {
                    zzYkD zzYkD2 = (zzYkD)enumeration.nextElement();
                    zz80 zz802 = zzgz2.zzXfE(zzYkD2);
                    if (!zz802.isCritical()) continue;
                    hashSet.add(zzYkD2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public byte[] getExtensionValue(String oid) {
        zzY2 zzY22 = zzXk5.zzYIm(this.zzYRF, oid);
        if (zzY22 != null) {
            try {
                return zzY22.getEncoded();
            }
            catch (Exception exception) {
                throw new IllegalStateException("error parsing " + exception.toString());
            }
        }
        return null;
    }

    public Set getNonCriticalExtensionOIDs() {
        if (this.getVersion() == 3) {
            HashSet<String> hashSet = new HashSet<String>();
            zzgz zzgz2 = this.zzYRF.zzYxc().zzY68();
            if (zzgz2 != null) {
                Enumeration enumeration = zzgz2.zzXtN();
                while (enumeration.hasMoreElements()) {
                    zzYkD zzYkD2 = (zzYkD)enumeration.nextElement();
                    zz80 zz802 = zzgz2.zzXfE(zzYkD2);
                    if (zz802.isCritical()) continue;
                    hashSet.add(zzYkD2.getId());
                }
                return hashSet;
            }
        }
        return null;
    }

    @Override
    public boolean hasUnsupportedCriticalExtension() {
        zzgz zzgz2;
        if (this.getVersion() == 3 && (zzgz2 = this.zzYRF.zzYxc().zzY68()) != null) {
            Enumeration enumeration = zzgz2.zzXtN();
            while (enumeration.hasMoreElements()) {
                zz80 zz802;
                zzYkD zzYkD2 = (zzYkD)enumeration.nextElement();
                if (zzYkD2.zzYQ4(zz80.zzXjP) || zzYkD2.zzYQ4(zz80.zzWpO) || zzYkD2.zzYQ4(zz80.zzYRi) || zzYkD2.zzYQ4(zz80.zzWB0) || zzYkD2.zzYQ4(zz80.zzX2Q) || zzYkD2.zzYQ4(zz80.zz4w) || zzYkD2.zzYQ4(zz80.zz6f) || zzYkD2.zzYQ4(zz80.zzj9) || zzYkD2.zzYQ4(zz80.zzZTN) || zzYkD2.zzYQ4(zz80.zzYDV) || zzYkD2.zzYQ4(zz80.zzVWG) || !(zz802 = zzgz2.zzXfE(zzYkD2)).isCritical()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public PublicKey getPublicKey() {
        try {
            return this.zzZAZ.zzY6t(this.zzYRF.zznr());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = zzYsH.zzZbu();
        stringBuffer.append("  [0]         Version: ").append(this.getVersion()).append(string);
        stringBuffer.append("         SerialNumber: ").append(this.getSerialNumber()).append(string);
        stringBuffer.append("             IssuerDN: ").append(this.getIssuerDN()).append(string);
        stringBuffer.append("           Start Date: ").append(this.getNotBefore()).append(string);
        stringBuffer.append("           Final Date: ").append(this.getNotAfter()).append(string);
        stringBuffer.append("            SubjectDN: ").append(this.getSubjectDN()).append(string);
        stringBuffer.append("           Public Key: ").append(this.getPublicKey()).append(string);
        stringBuffer.append("  Signature Algorithm: ").append(this.getSigAlgName()).append(string);
        byte[] byArray = this.getSignature();
        if (byArray.length > 20) {
            stringBuffer.append("            Signature: ").append(zzvQ.zzYdk(byArray, 0, 20)).append(string);
            for (int i = 20; i < byArray.length; i += 20) {
                if (i < byArray.length - 20) {
                    stringBuffer.append("                       ").append(zzvQ.zzYdk(byArray, i, 20)).append(string);
                    continue;
                }
                stringBuffer.append("                       ").append(zzvQ.zzYdk(byArray, i, byArray.length - i)).append(string);
            }
        } else {
            stringBuffer.append("            Signature: ").append(zzvQ.zzXUO(byArray)).append(string);
        }
        zzgz zzgz2 = this.zzYRF.zzYxc().zzY68();
        if (zzgz2 != null) {
            Enumeration enumeration = zzgz2.zzXtN();
            if (enumeration.hasMoreElements()) {
                stringBuffer.append("       Extensions: \n");
            }
            while (enumeration.hasMoreElements()) {
                zzYkD zzYkD2 = (zzYkD)enumeration.nextElement();
                zz80 zz802 = zzgz2.zzXfE(zzYkD2);
                if (zz802.zzYAq() != null) {
                    byte[] byArray2 = zz802.zzYAq().zzXWx();
                    zzW8S zzW8S2 = new zzW8S(byArray2);
                    stringBuffer.append("                       critical(").append(zz802.isCritical()).append(") ");
                    try {
                        if (zzYkD2.zzYQ4(zz80.zzZTN)) {
                            stringBuffer.append(zzZ7A.zzXvr(zzW8S2.zzl8())).append(string);
                            continue;
                        }
                        if (zzYkD2.zzYQ4(zz80.zzXjP)) {
                            stringBuffer.append(zzXN8.zzXm4(zzW8S2.zzl8())).append(string);
                            continue;
                        }
                        if (zzYkD2.zzYQ4(zzZur.zzY5)) {
                            stringBuffer.append(new zzXv4(zzYah.zz4l(zzW8S2.zzl8()))).append(string);
                            continue;
                        }
                        if (zzYkD2.zzYQ4(zzZur.zzZ28)) {
                            stringBuffer.append(new zzXql(zzXtf.zzW7K(zzW8S2.zzl8()))).append(string);
                            continue;
                        }
                        if (zzYkD2.zzYQ4(zzZur.zzWg3)) {
                            stringBuffer.append(new zzZn3(zzXtf.zzW7K(zzW8S2.zzl8()))).append(string);
                            continue;
                        }
                        stringBuffer.append(zzYkD2.getId());
                        stringBuffer.append(" value = ").append(zzYOe.zzc5(zzW8S2.zzl8())).append(string);
                    }
                    catch (Exception exception) {
                        stringBuffer.append(zzYkD2.getId());
                        stringBuffer.append(" value = *****").append(string);
                    }
                    continue;
                }
                stringBuffer.append(string);
            }
        }
        return stringBuffer.toString();
    }

    @Override
    public final void verify(PublicKey key) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        Signature signature;
        String string = zzW1E.zzWcZ(this.zzYRF.zzVOz());
        try {
            signature = this.zzZAZ.zz2f(string);
        }
        catch (Exception exception) {
            signature = Signature.getInstance(string);
        }
        this.zzYQ4(key, signature);
    }

    @Override
    public final void verify(PublicKey key, String sigProvider) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException {
        String string = zzW1E.zzWcZ(this.zzYRF.zzVOz());
        Signature signature = sigProvider != null ? Signature.getInstance(string, sigProvider) : Signature.getInstance(string);
        this.zzYQ4(key, signature);
    }

    private void zzYQ4(PublicKey publicKey, Signature signature) throws CertificateException, NoSuchAlgorithmException, SignatureException, InvalidKeyException {
        if (!zzXk5.zzW07(this.zzYRF.zzVOz(), this.zzYRF.zzYxc().zzya())) {
            throw new CertificateException("signature algorithm in TBS cert not same as outer cert");
        }
        zzZV zzZV2 = this.zzYRF.zzVOz().zzYks();
        zzW1E.zzW07(signature, zzZV2);
        signature.initVerify(publicKey);
        try {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(zzXD4.zzW07(signature), 512);
            this.zzYRF.zzYxc().zzW07(bufferedOutputStream, "DER");
            ((OutputStream)bufferedOutputStream).close();
        }
        catch (IOException iOException) {
            throw new CertificateEncodingException(iOException.toString());
        }
        if (!signature.verify(this.getSignature())) {
            throw new SignatureException("certificate does not verify with supplied key");
        }
    }

    private static boolean zzW07(zzZT1 zzZT12, zzZT1 zzZT13) {
        if (!zzZT12.zzWeX().zzYQ4(zzZT13.zzWeX())) {
            return false;
        }
        if (zzW9n.zzW95("org.bouncycastle.x509.allow_absent_equiv_NULL")) {
            if (zzZT12.zzYks() == null) {
                return zzZT13.zzYks() == null || zzZT13.zzYks().equals(zzWXm.zzHw);
            }
            if (zzZT13.zzYks() == null) {
                return zzZT12.zzYks() == null || zzZT12.zzYks().equals(zzWXm.zzHw);
            }
        }
        if (zzZT12.zzYks() != null) {
            return zzZT12.zzYks().equals(zzZT13.zzYks());
        }
        if (zzZT13.zzYks() != null) {
            return zzZT13.zzYks().equals(zzZT12.zzYks());
        }
        return true;
    }

    private static Collection zzW07(zzZ8L zzZ8L2, String string) throws CertificateParsingException {
        byte[] byArray = zzXk5.zzYQ4(zzZ8L2, string);
        if (byArray == null) {
            return null;
        }
        try {
            ArrayList arrayList = new ArrayList();
            Enumeration enumeration = zzII.zzZQl(byArray).zzA2();
            block11: while (enumeration.hasMoreElements()) {
                zzf1 zzf12 = zzf1.zzZY9(enumeration.nextElement());
                ArrayList<Object> arrayList2 = new ArrayList<Object>();
                int n = zzf12.zzZRl();
                arrayList2.add(n);
                switch (zzf12.zzZRl()) {
                    case 0: 
                    case 3: 
                    case 5: {
                        arrayList2.add(zzf12.getEncoded());
                        break;
                    }
                    case 4: {
                        arrayList2.add(zzWJl.zzW07(zz9x.zzZIX, zzf12.zzWsr()).toString());
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 6: {
                        arrayList2.add(((zzZQw)((Object)zzf12.zzWsr())).getString());
                        break;
                    }
                    case 8: {
                        arrayList2.add(zzYkD.zzVYw(zzf12.zzWsr()).getId());
                        break;
                    }
                    case 7: {
                        String string2;
                        byte[] byArray2 = zzWpw.zzYD8(zzf12.zzWsr()).zzXWx();
                        try {
                            string2 = InetAddress.getByAddress(byArray2).getHostAddress();
                        }
                        catch (UnknownHostException unknownHostException) {
                            continue block11;
                        }
                        arrayList2.add(string2);
                        break;
                    }
                    default: {
                        throw new IOException("Bad tag number: " + zzf12.zzZRl());
                    }
                }
                arrayList.add(Collections.unmodifiableList(arrayList2));
            }
            if (arrayList.size() == 0) {
                return null;
            }
            return Collections.unmodifiableCollection(arrayList);
        }
        catch (Exception exception) {
            throw new CertificateParsingException(exception.getMessage());
        }
    }

    protected static byte[] zzYQ4(zzZ8L zzZ8L2, String string) {
        zzY2 zzY22 = zzXk5.zzYIm(zzZ8L2, string);
        if (zzY22 != null) {
            return zzY22.zzXWx();
        }
        return null;
    }

    private static zzY2 zzYIm(zzZ8L zzZ8L2, String string) {
        zz80 zz802;
        zzgz zzgz2 = zzZ8L2.zzYxc().zzY68();
        if (zzgz2 != null && (zz802 = zzgz2.zzXfE(new zzYkD(string))) != null) {
            return zz802.zzYAq();
        }
        return null;
    }
}

