/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.zip;

import com.aspose.zip.exceptions.ArgumentOutOfRangeException;
import com.aspose.zip.exceptions.InvalidDataException;

public class LzipArchiveSettings {
    private static LzipArchiveSettings a;
    private static LzipArchiveSettings b;
    private static LzipArchiveSettings c;
    private static LzipArchiveSettings d;
    private static LzipArchiveSettings e;
    private int f;
    private int g = 1;
    private int h;
    private byte i;

    public static LzipArchiveSettings getFastestSpeed() {
        if (a == null) {
            a = new LzipArchiveSettings(65536);
        }
        return a;
    }

    public static LzipArchiveSettings getFastSpeed() {
        if (b == null) {
            b = new LzipArchiveSettings(0x100000);
        }
        return b;
    }

    public static LzipArchiveSettings getNormal() {
        if (c == null) {
            c = new LzipArchiveSettings(0x1000000);
        }
        return c;
    }

    public static LzipArchiveSettings getHighCompression() {
        if (d == null) {
            d = new LzipArchiveSettings(0x2000000);
        }
        return d;
    }

    public static LzipArchiveSettings getMaximumCompression() {
        if (e == null) {
            e = new LzipArchiveSettings(0x4000000);
        }
        return e;
    }

    public final int getDictionarySize() {
        return this.h;
    }

    private void a(int n2) {
        this.h = n2;
    }

    final byte a() {
        return this.i;
    }

    private void a(byte by2) {
        this.i = by2;
    }

    public final long getMaxMemberSize() {
        return this.f;
    }

    public final int getCompressionThreads() {
        return this.g;
    }

    public final void setCompressionThreads(int value) {
        if (value < 1 || value > 100) {
            throw new ArgumentOutOfRangeException("value");
        }
        this.g = value;
    }

    public LzipArchiveSettings(int dictionarySize) {
        this(dictionarySize, 0x3C00000);
    }

    public LzipArchiveSettings(int dictionarySize, int maxMemberSize) {
        this.a(this.b(dictionarySize));
        this.a(this.b(this.a()));
        this.f = maxMemberSize;
    }

    LzipArchiveSettings(byte encodedDictionarySize) {
        this(encodedDictionarySize, 0x3C00000);
    }

    LzipArchiveSettings(byte encodedDictionarySize, int maxMemberSize) {
        this.a(this.b(encodedDictionarySize));
        this.a(encodedDictionarySize);
        this.f = maxMemberSize;
    }

    private byte b(int n2) {
        int n3 = 4096;
        int n4 = 0x20000000;
        if (n2 < 4096 || n2 > 0x20000000) {
            throw new ArgumentOutOfRangeException("lzmaValue", "Dictionary size does not fit valid range.");
        }
        int n5 = n2 - 1;
        int n6 = 0;
        while (n5 > 0) {
            n5 >>= 1;
            ++n6;
        }
        int n7 = 1 << n6;
        int n8 = n7 / 16;
        for (int i2 = 7; i2 >= 1; --i2) {
            if (n7 - i2 * n8 < n2) continue;
            n6 |= i2 << 5;
            break;
        }
        return (byte)n6;
    }

    private int b(byte by2) {
        if ((by2 & 0xFF & 0x1F) < 12 || (by2 & 0xFF & 0x1F) > 29) {
            throw new InvalidDataException("Base size is in invalid range.");
        }
        int n2 = (by2 & 0xFF) >> 5;
        if (n2 > 7) {
            throw new InvalidDataException("Fraction number is in invalid range.");
        }
        int n3 = 1 << (by2 & 0xFF & 0x1F);
        int n4 = 4096;
        if (n3 > n4) {
            n3 -= n3 / 16 * ((by2 & 0xFF) >> 5 & 7);
        }
        return n3;
    }
}

